/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)time.h	5.12 (Berkeley) 3/9/91
 *	$Id: stdlib.h,v 1.1 1994/12/23 13:31:59 proven Exp $
 */

#ifndef _STDLIB_H_
#define	_STDLIB_H_

#include <sys/__stdlib.h>

/* Returned by `div'.  */
typedef struct
  {
    int quot;   /* Quotient.  */
    int rem;    /* Remainder.  */
  } div_t;

/* Returned by `ldiv'.  */
typedef struct
  {
    long quot;  /* Quotient.  */
    long rem;   /* Remainder.  */
  } ldiv_t;

#ifndef RAND_MAX
#define RAND_MAX			2147483647
#endif

#define EXIT_FAILURE    	1       /* Failing exit status.  */
#define EXIT_SUCCESS    	0       /* Successful exit status.  */

#include <sys/cdefs.h>

__BEGIN_DECLS

double			atof 		__P((const char *));
int				atoi 		__P((const char *));
long			atol 		__P((const char *));
double			strtod 		__P((const char *, char **));
long			strtol 		__P((const char *, char **, int));
unsigned long	strtoul 	__P((const char *, char **, int));

int				rand		__P((void));
void			srand		__P((unsigned int));

long			random		__P((void));
void			srandom		__P((unsigned int));
char 		  * initstate	__P((unsigned int, char *, int));
char 		  * setstate	__P((char *));

void		  * malloc		__P((size_t));
void 		  * realloc		__P((void *, size_t));
void		  * calloc		__P((size_t, size_t));
void			free		__P((void *));

__NORETURN void	abort		__P((void));
int				atexit		__P((void (* __func)() ));
__NORETURN void	exit		__P((int));

char		 **	environ;

char		  * getenv		__P((const char *));
int 			putenv		__P((const char *));
int				setenv		__P((const char *, const char *, int));
void			unsetenv	__P((const char *));

int				system		__P((const char *));
void		  * bsearch		__P((const void *, const void *, size_t, size_t,
							void (* __func)() ));
void		   	qsort		__P((void *, size_t, size_t, void (* __func)() ));

int				abs			__P((int));
long			labs		__P((long));
div_t			div			__P((int, int));
ldiv_t			ldiv		__P((long, long));

int				mblen		__P((const char *, size_t));
int				mbtowc		__P((wchar_t *, const char *, size_t));
int				wctomb		__P((char *, wchar_t));
size_t			mbstowcs	__P((wchar_t *, const char *, size_t));
size_t			wcstombs	__P((char *, const wchar_t *, size_t));


__END_DECLS

#endif /* !_STDLIB_H_ */
