
#include <pthread.h>
#include <resolv.h>
#include <netdb.h>
#include "res_internal.h"

#if PACKETSZ > 1024
#define MAXPACKET	PACKETSZ
#else
#define MAXPACKET	1024
#endif

int res_query(char *name, int class, int type, unsigned char *answer,
	      int anslen)
{
    struct res_data *data;
    char buf[MAXPACKET];
    int result;
    HEADER *hp;

    data = _res_init();
    if (!data)
	return -1;

    /* Make the query. */
    result = res_mkquery(QUERY, name, class, type, NULL, 0, NULL, buf,
			 sizeof(buf));
    if (result <= 0) {
	data->errval = NO_RECOVERY;
	return result;
    }

    result = res_send(buf, result, (char *) answer, anslen);
    if (result < 0) {
	data->errval = TRY_AGAIN;
	return result;
    }

    hp = (HEADER *) answer;
    if (hp->rcode == NOERROR && ntohs(hp->ancount != 0))
	return result;

    /* Translate the error code and return. */
    switch(hp->rcode) {
      case NOERROR:
	data->errval = NO_DATA;
	break;
      case SERVFAIL:
	data->errval = TRY_AGAIN;
	break;
      case NXDOMAIN:
	data->errval = HOST_NOT_FOUND;
	break;
      default:
	data->errval = NO_RECOVERY;
	break;
    }
    return -1;
}

