/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)getnetbyname.c	5.7 (Berkeley) 2/24/91";*/
static char *rcsid = "$Id: getnetbyname.c,v 1.4 1995/01/06 10:46:05 ghudson Exp $";
#endif /* LIBC_SCCS and not lint */

#include <netdb.h>
#include <string.h>
#include "net_internal.h"

/* Old interface: search using thread-specific file and return pointer to
 * thread-specific data. */
struct netent *getnetbyname(const char *name)
{
	struct net_data *data = _net_init();
	struct netent *r;
	
	if (!data)
		return NULL;
	r = getnetbyname_r_file(name, &data->net_answer, &data->netfp);
	if (!data->keep_netfp_open)
		endnetent_r(&data->netfp);
	return r;
}

/* Thread-safe interface, using internal file (closed at end). */
struct netent *getnetbyname_r(const char *name, struct netent_answer *result)
{
	FILE *fp = NULL;
	struct netent *r;
	
	r = getnetbyname_r_file(name, result, &fp);
	endnetent_r(&fp);
	return r;
}

/* Thread-safe interface with provided file, which remains open. */
struct netent *getnetbyname_r_file(const char *name,
								   struct netent_answer *result, FILE **fp)
{
	struct netent *p;
	char **cp;
	
	setnetent_r(fp);
	while (p = getnetent_r(result, fp)) {
		if (strcmp(p->n_name, name) == 0)
			return p;
		for (cp = p->n_aliases; *cp != 0; cp++) {
			if (strcmp(*cp, name) == 0)
				return p;
		}
	}
	return NULL;
}

