/* [gsstark:19950118.0602EST] This file is taken directly from BSD 4.4lite 
   /usr/src/usr.bin/finger/net.c (sccsid: 8.3 (Berkeley) 1/2/94)

   some modifications to ANSIfy and otherwise sanitize the code
*/

/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Tony Nardo of the Johns Hopkins University/Applied Physics Lab.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <assert.h>

#ifdef THREADED
#include <pthread.h>
#endif THREADED

#ifndef perror
#define perror(string) fprintf(stderr,"%s:%d %s\n", string, errno, strerror(errno))
#endif

void netfinger(const char *name, const char *host, int lflag)
{
  FILE *fp;
  int c, lastc;
  struct in_addr defaddr;
  struct hostent *hp, def;
  struct servent *sp;
  struct sockaddr_in sin;
  int s;
  char *alist[1];
  
  assert(name); assert(host);

  if (isdigit(*host) && (defaddr.s_addr = inet_addr(host)) != -1) 
    {
      def.h_name = (char *)host;
      def.h_addr_list = alist;
      def.h_addr = (char *)&defaddr;
      def.h_length = sizeof(struct in_addr);
      def.h_addrtype = AF_INET;
      def.h_aliases = 0;
      hp = &def;
    } 
  else if (!(hp = gethostbyname(host))) 
    {
      fprintf(stderr, "%s: unknown host (%d)\n", host, errno);
      return;
    }

  /* [gsstark:19950118.0643EST] we will probably have to do this much earlier */
  if (!(sp = getservbyname("finger", "tcp"))) 
    {
      fprintf(stderr, "finger: tcp/finger: unknown service (%d)\n",errno);
      return;
    }

  sin.sin_family = hp->h_addrtype;
  memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);
  sin.sin_port = sp->s_port;

  if ((s = socket(sin.sin_family, SOCK_STREAM, 0)) < 0) 
    {
      fprintf(stderr, "[%s] socket: %s\n", hp->h_name, strerror(errno));
      return;
    }

/*[gsstark:19950118.0641EST] we defer printing hostname till we know we have data
  otherwise we would have to lock the output stream and block other threads */

  if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) 
    {
      fprintf(stderr, "[%s] connect: %s\n", hp->h_name, strerror(errno));
      close(s);
      return;
    }
  
  /* -l flag for remote fingerd  */
  if (lflag)
    write(s, "/W ", 3);
  /* send the name followed by <CR><LF> */
  write(s, name, strlen(name));
  write(s, "\r\n", 2);

  /*
   * Read from the remote system; once we're connected, we assume some
   * data.  If none arrives, we hang until the user interrupts.
   *
   * If we see a <CR> or a <CR> with the high bit set, treat it as
   * a newline; if followed by a newline character, only output one
   * newline.
   *
   * Otherwise, all high bits are stripped; if it isn't printable and
   * it isn't a space, we can simply set the 7th bit.  Every ASCII
   * character with bit 7 set is printable.
   */ 
  
  /*
     [gsstark:19950118.0656EST] gosh what a pile of crap.
     I want the thread to block until it gets some data then 
     flock the output stream and print everything. 
     so I'll reorganize this.   */



  if (!(fp=fdopen(s,"r")))
    {
      fprintf(stderr,"finger: Can't fdopen socket file descriptor (%d)\n",errno);
      close(s);
      return;
    }

  
  /* [gsstark:19950118.0709EST] 
     now that we've blocked until there was at least some data coming in 
     we print the hostname and get on with the translation such as it is */

  lastc='\0';
  do {c=getc(fp);} while(c=='\n' || c== '\r');

#ifdef THREADED
  flockfile(stdout);
#endif
  printf("[%s]\n", hp->h_name);
  
    while (c != EOF)
      {
	c &= 0x7f;
	/* skip any \r's or \n's following a \r (which gets printed as a \n) */
	if (!((c=='\n' || c=='\r') && lastc=='\r'))
	  {	  
	    if (c=='\r')
	      lastc='\r',c='\n';
	    else
	      if (!isprint(c) && !isspace(c))
		lastc = c |= 0x40;
	      else
		lastc = c;
	    putchar(c);
	  }
	c=getc(fp);
      }
  if (lastc != '\n' && lastc != '\r')
    putchar('\n');  
  putchar('\n');
#ifdef THREADED
  funlockfile(stdout);
#endif
  fclose(fp);
}
