/* stdarg.h  standard header
 * $Version: 1.2 $
 * Copyright (C) 1993 Intel Corporation, ALL RIGHTS RESERVED
 */

#ifndef _STDARG
#define _STDARG

#include <yvals.h>

/*
 * type definitions
 */

#ifndef _VALIST
#define _VALIST
typedef char *va_list;
#endif

/*
 * macro definitions
 */

#define va_arg(ap, T) \
   (*(T *)(((ap) += _Bnd(T, _AUPBND)) - _Bnd(T, _ADNBND)))
#define va_end(ap)    (void)0 
#define va_start(ap, A) \
   (void) ((ap) = (char *)&(A) + _Bnd(A, _AUPBND))
#define _Bnd(X, bnd)    (sizeof(X) + (bnd) & ~(bnd))

#endif /* _STDARG */

