/* This was taken from /afs/sipb/user/jhawk/src/fixpain/fixpain.c,
   some code to restart pain.lcs.mit.edu */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/un.h>
#include <sys/uio.h>
#include <net/if.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

#include "router.h"

#define ARP 0
#define IP 1

#define DEFAULT_ETHER_ADDR "8:0:20:75:6c:8a"
#define DEFAULT_IP_ADDR "18.70.0.26"
#define DEFAULT_DEST_IP_ADDR "18.70.0.28"

void usage(char *prog) {
    fprintf(stderr, 
	    "Usage: %s interface type length [ether] [my_ip] [dest_ip]\n"
	    "interface = [0|1] interface to send to\n"
	    "type = [ip|arp] type of packet to send\n"
	    "length = amount of data in payload\n"
	    "[ether] = ethernet address to send from\n"
	    "[my_ip] = ip address to send from\n"
	    "[dest_ip] = ip address to send to\n",
	    prog);
    exit(1);
}
    
    

void main(int argc, char *argv[]) {
    int ifx, len, rc, sock, x, type, ulen;
    char packet[1000]; int plen; char *p;

    struct ether_header ehead;
    struct ip iphead;
    struct sockaddr_un serv;
    struct ether_arp arp;
    struct ether_addr my_ether_addr, dest_ether_addr;
    unsigned long my_ip_addr, dest_ip_addr;
    struct in_addr temp;
  
    if (argc < 4)
	usage(argv[0]);

    ifx = atoi(argv[1]);
    if ((ifx != 0) && (ifx != 1)) {
	fprintf(stderr, "Invalid interface %d\n", ifx);
	exit(1);
    }
    if (!strncmp(argv[2], "ip", 2))
	type = IP;
    else if (!strncmp(argv[2], "arp", 3))
	type = ARP;
    else {
	fprintf(stderr, "Invalid type %s\n", argv[2]);
	exit(1);
    }
    ulen = atoi(argv[3]);
    
    if (argc >= 5) {
	memcpy(&my_ether_addr, (char*)ether_aton(argv[4]),
	       sizeof(struct ether_addr));
    }
    else {
	memcpy(&my_ether_addr, (char*)ether_aton(DEFAULT_ETHER_ADDR),
	       sizeof(struct ether_addr));
    }

    if (argc >= 6) {
	my_ip_addr = inet_addr(argv[5]);
    } else {
	my_ip_addr = inet_addr(DEFAULT_IP_ADDR);
    }
    if (my_ip_addr == -1) 
	usage(argv[0]);

    if (argc >= 7) {
	dest_ip_addr = inet_addr(argv[6]);
    } else {
	dest_ip_addr = inet_addr(DEFAULT_DEST_IP_ADDR);
    }
    if (dest_ip_addr == -1) 
	usage(argv[0]);
    

    if (ifx == 0)
	memcpy(&dest_ether_addr, (char*)ether_aton(ETH0_ETHER_ADDR),
	       sizeof(struct ether_addr));
    else 
	memcpy(&dest_ether_addr, (char*)ether_aton(ETH1_ETHER_ADDR),
	      sizeof(struct ether_addr));

	/* open socket first -- everything else is useless if we have
	   no connection */
    
    sock = socket(AF_UNIX, SOCK_STREAM, 0);
    ERR(sock);

    memset(&serv, 0, sizeof(serv));
    serv.sun_family = AF_UNIX;
    if (ifx == 0)
	strcpy(serv.sun_path, ETH0_PATHNAME);
    else
	strcpy(serv.sun_path, ETH1_PATHNAME);

    len = strlen(serv.sun_path) + sizeof(serv.sun_family) + 1;
#if defined(__NetBSD__)
    serv.sun_len = len;
#endif
    rc = connect(sock,
		 (struct sockaddr *)&serv, 
		 len);
    ERR(rc);

	/* Ok, now build our packer, layer by layer */

    p=packet;
  
    memcpy(&ehead.ether_shost, &my_ether_addr,
	  sizeof(struct ether_addr));
    memcpy(&ehead.ether_dhost, &dest_ether_addr, sizeof(struct ether_addr));
    if (type == IP)
	ehead.ether_type = htons(ETHERTYPE_IP);
    else
	ehead.ether_type = htons(ETHERTYPE_ARP);
    temp.s_addr = my_ip_addr;
    printf("From %s/%s",
	   inet_ntoa(temp),
	   (char *)ether_ntoa((struct ether_addr *)&ehead.ether_shost));
    temp.s_addr = dest_ip_addr;
    printf(" to %s/%s\n", 
	   inet_ntoa(temp),
	   (char *)ether_ntoa((struct ether_addr *)&ehead.ether_dhost));
    
    memcpy(p, &ehead, sizeof(ehead));
    p+=sizeof(ehead);
    
    if (type == ARP) {
	arp.ea_hdr.ar_hrd = htons(ARPHRD_ETHER);
	arp.ea_hdr.ar_pro = htons(ETHERTYPE_IP);
	arp.ea_hdr.ar_hln = 6; /* ethernet addresses are 48bits */
	arp.ea_hdr.ar_pln = 4; /* ip addresses are 32bits */
	arp.ea_hdr.ar_op = htons(ARPOP_REQUEST);
	memcpy(&arp.arp_sha, &my_ether_addr,
	       sizeof(struct ether_addr));
 	*(unsigned long *)&arp.arp_spa = htonl(my_ip_addr);
	memcpy(&arp.arp_tha, &dest_ether_addr, sizeof(struct ether_addr));
	*(unsigned long *)&arp.arp_tpa = htonl(dest_ip_addr);

	memcpy(p, &arp, sizeof(arp));
	p+=sizeof(arp);
    }
    else {	/* IP */
	iphead.ip_hl=5; /* 32 bits */
	iphead.ip_v=4; /* ipv4 */
	iphead.ip_tos=0; /*normal precedence, delay, throughput, reliability */
	iphead.ip_len=htons(sizeof(iphead)+ulen); /* header+body */
	iphead.ip_id= htons(0x1234); /* random fragment id */
	iphead.ip_off=0; /* no offset */
	iphead.ip_ttl= 30; /* time to live */
	iphead.ip_p = IPPROTO_TCP; /* protocol */
	iphead.ip_sum = 0; /* set to 0 for checksum computation later */

	*(unsigned long *)&iphead.ip_src = htonl(inet_addr("128.52.46.239"));
	*(unsigned long *)&iphead.ip_dst = htonl(dest_ip_addr);

	    /* Set checksum */
	    /*    iphead.ip_sum = in_cksum(&iphead, iphead.ip_hl << 4); */
	
	memcpy(p, &iphead, sizeof(iphead));
	p+=sizeof(iphead);
    }
    
	/* build up a fake payload */
    for(x=0; x<ulen; x++) 
	*p++=x;
  
    plen=p-packet;
    printf("Total packet length is %d.\n", plen);
    
    p = packet;
	/* ok, now get ready to send the packet out */
    while (plen > 0) {
	rc = write(sock, p, plen);
	ERR(rc);
	printf("wrote %d\n", rc);
	plen-=rc; /* subtract number of bytes actually written */
	p += rc;
    }
}

/********************************* err_handler *******************************/
void err_handler(u16 line, char *fname, u16 status) {
    perror(NULL);
    fprintf(stderr, "Error %d occurred at %s:%d\n", errno, fname, line);
    exit(status);
}
