#include "ps5/normal_response.h"
#include "ps5/simple_response.h"
#include "ps5/expired_response.h"

#include <time.h>

normal_response::normal_response(bool html) {
	html_response = html;
};

void normal_response::body(ostream &o) {
	if (html_response) http_response::body(o);
	else o << "Default plain text response\n";
}

string normal_response::content_type() {
    if (html_response) return "text/html";
    else return "text/plain";
}

simple_response::simple_response(string text, bool html)
    : normal_response(html)
{
    response_text = text;
}

void simple_response::body(ostream &o) {
    o << response_text;
}

expired_response::expired_response(bool html)
    : normal_response(html) {
}

void expired_response::headers(ostream &o) {
    http_response::headers(o);
    o << "Expires: ";
    time_t t = time(0);
    string s = asctime(gmtime(&t));
    o << s << '\n'; // Browser better be flexible about accepting ctime format.
// Format we SHOULD use: Friday, 19-Nov-82 16:59:30 EST
//                   or: Thursday, 2-Mar-95 01:01:00 PDT
}
