/* $header: /afs/athena/user/f/o/foley/src/CVSROOT/6.270/src/fly_by_wire.c,v 1.6 1997/01/19 10:58:18 daveg Exp $
 * Desc: line follower control system
 * Common usage: 
 * $Author: daveg $
 */

#define SPEAR 1

void InitFBW() {
    current_direction = STRAIGHT;
    old_direction = STRAIGHT;
    servo_on();
    servo_deg(CENTER);
    enable_encoder(DRIVE_ENCODER);
    reset_encoder(DRIVE_ENCODER);
    Location = STARTING_SQUARE;
}

void EndFBW() {
  servo_deg(CENTER);
  servo_off();
  disable_encoder(DRIVE_ENCODER);
}

void FlyByWire() {
  int spear_done = 0;
  /* routine for continuosly going along line until we hit the end 
     mostly a checking of status/state */

    start_process(SpearBlock(RAISE_SPEAR_TIME), 15, 100);
    printf("Press Choose Button to stop\n");

    while(!choose_button() && (Location != CROSS) && 
	  (analog(FRONT_BUMPER) > BUMP_SENSOR_THRESHOLD)) {
	CheckRefls(FRONT);
	CheckRefls(MID);
/*	CheckRefls(BACK);  */
	ARTSteer();
	DetermineLocation(&spear_done);
	msleep(100L);
    }
    
    return;
}

void ARTSteer() {
  int r,l;

#if(0)
  if(Refl_Grid[MR].Value == Refl_Grid[ML].Value) {
    /* Fine adjustment. */
    r=FR;
    l=FL;
  } else {
    r=MR;
    l=ML;
  }
#else
  r=MR;
  l=ML;
#endif

  if(Refl_Grid[r].Value == Refl_Grid[l].Value) {
    current_direction=STRAIGHT;
  } else if (Refl_Grid[l].Value == BLACK) {
    current_direction=LEFT;
  } else {
    current_direction=RIGHT;
  }
  old_direction=current_direction;
  servo_deg(current_direction);
}

void Steer4() {
    int branch = -1;
    int fr, fl, mr, ml, mm;
    fr = Refl_Grid[FR].Value;
    fl = Refl_Grid[FL].Value;
    mr = Refl_Grid[MR].Value;
    ml = Refl_Grid[ML].Value;
    
    if ((fr == BLACK) && (fl == BLACK)) {
	if (mr==ml)
	    current_direction = STRAIGHT;
	else if (mr == BLACK)
	    current_direction = SOFT_RIGHT;
	else if (ml == BLACK)
	    current_direction = SOFT_LEFT;
	branch = 0;
    }
    else if ((fr == WHITE) && 
	     (fl == WHITE)) {
	if ((mr == WHITE) && 
	    (ml == WHITE)) {
	    current_direction = STRAIGHT;
	    branch = 1;
	}
	else if ((mr == BLACK) && 
		 (ml == BLACK)) {
		/* This is a very temporary solution... */
	    current_direction = HARD_LEFT;
	    beep();
	    branch = 2;
	}
	else if (mr == BLACK) {
	  current_direction=RIGHT;
	  branch = 3;
	}
	else if (ml == BLACK) {
	  current_direction=LEFT;
	  branch = 4;
 	}
    }
    else if (fr == BLACK) {
	if ((mr == WHITE) &&
	    (ml == WHITE))
	    current_direction = SOFT_RIGHT;
	else if ((mr == BLACK) &&
		 (ml == BLACK))
	    current_direction = SOFT_RIGHT;
	else if (mr == BLACK) 
	    current_direction = RIGHT;
	else if (ml == BLACK)
	    current_direction = HARD_RIGHT;
	branch = 5;
    }
    else if (fl == BLACK) {
	if ((mr == WHITE) &&
	    (ml == WHITE))
	    current_direction = SOFT_LEFT;
	else if ((mr == BLACK) &&
		 (ml == BLACK))
	    current_direction = SOFT_LEFT;
	else if (mr == BLACK) 
	    current_direction = LEFT;
	else if (ml == BLACK)
	    current_direction = HARD_LEFT;
	branch = 6;
    }
    
    old_direction = current_direction;
    printf("%f [%d]: %d %d %d %d\n", current_direction, branch,
	   mr, ml, fr, fl);
    servo_deg(current_direction);
}

void Steer5() {
  int branch=-1;
  int fr, fl, mr, ml, mm;
  fr = Refl_Grid[FR].Value;
  fl = Refl_Grid[FL].Value;
  mr = Refl_Grid[MR].Value;
  mm = Refl_Grid[MM].Value;
  ml = Refl_Grid[ML].Value;

  if(mm == BLACK) {
    /* On a line. */
    if(ml == mr) {
      /* both black or both white */
      if(fl == fr) {
	current_direction=CENTER;
      } else if(fl == BLACK) {
	current_direction=SOFT_LEFT;
      } else {
	current_direction=SOFT_RIGHT;
      }
      branch=1;
    } else if(mr == BLACK) {
      current_direction=RIGHT;
      branch=2;
    } else {
      current_direction=LEFT;
      branch=3;
    }
  } else {
    /* Not on a line. */
    if((ml == WHITE) && (mr==WHITE)) { 
      /* all mids on white */
      if(fr == fl) {
	current_direction=STRAIGHT;
	branch=4;
      } else if(fr==BLACK) {
	/* this is hoping we're approaching edge of start box -- should
	   consider making this part location dependent */
	current_direction=SOFT_RIGHT;
	branch=5;
      } else {
	current_direction=SOFT_LEFT;
	branch=6;
      }
    } else if((ml==BLACK) &&(mr==BLACK)) {
      /* This should be impossible */
      current_direction=old_direction;
      branch=7;
    } else if(ml == BLACK) {
      current_direction=HARD_LEFT;
      branch=8;
    } else {
      current_direction=HARD_RIGHT;
      branch=9;
    }
  }
  old_direction = current_direction;
  printf("%f [%d]: %d %d %d %d %d\n", current_direction, branch,
	 fr, fl, mr, mm, ml);
  servo_deg(current_direction);
}

void OldSteer() {
  if (Refl_Grid[FR].Value == BLACK) {
     if (Refl_Grid[FL].Value == BLACK)
	    current_direction = STRAIGHT;
	else    /* off to the left */
	    current_direction = RIGHT;
    }
    else {
	if (Refl_Grid[FL].Value == BLACK)  /* off to the right */
	    current_direction = LEFT;
	else {
	    if ((old_direction == LEFT) || (old_direction == HARD_LEFT))
		current_direction = HARD_LEFT;
	    else if ((old_direction == RIGHT) || (old_direction == HARD_RIGHT))
		current_direction = HARD_RIGHT;
	    else
		current_direction = STRAIGHT;  /* We haven't reached anything 
						  yet, so might as well keep
						  going straight */
	}
    }
    old_direction = current_direction;
    servo_deg(current_direction);
}

void CheckRefls(int segment) {
    int l, r;
    int rtemp, ltemp, mtemp;
    int mm_check = FALSE;  /* kludge, ask daveg for better way -FOLEY */

    if (segment == FRONT) {
	r = FR;
	l = FL;
    }
    else if (segment == MID) {
	r = MR;
	l = ML;
	mm_check = TRUE;
    }
    else {
	r = BR;
	l = BL;
    }	

    rtemp = analog(Refl_Grid[r].Sensor);
    ltemp = analog(Refl_Grid[l].Sensor);

    if (rtemp > Refl_Grid[r].BlackThreshold)
	Refl_Grid[r].Value = BLACK;
    else if (rtemp < Refl_Grid[r].WhiteThreshold)
	Refl_Grid[r].Value = WHITE;

    if (ltemp > Refl_Grid[l].BlackThreshold)
	Refl_Grid[l].Value = BLACK;
    else if (ltemp < Refl_Grid[l].WhiteThreshold)
	Refl_Grid[l].Value = WHITE;

    if(mm_check) {
	mtemp = analog(Refl_Grid[MM].Sensor);
	if (mtemp > Refl_Grid[MM].BlackThreshold)
	    Refl_Grid[MM].Value = BLACK;
	else if (mtemp < Refl_Grid[MM].WhiteThreshold)
	    Refl_Grid[MM].Value = WHITE;
    
    }
}

void DetermineLocation(int *spear_done) {
    int distance = read_encoder(DRIVE_ENCODER);

    if (Location == STARTING_SQUARE) {
	if ((Refl_Grid[MR].Value == BLACK) && (Refl_Grid[ML].Value == BLACK))
	    Location = SQUARE_EDGE;
    }
    else if (Location == SQUARE_EDGE) {
	if ((Refl_Grid[MR].Value == WHITE) || (Refl_Grid[ML].Value == WHITE))
	    Location = SEGMENT_ONE;
    }
    else if ((Location == SEGMENT_ONE) && (distance > NEAR_CROSS)) {
	if (Refl_Grid[MR].Value == BLACK && Refl_Grid[ML].Value == BLACK)
	    Location = CROSS;
    }
#if(SPEAR)
    if ((*spear_done == 0) && (distance >= NEAR_FIRST_BLOCK)) {
      *spear_done = 1;
      start_process(SpearBlock(SPEAR_BLOCK_TIME), 15, 100);
    }
#endif
#if(1)
    if (distance > DISTANCE_TO_CROSS)
	Location = CROSS;
#endif
}


