int CheckDirection() {
	/* this is better method of determining direction */
    int north, south, east, west, min, n;
    int mincount, savemin = -1;
    north = south = east = west = min = n = mincount = 0;
    
	/* difference here - brightest light is opposite of where we 
	 * want to go.  Bright = minimum
	 */
    while (mincount < 2) {
	while(n<3) {
	    north = analog(NORTH_PHOTO);
	    south = analog(SOUTH_PHOTO);
	    east = analog(EAST_PHOTO);
	    west = analog(WEST_PHOTO);
	    min = MIN(MIN(north, south), MIN(east, west));
	    n = 0;
	    if(min<north-10) n++;
	    if(min<south-10) n++;
	    if(min<east-10) n++;
	    if(min<west-10) n++;
	}
	if (min == savemin)
	    mincount++;
	else
	    savemin = min;
	msleep(1L);
    }
  
    if (min == north)
	return(SOUTH);
    else if (min == south)
	return(NORTH);
    else if (min == east)
	return(EAST);
    else
	return(WEST);
}

int CheckDirectionIR() {
	/* This is just some temp code to try doing ir location */
    int north, south, east, west, max, n;
    
    ir_receive_on();
    set_ir_receive_frequency(TheirFrequency);
    msleep(100L); /* Must wait at least 100 ms between start and valid data */

    north = south = east = west = max = n = 0;
    
    while(n<3) {
	north = ir_counts(NORTH_IR);
	south = ir_counts(SOUTH_IR);
	east  = ir_counts(EAST_IR);
	west  = ir_counts(WEST_IR);
	max = MAX(MAX(north, south), MAX(east, west));
	n = 0;
	if(max>north+3) n++;
	if(max>south+3) n++;
	if(max>east+3) n++;
	if(max>west+3) n++;
    }
    
    ir_receive_off();

    if (max == north)
	return(NORTH);
    else if (max == south)
	return(SOUTH);
    else if (max == east)
	return(EAST);
    else
	return(WEST);
}

void RotateToNorth(int direction) {
  int motor_dir, distance, tqmotor_dir, oclicks, nclicks;
    
    if (direction == NORTH)
	return;
    
    if (direction == EAST) {
return;
	motor_dir = ROTATOR_CLOCKWISE;
	distance = RIGHT_ANGLE_DISTANCE;
    }
    else if (direction == WEST) {
return;
	motor_dir = ROTATOR_COUNTER_CLOCKWISE;
	distance = RIGHT_ANGLE_DISTANCE;
    }
    else {
	motor_dir = ROTATOR_COUNTER_CLOCKWISE;
	distance = HALF_TURN_DISTANCE;
    }

  oclicks = distance / 10;
  nclicks = 9*oclicks;
  tqmotor_dir = (motor_dir * 3)/4;

    enable_encoder(ROTATOR_ENCODER);
    reset_encoder(ROTATOR_ENCODER);
    
  motor(ROTATOR_SPIN, tqmotor_dir);
  while(read_encoder(ROTATOR_ENCODER) < oclicks) defer();

  motor(ROTATOR_SPIN, motor_dir);
  while(read_encoder(ROTATOR_ENCODER) < nclicks) defer();

  motor(ROTATOR_SPIN, tqmotor_dir);
  while(read_encoder(ROTATOR_ENCODER) < distance) defer();
	
  motor(ROTATOR_SPIN, STOP);
  
    disable_encoder(ROTATOR_ENCODER);
}
