/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */


#include "closure.h"
#include "lbc.h"
#include "stream.h"
#include "cont.h"

LLTag llclosure_t;
LLTag llcfunc_t;

LLClosure *llmake_closure (bytecode, objects, arglist, env)
     LLString *bytecode;
     LLVector *objects;
     LLCons *arglist;
     LLEnv *env;
{
  LLClosure *c;
  
  c = (LLClosure *) llmake_obj(llclosure_t);
  c->bytecode = bytecode;
  c->objects = objects;
  c->arglist = arglist;
  c->env = env;
  return c;
}

static void touch_closure (closure)
     LLClosure *closure;
{
  lltouch_obj((LLObj *) closure->bytecode);
  lltouch_obj((LLObj *) closure->objects);
  lltouch_obj((LLObj *) closure->env);
  lltouch_obj((LLObj *) closure->arglist);
}

static void open_closure (closure, nargs)
     LLClosure *closure;
     int nargs;			/* Number of arguments passed to closure */
{
  LLEnv *newenv; 
  LLCons *arglist;

  newenv = llmake_child_env(closure->env); 
  arglist = closure->arglist ;
  while(nargs--) {		/* bind stuff on arg stack to arglist 
				   and shove it into the new environment */
    if (arglist == (LLCons *) NIL) llerror(LLTOO_MANY_ARGS); 

    if(llis_cons(arglist)) {
      add_env(newenv , llccar(arglist) , llpoparg());
      arglist = (LLCons *) llccdr(arglist);
    } else {

      /* handle the " . rest) " in lambda forms*/
      llargc = nargs + 1;
      lllist();
      add_env(newenv, arglist, llpoparg());

      arglist = (LLCons*)NIL;
      nargs = 0; /* this effectively does a break */
    }
  }

  if((arglist == (LLCons*)NIL)  && (nargs >= 0) )
    llerror(LLTOO_FEW_ARGS);

  /* handle . rest if there is no rest to bind to */
  if((arglist != (LLCons*)NIL)  && !llis_cons(arglist))
    add_env(newenv, arglist, NIL);


				/* This function call will warp the current
				   continuation, but will return immediately!
				   Presumable, open_closure was called out
				   of llrun_byte_code... */
  llccall_bytecode (closure->bytecode, closure->objects, newenv);
}

static void call_cfunc(cfunc, nargs)
     LLCfunc *cfunc;
     int nargs;
{
  llargc = nargs;		/* Assign global argument count */
  (*cfunc->func)();
}

/* Apply the given closure (or force the delay or 
   reenter the continuation) with the given number of arguments
   on the current continuation's argument stack */
void llcapply(thing, nargs)
     LLObj *thing;
     int nargs;
{
  if (llis_closure(thing))
    open_closure((LLClosure *) thing, nargs);
  else if (llis_cfunc(thing))
    call_cfunc((LLCfunc *) thing, nargs);
  else if (llis_cont(thing))
    llcreenter_cont((LLCont *) thing);
  else {
    llprint_obj(thing, s_stderr);
    llerror(LLBAD_FUNCTION);
  }
  llcmaybe_gc();
}

void llapply()
{
  llcapply(llpoparg(), llargc);
}

void llregister_cfunc(func, name)
     void (*func)();
     char *name;
{
  LLCfunc *c;

  c = (LLCfunc *) llmake_obj(llcfunc_t);
  c->func = func;
  c->name = name;
  add_env(tlge, llcstring_to_sym(name), c);
}

void llinit_closure ()
{
  llclosure_t = lladd_obj_td(sizeof(LLClosure), "Closure",
			     0, touch_closure, 0, 0);
  llcfunc_t = lladd_obj_td(sizeof(LLCfunc), "C-Function",
			   0, 0, 0, 0);
}
