/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */


#ifndef _CONS_INC
#define _CONS_INC

#include "obj.h"

typedef struct Cons_s {
  LLIS_OBJECT;
  LLObj *a;
  LLObj *d;
} LLCons;

extern LLTag llcons_t;
#define llcmake_cons(a,d) _llcmake_cons((LLObj *)a, (LLObj *)d)
#define llis_cons(o) (llobj_tag(o) == llcons_t)
#define llccar(c) (((LLCons *)(c))->a)
#define llccdr(c) (((LLCons *)(c))->d)
#define llis_list(obj) (llclength(obj) != -1)
void llcar(); 
void llcdr(); 

int llclength();
LLCons *read_cons();
LLCons *_llcmake_cons();
void llinit_cons();

#endif
