/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include <stdio.h>
#include "sym.h"
#include "error.h"
#include "cont.h"

jmp_buf llerror_toplevel; 

static char* llerror_extra = 0;

void llinterrupt()
{
  llerror(LLNO_MESSAGE);
}

llerror_set_extra(extra)
     char* extra;
{
  llerror_extra = extra;
}

llerror_recover(msg) 
     LLError msg;
{
  char *errmsg ;

  switch( msg ) {
  case LLNO_ERROR:
    return; 
  case LLEMPTY_STACK: 
    errmsg = "Out of Stack Objects";
    break; 
  case LLREAD_ONLY_STREAM: 
    errmsg = "Read Only Stream"; 
    break;
  case LLNOT_A_FILE:
    errmsg = "Stream Not a File";
    break;
  case LLTOO_FEW_ARGS:
    errmsg = "Too Few Arguments";
    break;
  case LLARGS_OUT_OF_RANGE:
    errmsg = "Arguments Out Of Range"; 
    break;
  case LLTOO_MANY_ARGS:
    errmsg = "Too Many Arguments";
    break;
  case LLEND_OF_STREAM: 
    errmsg = "Unexpected End of Stream";
    break;
  case LLBAD_LIST:
    errmsg = "Malformed List";
    break;
  case LLSYNTAX_ERROR: 
    errmsg = "Syntax Error in Read"; 
    break; 
  case LLTYPE_ERROR: 
    errmsg = "Invalid Argument Type"; 
    break; 
  case LLBAD_FUNCTION: 
    errmsg = "Attemp to call non-function";
    break;
  case LLWRONG_NARGS: 
    errmsg = "Wrong Number of Arguments"; 
    break;
  case LLUNBOUND_SYMBOL: 
    errmsg = "Unbound Symbol";
    break;
  case LLBAD_LAMBDA: 
    errmsg = "Attempt to Compile Bad Lambda Expression"; 
    break;
  case LLCOMP_OUT_OF_SPACE: 
    errmsg = "Compiler Out of Space";
    break;
  case LLBAD_FORM:
    errmsg = "Compiler: Bad Form";
    break; 
  case LLTOO_MANY_TDS:
    errmsg = "Too Many Different Types";
    break;
  case LLREAD_ERROR: 
    errmsg = "Syntax Error In Read"; 
    break;
  case LLCANT_OPEN:
    errmsg = "Can't Open File";
    break;
  case LLINVALID_OBJECT:
    errmsg = "Attempt to make invalid object";
    break;
  case LLNO_MEMORY:
    errmsg = "Out of Memory";
    break;
  case LLMISMATCHED_PAREN:
    errmsg = "Mismatched Parentheses";
    break;
  case LLINTERNAL_ERROR:
    errmsg = "Internal Error: we goofed, not you";
    break;
  case LLNO_MESSAGE: 
    errmsg = NULL;
    break;
  }

  llcur_cont = NULL;
  if (errmsg) fprintf (stderr, "\n ERROR: %s ... %s\n", errmsg, 
		       llerror_extra ? llerror_extra : ""); 
  fprintf(stderr, " Resetting to *TOPLEVEL*\n");
}


int lltype_error(got_type, want_type)
     LLObj_td* got_type, *want_type;
{
  static char buffer[100];
  sprintf(buffer, "expecting %s, but got %s", want_type->name, got_type->name);
  llperror(LLTYPE_ERROR, buffer);
  return 0;
}
