/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "string.h"
#include "stream.h"
#include "sym.h"
#include "cont.h" 
#include "num.h"

LLTag llstring_t;

void free_string (string)
     LLString *string;
{
  free(string->text);
}

void print_string (string, stream)
     LLString *string;
     LLStream *stream;
{
  char *c;
  int n;

  llwrite_stream(stream, '"');
  c = string->text;
  n = string->length;
  while (n--) {
    if (*c == '"')
      llwrite_stream(stream, '\\');
    llwrite_stream(stream, *c++);
  }
  llwrite_stream(stream, '"');
}

char* llcstring_to_malloc_chars(str)  /* caller must free buffer */
     LLString* str;
{
  char* buffer;
  buffer = (char*)malloc(str->length+1);
  bcopy(str->text, buffer, str->length);
  buffer[str->length] = 0;
  return buffer;
}

LLString *llchars_to_string(chars, length)
     char *chars;
     int length;
{
  LLString *s;
  
  s = (LLString *) llmake_obj(llstring_t);
  s->length = length;
  s->text = (char *) malloc(length+1);
  s->text[length] = 0;
  bcopy(chars, s->text, length);
  return s;
}  
void llstring_length() 
{
  LLString *string; 
  string = (LLString *) llnextcheckedarg(llstring_t); 
  lllastarg();
  llpusharg(lldouble_to_num((double)string->length));
}
void llstring_nullQ() 
{
  LLString *string; 
  string = (LLString *) llnextcheckedarg(llstring_t); 
  lllastarg();
  llpusharg(string->length ? NULL: T);
}
LLString *llread_string(stream)
     LLStream *stream;
{
  char *buf; 
  int bufsize, n = 0;
  LLString *str;
  char c;

  buf = (char *) malloc(bufsize = 8);
  do {
    c = llread_stream(stream);
    if(c == '"') {
      if ( ( n == 0 ) || (n > 0 && buf[n-1] != '\\') ) {
	str = (LLString *)llmake_obj(llstring_t);
	str->text = buf;
	str->length = n;
	str->text[str->length] = 0;
        return str; 
      }  else  {
	buf[--n] = c;
      }
    } else { 
      buf[n] = c;
    }
    if (++n == bufsize) 
      buf = (char *) realloc(buf, bufsize += 8);
  } while( c != EOF);
  llerror(LLEND_OF_STREAM);
}

void llstring_append ()
{
  LLString *string; 
  char *str; 
  int size= 0;
  str = (char *)malloc(0);
  while(llargc--) {
    string = (LLString *)llnextcheckedarg(llstring_t);
    str =(char *)realloc(str, size + string->length);
    bcopy(string->text, &str[size], string->length);
    size += string->length;
  }
  llpusharg(llchars_to_string(str, size));
  free(str);
}
void llcindex(which)
{
  LLObj *obj; 
  char indexchar;
  char *str;
  LLString *string, *indexstring; 
  LLSym *sym;

  /* returns the index number from string to char */ 
  llargcount(2);
  string = (LLString *)llnextcheckedarg(llstring_t);
  obj = llnextarg();
  if ( llobj_tag(obj) == llstring_t ) {

    indexstring = (LLString *)obj;
    indexchar = indexstring->text[0];
    
  } else { 
    
    sym = (LLSym *)obj;
    indexchar = sym->text[0];

  }
  
  str = (char *)(which ? index(string->text, indexchar) : 
		 rindex(string->text, indexchar) );

  if(str) 
    llpusharg(lldouble_to_num((double)(str - string->text)));
  else { 
    llpusharg(NIL);
  }
}

void llindex() { llcindex(1) ; }
void llrindex() { llcindex(0) ; }

void llsubstring()
{
  LLString *string;
  char *str; 
  int start, end; 
  llargcount(3);
  string = (LLString *)llnextcheckedarg(llstring_t);
  start = (int)llnum_to_double((LLNum *)llnextcheckedarg(llnum_t));
  end = (int)llnum_to_double((LLNum *)llnextcheckedarg(llnum_t));
  if (end == -1) end = string->length;
  else 
    end++;
  if(start > end || end > string->length || start < -1)
    { llerror(LLARGS_OUT_OF_RANGE); }
  str =(char *) malloc(end-start);
  bcopy(&(string->text[start]) , str,  end - start);
  llpusharg(llchars_to_string(str, end - start));
  free(str);
}
void llnum2string ()
{
  LLNum *num; 
  LLString *string; 
  char buffer[20];
  num = (LLNum *)llnextcheckedarg(llnum_t);
  lllastarg();
  string = (LLString *)llmake_obj(llstring_t);
  sprintf(buffer, "%lf", num->value);
  string->length = strlen(buffer);
  string->text = (char *) malloc(string->length + 1);
  bcopy(buffer, string->text, string->length + 1);
  string->text[string->length] = 0;
  llpusharg(string);
  
}

void llprinc() 
{
  LLString *string; 
  LLStream *stream;
  int n;
  char *c;

  if(llobj_tag(llpeekarg()) != llstring_t) {
    llwrite();
    return;
  }
  string = (LLString *)llnextcheckedarg(llstring_t);
  stream = (LLStream *) ((llmoreargs()) ? (LLStream *)llnextcheckedarg(llstream_t) : s_stdout);  
  lllastarg();
  c = string->text;
  n = string->length;
  while (n--) {
    llwrite_stream(stream, *c++);
  }
  llpusharg(T);
}
/* Initialize the string type */
llstring_cmp(type, o1, o2) 
     LLCompare  type; 
     LLString *o1, *o2;
{
  switch(type) {

  case LLEQ:
  case LLEQV:
    return(o1 == o2);
    
  case LLEQUAL:
    return((o1->length == o2->length) && !strncmp(o1->text, o2->text, o1->length));
  default:
    return NULL;
  }
}
void llinit_string()
{
  llstring_t = lladd_obj_td (sizeof(LLString), "String",
			     free_string, 0, print_string, llread_string);
  /* Note: the read method for strings
     is called from read_obj (read.c) */
  object_tds[llstring_t]->comparefunc = llstring_cmp;

  llregister_cfunc(llstring_length, "string-length"); 
  llregister_cfunc(llstring_nullQ, "string-null?"); 
  llregister_cfunc(llstring_append, "string-append");
  llregister_cfunc(llsubstring, "substring");
  llregister_cfunc(llprinc, "princ");
  llregister_cfunc(llnum2string, "num2string");
  llregister_cfunc(llindex, "index");
  llregister_cfunc(llrindex, "rindex");
}

