/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include <ctype.h>
#include "mem.h"
#include "obj.h"
#include "sym.h"
#include "stream.h"
#include "kcll.h"
#include "strings.h"

/*
  Routines:

  LLSym *llcstring_to_sym (string)
  llinit_sym () 
*/


LLTag llsym_t;


/* Print method for symbol type */
void print_sym (sym, stream)
     LLSym *sym;
     LLStream *stream;
{
  llstrprintf(stream, "%s", sym->text);
}

/* Create a symbol object, given a C (char *) */
LLSym *llcstring_to_sym (string)
     char *string;
{
  LLSym *sym;
  int len;

  sym = (LLSym *) llmake_obj(llsym_t);
  len = strlen(string) + 1;
  sym->text = (char *) malloc(len);
  strcpy(sym->text, string);
  return sym;
}

/* Method to free a symbol */
free_sym (sym)
     LLSym *sym;
{
  free(sym->text);
}

/* Read a symbol... unless, of course, you see "nil",
   in which case, return NIL.  A real lexical analyzer
   might be a good addition to this package... */
LLSym *llread_sym (stream)
     LLStream *stream;
{
  char *buf, c;
  int bufsize, n;
  LLSym *sym;

  while (isspace(c = llread_stream(stream)));
  n = 0;
  buf = (char *) malloc(bufsize = 8);
  while (!isspace(c) && c != '(' && c != ')' && c != EOF) {
    buf[n] = c;
    if (++n == bufsize) 
      buf = (char *) realloc(buf, bufsize += 8);
    c = llread_stream(stream);
  }
  buf[n] = 0;
  llunread_stream(stream, (unsigned int)c);
  if (!n) 
    llerror(LLSYNTAX_ERROR);
  if (!strcmp(buf, "nil"))	/* Hack hack hack hack hack... */
    return (LLSym *) NIL;
  sym = (LLSym *) llmake_obj(llsym_t);
  sym->text = buf;
  return sym;
}

/*ARGSUSED*/
static int sym_compare(cmptype, s1, s2) /* cmptype is isn't used because it's all the same */
     LLCompare cmptype;
     LLSym *s1, *s2;
{
  return(!strcmp(s1->text, s2->text));
}

int llsymcmp(sym, chars)
     LLSym *sym;
     char *chars;
{
  return(!strcmp(sym->text, chars));
}

/* Initialize the symbol type */
void llinit_sym () 
{
  llsym_t = lladd_obj_td (sizeof(LLSym), "Symbol",
		      free_sym, 0, print_sym, 0);
				/* Note: the read method for symbols
				   is called from llread_obj (read.c) */
  llregister_compare_function(llsym_t, sym_compare);
  T = (LLObj *) llcstring_to_sym("t");
}

