#include "widgetclass.h"
#include "wob.h"
#include "win_dep.h"
#include "stream.h"

LLTag llwidgetclass_t;

void default_widgetclass_show(wob)
     Wob* wob;
{
  w_show_widget(&wob->win);
}

void default_widgetclass_hide(wob)
     Wob* wob;
{
  w_hide_widget(&wob->win);
}

void default_widgetclass_constructor(wob)
     Wob* wob;
{
  char* name;
  name = llcstring_to_malloc_chars(wob->name);
  w_make_widget(&wob->win, wob->type->widgetclass, 
		&wob->parent->win, name);
  free(name);
}

void popup_widgetclass_show(wob)
     Wob* wob;
{
  w_popup_widget(&wob->win);
}

void popup_widgetclass_hide(wob)
     Wob* wob;
{
  w_popdown_widget(&wob->win);
}

void popup_widgetclass_constructor(wob)
     Wob* wob;
{
  char* name;
  name = llcstring_to_malloc_chars(wob->name);
  w_make_popup_widget(&wob->win, wob->type->widgetclass, 
		      &wob->parent->win, name);
  free(name);
}

LLWidgetClass* llmake_widgetclass_obj(wc, constructor, show, hide)
     WidgetClass wc;
     void (*constructor)();
     void (*show)();
     void (*hide)();
{
  LLWidgetClass *wcobj;

  wcobj = (LLWidgetClass*)llmake_obj(llwidgetclass_t);
  wcobj->widgetclass = wc;
  wcobj->constructor = constructor ? constructor : default_widgetclass_constructor;
  wcobj->show = show ? show : default_widgetclass_show;
  wcobj->hide = hide ? hide : default_widgetclass_hide;
  return wcobj;
}

void widgetclass_print(obj, stream)
     LLObj* obj;
     LLStream* stream;
{
}


void llwidgetclass_init() {

  llwidgetclass_t = lladd_obj_td(sizeof(LLWidgetClass), "WidgetClass",
			 0, 0, 0, 0);

}
