/*
 * nslex.l - Lexical analyzer for my NS interpreter.
 *
 * Copyright (C) 1997, George Madrid
 * All rights reserved.
 */

%{

#include <stdio.h>
     
#include "config.h"
#include "utils.h"
#include "btree.h"     

#undef yywrap

%}

%%

[a-zA-Z][a-zA-Z0-9]*	{ printf("Identifier: %s\n", yytext); }

[\t\n ]* {}


%%   

int nslex_init(void);
struct lex_pair {
     char *id;
     int tok;
};


BTREE lex_reserved;

int
main(int argc, char *argv[])
{
     ++argv, --argc;
     if (argc > 0)
	yyin = fopen(argv[0], "r");
     else
	yyin = stdin;

     nslex_init();

     yylex();
     return(0);
}

int
yywrap() { return 1; }

int
lex_compare(struct lex_pair *lp1, struct lex_pair *lp2)
{
     return(strcasecmp(lp1->id, lp2->id));
}
   
#define TOK_WHILE 1
#define TOK_BEGIN 2
#define TOK_END 3

struct lex_pair idlist[] = {
{ "while", TOK_WHILE },
{ "begin", TOK_BEGIN },
{ "end", TOK_END },
};

int
nslex_init()
{
     struct lex_pair lp;
     int i;
     
     lex_reserved = btree_Create(sizeof(struct lex_pair), lex_compare);
     for (i = 0; i < sizeof(idlist)/sizeof(*idlist); i++) {
	  btree_Insert(lex_reserved, idlist + 1);
     }
}

