/*
 * cpile.h - A stack where only the top card is visible.
 */

/* ---------- Structure definition ---------- */
struct cpile {
     struct card *topcard;	/* Top card in pile */
     struct area *ap;		/* Is it displayed? */
     int invert:1;		/* Is card inverted */
};

/* ---------- Function definitions ---------- */
/*
 * cpile_create()
 * 
 * Create a new empty card pile.
 */
struct cpile *cpile_create(void);

/*
 * cpile_destroy(cpile)
 * 
 * Destroy the cpile and the cards contained in it.
 */
void cpile_destroy(struct cpile *);

/*
 * cpile_makeempty(cpile) --> result
 * 
 * Make cpile empty and destroy the cards contained in it.
 */
int cpile_makeempty(struct cpile *);

/*
 * cpile_draw(cpile, wind, x, y)
 * 
 * Draw the cpile at location (x,y) in wind.
 */
void cpile_draw(struct cpile *, struct wind *, int, int);

/*
 * cpile_addcard(cpile, card) -> result
 * 
 * Add card to cpile.
 */
int cpile_addcard(struct cpile *, struct card *);

/*
 * cpile_getcard(cpile) -> struct card *
 * 
 * Return the top card on cpile.
 */
struct card *cpile_getcard(struct cpile *);

/*
 * cpile_setarea(cpilep, areap)
 * 
 * Tell the cpile that it is being displayed in areap.
 */
#define cpile_setarea(c,a)  ((c)->ap = (a))

/*
 * cpile_getarea(cpilep) -> struct area *
 * 
 * Get the area we're displayed in.
 */
#define cpile_getarea(c)  ((c)->ap)
