/*
 * cstacka.h - An area which displays a cstack.
 */

/* ---------- Structure definition ---------- */
struct cstacka_data {
     struct cstack *csp;
};

/* ---------- Functions ---------- */
/*
 * cstacka_create(cstack, aop) --> struct area *
 * 
 * Create a new area which contains a cstack.  The area will be created
 * according to the stuff specified in aop.
 */
struct area *cstacka_create(struct cstack *, struct aop *);

/*
 * cstacka_getcardrect(cstacka, cardnum, clipped, rectp) -> result
 * 
 * Return in trect the rectangle which the cardnumcard occupies in the
 * window.  If clipped is TRUE, then return only the visible rect.
 * If there is no cardnum card, then return an Empty rect.
 */
int cstacka_getcardrect(struct area *, int, int, XRectangle *);

/*
 * cstacka_setinvert(cstacka, invert)
 * 
 * Set the invert status of the area to invert.  Refresh as needed.
 */
int cstacka_setinvert(struct area *, int);

/*
 * cstacka_getcardrect(cstacka, cardnum, clipped, rectp) --> result
 * 
 * Return the rectangle which contains cardnum in cstacka.  If you want it
 * clipped, set clipped to TRUE.  Rectangle will be returned in rectp.  If
 * rectp is NULL, bad things will happen.
 */
int cstacka_getcardrect(struct area *, int, int, XRectangle *);

/*
 * cstacka_findcard(cstacka, x, y) --> cardnum
 * 
 * Returns the card number of the card under the point (x,y).  Returns -1 if
 * no card at that point.
 */
int cstacka_findcard(struct area *, int, int); 

/*
 * cstacka_getcstack(cstacka) --> struct cstack *
 * 
 * Return the cstack which the cstacka is displaying.
 */
struct cstack *cstacka_getcstack(struct area *);

