/*
 * card.c - Handles the identity and display of a card.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "err.h"
#include "fc.h"

#include <X11/Xmu/Drawing.h>

#include "card.h"

/* ---------------------------------------------------------------------- */
struct card *
card_create(int suit, int number)
{
     struct card *ret;

     ret = (struct card *)malloc(sizeof(*ret));
     if (!ret) return NULL;
     
     ret->cnum = suit * 13 + number;
     ret->invert = FALSE;
     return(ret);
}

/* ---------------------------------------------------------------------- */
struct card *
card_create_from_int(int cnum)
{
     struct card *ret;
     
     if (cnum > 52 || cnum < 1) {
	  do_error(ERR_INVALIDARG, "Invalid number while creating card.");
     }

     ret = (struct card *)malloc(sizeof(*ret));
     if (!ret) return NULL;
     ret->cnum = cnum;
     ret->invert = FALSE;
     return(ret);
}

/* ---------------------------------------------------------------------- */
void
card_setinvert(struct card *cardp, int invert)
{
     int old_invert;

     if (cardp == NULL) return;

     old_invert = cardp->invert;
     cardp->invert = invert;

     if (old_invert == invert) return;
}

/* ---------------------------------------------------------------------- */
void
card_draw(struct card *cardp, struct wind *windp, int x, int y)
{
     int invert;
     /* int pips, invert; */
     /* char buf[10]; */

     invert = (cardp ? cardp->invert : FALSE);

     if (cardp == NULL) {
	  if (round_cards) {
	       XmuDrawRoundedRectangle(dpy, windp->window,
				       (invert ? windp->invertgc :
					windp->gc),
				       x, y, 
				       CARD_WIDTH, CARD_HEIGHT,
				       ROUND_W, ROUND_H);
	  }
	  else {
	       XDrawRectangle(dpy, windp->window, 
			      (invert ? windp->invertgc : windp->gc), 
			      x, y, CARD_WIDTH,
			      CARD_HEIGHT);
	  }
     }
     else {
	  paint_card(x, y, card_getpips(cardp), card_getsuit(cardp), 0,
		     invert); 
     }
     return;
     
#ifdef OLD_STUFF
     if (cardp == NULL) return;

     buf[0] = '\0';
     pips = card_getpips(cardp);
     switch(pips) {
     case ace:
	  strcat(buf, "A");
	  break;
     case jack:
	  strcat(buf, "J");
	  break;
     case queen:
	  strcat(buf, "Q");
	  break;
     case king:
	  strcat(buf, "K");
	  break;
     case 10:
	  strcat(buf, "T");
	  break;
     default:
	  sprintf(buf, "%d", pips);
	  break;
     }
     strcat(buf, suitnames[card_getsuit(cardp)]);
     XDrawString(dpy, windp->window, 
		 (invert ? windp->invertgc : windp->gc), 
		 x + 7, y + 14, buf, strlen(buf));
#endif
}

/* ---------------------------------------------------------------------- */
struct card *
card_copy(struct card *cdp)
{
     struct card *ret;

     ret = (struct card *)malloc(sizeof(*ret));
     if (!ret) return NULL;

     *ret = *cdp;
     return ret;
}
