/*
 * cslot.c - A container for a single card.
 */

#include <stdlib.h>

#include "fc.h"
#include "err.h"

#include "area.h"
#include "card.h"
#include "cslot.h"
#include "cslota.h"

/* ---------------------------------------------------------------------- */
struct cslot *
cslot_create()
{
     struct cslot *ret;

     ret = calloc(sizeof(*ret), 1);
     return ret;
}

/* ---------------------------------------------------------------------- */
void
cslot_destroy(struct cslot *ctp)
{
     if (ctp->cdp) card_destroy(ctp->cdp);
     free(ctp);
}

/* ---------------------------------------------------------------------- */
int
cslot_setinvert(struct cslot *ctp, int invert)
{
     if (invert == ctp->invert) return invert;

     card_setinvert(ctp->cdp, invert);
     ctp->invert = invert;
     
     if (ctp->ap) cslota_setinvert(ctp->ap, invert);
     return(!invert);
}

/* ---------------------------------------------------------------------- */
int
cslot_isempty(struct cslot *ctp)
{
     return(ctp->cdp == NULL);
}

/* ---------------------------------------------------------------------- */
int
cslot_getinvert(struct cslot *ctp)
{
     return(ctp->invert);
}

/* ---------------------------------------------------------------------- */
struct card *
cslot_getcard(struct cslot *ctp)
{
     return(ctp->cdp);
}

/* ---------------------------------------------------------------------- */
void
cslot_makeempty(struct cslot *ctp)
{
     if (ctp->cdp) {
	  card_destroy(ctp->cdp);
	  ctp->cdp = NULL;
	  if (ctp->ap) area_clear(ctp->ap);
     }
}

/* ---------------------------------------------------------------------- */
int
cslot_addcard(struct cslot *ctp, struct card *cdp)
{
     if (ctp->cdp) card_destroy(ctp->cdp);
     ctp->cdp = cdp;
     
     if (ctp->ap) area_clear(ctp->ap);
     return(0);
}

/* ---------------------------------------------------------------------- */
struct card *
cslot_removecard(struct cslot *ctp)
{
     struct card *cdp;
     cdp = ctp->cdp;
     ctp->cdp = NULL;

     if (cdp && ctp->ap) {
	  area_clear(ctp->ap);
     }

     return(cdp);
}
