/*
 * cslot.h - A container for exactly one card.
 */

/* ---------- Structure definition ---------- */
struct cslot {
     struct card *cdp;
     struct area *ap;
     int invert:1;
};

/* ---------- Functions ---------- */
/*
 * cslot_create()
 * 
 * Create a new empty slot
 */
struct cslot *cslot_create(void);

/*
 * cslot_destroy()
 * 
 * Destroy the slot and any cards contained in the slot.
 */
void cslot_destroy(struct cslot *);

/*
 * cslot_makeempty(cslot)
 * 
 * Make the cslot empty, destroying any cards in the slot.
 */
void cslot_makeempty(struct cslot *);

/*
 * cslot_isempty(cslot) --> Bool
 * 
 * Return TRUE if the slot is empty.
 */
int cslot_isempty(struct cslot *);

/*
 * cslot_getcard(cslot) --> struct card *
 *
 * Return the card in the slot.
 */
struct card *cslot_getcard(struct cslot *);

/*
 * cslot_removecard(cslot) -> struct card *
 * 
 * Remove the card from the slot and return it.
 */
struct card *cslot_removecard(struct cslot *);

/*
 * cslot_addcard(cslot, card) -> int
 * 
 * Put card in the slot.  If there is a card there already, destroy it.
 */
int cslot_addcard(struct cslot *, struct card *);

/*
 * cslot_setinvert(cslot, bool) -> int 
 * 
 * Set the invert status of cslot to bool.  Return the previous value.
 */
int cslot_setinvert(struct cslot *, int);

/*
 * cslot_getinvert(cslot) -> int
 * 
 * Return the invert status of the cslot.
 */
int cslot_getinvert(struct cslot *);

/*
 * cslot_draw(cslot, windp, x, y)
 * 
 * Draw the cslot at location (x,y) in windp.
 */
void cslot_draw(struct cslot *, struct wind *, int, int);

/*
 * cslot_setarea(cslot, area)
 * 
 * Tell the cslot that it is being displayed in area.
 */
#define cslot_setarea(c,a)   ((c)->ap=(a))

/*
 * cslot_getarea(cslot) -> struct area *
 * 
 * Get the area we're displayed in.
 */
#define cslot_getarea(c)   ((c)->ap)

