/*
  doevent.c - Takes care of pawning off events to other things.
*/

#include <stdlib.h>

#include "fc.h"

#include "err.h"

/* ------------------------------------------------------------------------ */
void
do_event(XAnyEvent *xevp)
{
     struct wind *wind;

     if (xevp->window != wind_syswin(gworld.window)) {
	  do_error(WARN_BOGUSWINDOW, "Bogus window in do_event");
	  return;
     }

     wind = gworld.window;

     switch(xevp->type) {
     case KeyPress:
	  wind_key(wind, (XKeyEvent *)xevp);
	  break;
     case ButtonPress:
     case ButtonRelease:
	  wind_mouse(wind, (XButtonEvent *)xevp);
	  break;
     case KeymapNotify:
	  break;
     case Expose:
	  wind_draw(wind, (XExposeEvent *)xevp);
	  break;
     case ConfigureNotify:
	  wind_resize(wind, (XConfigureEvent *)xevp);
	  break;
     case ClientMessage:
	  break;
     case MapNotify:
	  wind_activate(wind, (XMapEvent *)xevp);
	  break;
     case UnmapNotify:
	  wind_deactivate(wind, (XUnmapEvent *)xevp);
	  break;
     case ReparentNotify:
     case KeyRelease:
	  /* Ignore these events. */
	  break;
     default:
	  do_error(WARN_BOGUSXEV, "Bogus X event in do_event");
	  break;
    }
}
