/** @file if_usb.h
  * 
  * @brief This file contains definition for USB interface.
  *  
  * (c) Copyright  2003-2006, Marvell International Ltd. 
  * All Rights Reserved
  *
  * This software file (the "File") is distributed by Marvell International 
  * Ltd. under the terms of the GNU General Public License Version 2, June 1991 
  * (the "License").  You may use, redistribute and/or modify this File in 
  * accordance with the terms and conditions of the License, a copy of which 
  * is available along with the File in the license.txt file or by writing to 
  * the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
  * 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
  *
  * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE 
  * IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE 
  * ARE EXPRESSLY DISCLAIMED.  The License provides additional details about 
  * this warranty disclaimer.
  *
  */
/********************************************************
Change log:
	10/11/05: Add Doxygen format comments
	
********************************************************/

#include	"include.h"

#define CMD_TYPE_REQUEST                0xF00DFACE
#define CMD_TYPE_DATA                   0xBEADC0DE
#define CMD_TYPE_INDICATION             0xBEEFFACE

#define BULK_ENDPOINT_PRESENT		USB_ENDPOINT_DIR_MASK
#define BULK_ENDPOINT_MASK		USB_ENDPOINT_XFERTYPE_MASK
#define BULK_ENDPOINT_FOUND		USB_ENDPOINT_XFER_BULK
#define ENDPOINT_NUMBER_MASK		USB_ENDPOINT_NUMBER_MASK

#define BULK_OUT_PRESENT	0x00

#define IPFIELD_ALIGN_OFFSET	2

#define USB8388_VID_1	0x1286
#define USB8388_PID_1	0x2001
#define USB8388_VID_2	0x05a3
#define USB8388_PID_2	0x8388

/** USB card description structure*/
struct usb_card_rec
{
	struct net_device	*eth_dev;
	struct usb_device	*udev;
	struct urb		*rx_urb, *tx_urb;	
	u16			irq;
	u32			port;
	u8			flag;
	u16			host_int_mask;
	void *		        (*add)(struct usb_card_rec *card);
	int                     (*remove)(struct usb_card_rec *card);
	void                    (*user_isr)(int, void*, struct pt_regs*);
	void			*priv;
	
	struct sk_buff		*skb;
	int			bulk_in_size;
	u8			bulk_in_endpointAddr;

	u8			*bulk_out_buffer;
	int			bulk_out_size;
	u8			bulk_out_endpointAddr;

	u8			CRC_OK;
	u8			SendNextBlk;
	u8			IsFWDnld;
	u32			FWSeqNum;
	u32			LastSeqNum;
	u32			TotalBytes;
	u32			FwLastBlkSent;
	u8			FwDnldOver;
	u8			FWFinalBlk;

	u8			tx_urb_pending;
	u8			rx_urb_pending;
	u8			rx_urb_recall;
} ;

typedef void *	(*usb_notifier_fn_add) (struct usb_card_rec *);
typedef int	(*usb_notifier_fn_remove) (struct usb_card_rec *);

/** if_usb_context_data */
typedef struct _if_usb_context_data {
	int done;
} if_usb_context_data;

/** TransmitBuffer */
typedef struct _TransmitBuffer {
	u32	TransmitType;
	u8	payload[MRVDRV_ETH_TX_PACKET_BUFFER_SIZE];
} TransmitBuffer;

/** FWHeader */
typedef struct _FWHeader {
	u32	DnldCmd;
	u32	BaseAddr;
	u32	DataLength;
	u32	CRC;
} __attribute__ ((packed)) FWHeader, *pFWHeader;

#define FW_MAX_DATA_BLK_SIZE	600
/** FWData */
typedef struct _FWData {
	FWHeader	fwheader;
	u32		SeqNum;
	u8		data[FW_MAX_DATA_BLK_SIZE];
} __attribute__ ((packed)) FWData, pFWData;

/** FWSyncHeader */
typedef struct _FWSyncHeader {
	u32		Cmd __attribute__((aligned(4)));
	u32		SeqNum __attribute__((aligned(4)));
} __attribute__ ((packed)) FWSyncHeader;

#define REQ_TYPE	0 /* for compilation only */
#define REQ_CTRL	0 /* for compilation only */
#define TIME_OUT_VALUE	0 /* for compilation only */	


#define FW_HAS_DATA_TO_RECV		0x00000001
#define FW_HAS_LAST_BLOCK		0x00000004

#define FW_DATA_XMIT_SIZE \
	sizeof(FWHeader) + fwdata.fwheader.DataLength + sizeof(u32)

