/* $Header: main.c,v 1.3.1.1 90/04/20 19:31:31 toddb Exp $ */
#include "def.h"

int BaseOpCode, BaseEvent, BaseError;
char *Program;

/*
 * Caution, these must be in same orders as command defines in def.h
 */
char *ControlNames[] = {
    VEX_CTRL_SEARCH,
    VEX_CTRL_SEGPLAY,
    VEX_CTRL_VAR_SPEED,
    VEX_CTRL_JOG,
    VEX_CTRL_GET_FRAME,
    VEX_CTRL_INDEX_ON,
    VEX_CTRL_INDEX_OFF,
    VEX_CTRL_LOAD,
    VEX_CTRL_UNLOAD,
    VEX_CTRL_INDEX_TOGGLE,
    VEX_CTRL_RESET,
    VEX_CTRL_A1_ON,
    VEX_CTRL_A1_OFF,
    VEX_CTRL_A2_ON,
    VEX_CTRL_A2_OFF
};

XVEXSetting *Settings[ MAX_CTL_NUM + 1 ];


main(argc, argv) 
    int   argc;
    char *argv[];
{
    Program = argv[0];

    StartUI(&argc, argv);
}

void FatalError(fmt, x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
{
    extern int errno, sys_nerr;
    extern char *sys_errlist[];

    if (errno)
	fprintf(stderr, "%s: %s\n", Program, sys_errlist[ sys_nerr ]);
    fprintf(stderr, fmt, x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
    exit (1);
}

static void InitializeWinOffset(vparam, w)
    VideoParamPtr	vparam;
    WidgetPtr		w;
{
    Window child;
    Display *dpy = XtDisplay(w);
    Dimension width, height;
    int boundaryOffset, rootX, rootY, xOffset, yOffset;
    Arg wargs[2];

    XtSetArg(wargs[0], XmNwidth, &width);
    XtSetArg(wargs[1], XmNheight, &height);
    XtGetValues(w, wargs, 2);

    /*
     * This is really only necessary if the hardware cannot
     * display video on any pixel boundary.
     */
    XTranslateCoordinates(dpy, XtWindow(w),
			  DefaultRootWindow(dpy),
			  0, 0, &rootX, &rootY, &child);
    if ((boundaryOffset = rootX % vparam->minXinc) == 0)
	xOffset = 0;
    else
	xOffset = vparam->minXinc - boundaryOffset;
    if ((boundaryOffset = rootY % vparam->minYinc) == 0)
	yOffset = 0;
    else
	yOffset = vparam->minYinc - boundaryOffset;

    width -= xOffset;
    if ((boundaryOffset = width % vparam->minXinc) > 0)
	width -= boundaryOffset;
    height -= yOffset;
    if ((boundaryOffset = height % vparam->minYinc) > 0)
	height -= boundaryOffset;

    vparam->x = xOffset;
    vparam->y = yOffset;
    vparam->w = vparam->maxWidth;	/* depend on window clipping */
    vparam->h = vparam->maxHeight;	/* depend on window clipping */
}

void GraphicCallback(w, vparam, callData) 
    WidgetPtr		w;  
    VideoParamPtr	vparam; 
    XmAnyCallbackStruct *callData;
{
    switch(callData->reason) {
    case XmCR_RESIZE:
    case XmCR_EXPOSE:
	InitializeWinOffset(vparam, w);
	XVEXRenderVideo(XtDisplay(w),
		     vparam->vin,		/* src */
		     XtWindow(w),		/* dst */
		     0, 0,			/* src x,y */
		     vparam->w, vparam->h,	/* src width, height */
		     vparam->x, vparam->y,	/* dst x, y */
		     vparam->w, vparam->h,	/* dst width, height */
		     True,			/* fullMotion */
		     100,			/* priority */
		     ClipByChildren);		/* subWindowMode */
	break;

    case XmCR_INPUT: /* not selected */
	break;

    default:
	fprintf(stderr, "unrecognized event = %d\n", callData->event->type);
	break;
    }
}

VideoParamPtr StartVexApp(w)
    WidgetPtr w;
{
    XVEXVin	*pVins;
    int		nvins;
    static VideoParam	vparam;
    Display	*dpy = XtDisplay(w);

    if (! XQueryExtension (dpy, "VEX", &BaseOpCode, &BaseEvent, &BaseError)) {
	fprintf (stderr, "VEX Extension not found in X server\n");
	return;
    }

    InitDevice(dpy);
    pVins = XVEXGetVins(dpy, DefaultScreen(dpy), &nvins);
    vparam.vin = XVEXCreateVideo(dpy, pVins[0].id);

    vparam.x = -1; /* we are not ready yet */
    vparam.minXinc = 16;	/* XXX how do we know this? */
    vparam.minYinc = 1;		/* XXX how do we know this? */
    vparam.maxWidth = 640;	/* XXX how do we know this? */
    vparam.maxHeight = 482;	/* XXX how do we know this? */

    RunVideoDisc(dpy, 0);

    return (&vparam);
}

InitDevice(dpy)
    Display *dpy;		/* X connection */
{
    XVEXVdev *devices;
    XVEXVdev *discDevice = (XVEXVdev *) NULL;
    XVEXSetting *settingList;
    int ndevices;
    int i,j;
    Atom name, galName;
    Boolean found = False;

    devices = XVEXGetVdevs( dpy, 0, &ndevices);
    if (ndevices < 1) {
	fprintf (stderr, "VEX Extension has no video input devices\n");
	exit(2);
    }
    galName = XInternAtom(dpy, GALATEA_DEVICE, True);
    found = False;
    for (i=0; i<ndevices, !found; i++) {
        for (j=0; j < devices[i].ndevice_controls, !found; j++) {
            if (galName == devices[i].device_controls[j].name) {
                discDevice = &devices[i];
		found = True;
            }
        }
    }

    if (!found) {
	fprintf (stderr, "VEX Extension does not have a %s\n", GALATEA_DEVICE);
	exit(2);
    }
    XVEXSelectEvents(dpy, discDevice->id, VEXControlMask);
    settingList = XVEXCreateSettingList(discDevice->id,
					discDevice->device_controls, 
					discDevice->ndevice_controls);
    for (i=0; i< MAX_CTL_NUM; i++){
	name = XInternAtom(dpy, ControlNames[i], True);
	for (j=0; j<discDevice->ndevice_controls; j++) {
	    if (name == settingList[j].name) {
		Settings[i] = &settingList[j];
		break;
	    }
	}
	if (j == discDevice->ndevice_controls) {
	    fprintf (stderr, "Device does not have a %s\n", ControlNames[i]);
	    exit(2);
	}
    }
}

static Bool
IsControlEvent(dpy, event, arg)
    Display *dpy;
    XEvent *event;
    char *arg;
{
    if (event->type == (VEXControl + BaseEvent)  &&
	((XVEXControlEvent *) event)->vid == ((XVEXSetting *) arg)->id &&
	((XVEXControlEvent *) event)->name == ((XVEXSetting *) arg)->name)
	    return True;
    else
	return False;
}

Bool Jog(dpy, direction)
    Display *dpy;			/* X connection */
    int direction;
{
    XEvent event; 

    ((XVEXSettingJog *)Settings[JOG]->value.p8list)->num = direction;
    XVEXChangeControls(dpy, Settings[JOG], 1);
    XFlush(dpy);
    XIfEvent(dpy, &event, IsControlEvent, (char *) Settings[JOG]);
    if (((XVEXControlEvent *)&event)->state == VEXControlSuccess)
	return True;

    printf("Can't jog %d\n", direction);
    return False;
}

Bool RunVideoDisc(dpy, speed)
    Display *dpy;			/* X connection */
    int speed;
{
    XEvent event; 

    ((XVEXSettingVarSpeed *)Settings[VAR_SPEED]->value.p8list)->num = speed;
    XVEXChangeControls(dpy, Settings[VAR_SPEED], 1);
    XFlush(dpy);
    XIfEvent(dpy, &event, IsControlEvent, (char *) Settings[VAR_SPEED]);
    if (((XVEXControlEvent *)&event)->state == VEXControlSuccess)
	return True;

    printf("Can't Run %d\n", speed);
    return False;
}

void ShuttleControl(w, action, callData)
    WidgetPtr		w;  
    int			action; 
    XmAnyCallbackStruct *callData;
{
    Display *dpy = XtDisplay(w);

    switch (action) {
    case PLAY_FORWARD:
	RunVideoDisc(dpy, 30);
	break;

    case PLAY_BACK:
	RunVideoDisc(dpy, -30);
	break;

    case FAST_FORWARD:
	RunVideoDisc(dpy, 90);
	break;

    case REWIND:
	RunVideoDisc(dpy, -90);
	break;

    case JOG_BACK:
	Jog(dpy, -1);
	break;

    case JOG_FORWARD:
	Jog(dpy, 1);
	break;

    case STOP:
	RunVideoDisc(dpy, 0);
	break;

    default:
	printf("shuttle %d?\n", action);
	break;
    }
}

