/* $Header: mo-widgets.c,v 1.4 90/04/20 18:53:49 toddb Exp $ */
#include "topPlayFwd"
#include "botPlayFwd"
#include "topPlayBack"
#include "botPlayBack"
#include "topFastFwd"
#include "botFastFwd"
#include "topRewind"
#include "botRewind"
#include "topJogFwd"
#include "botJogFwd"
#include "topJogBack"
#include "botJogBack"

#include "def.h"

#define DrawClass	xmDrawingAreaWidgetClass
#define FormClass	xmFormWidgetClass
#define PushBClass	xmPushButtonWidgetClass

static void Install3dPixmap(w, topBits, botBits, width, height, armPixmap)
    WidgetPtr   w;
    char    *topBits, *botBits;
    int      width, height;
    Boolean armPixmap;
{
    Pixmap    topBitmap, bottomBitmap, pix;
    Pixel     topColor, bottomColor, background;
    XGCValues values;
    int n;
    static GC gc = NULL;
    Arg wargs[10];

    /*
    * Create a bitmap from the data.
    */
    n = 0;
    if (armPixmap) {
	XtSetArg(wargs[n], XmNarmColor, &background);       n++;
    } else {
	XtSetArg(wargs[n], XtNbackground, &background);     n++;
    }
    XtSetArg(wargs[n], XmNtopShadowColor, &topColor);       n++;
    XtSetArg(wargs[n], XmNbottomShadowColor, &bottomColor); n++;
    XtGetValues(w, wargs, n);

    topBitmap = XCreateBitmapFromData(XtDisplay(w),  
			       RootWindowOfScreen(XtScreen(w)),
			       topBits, width, height);
    bottomBitmap = XCreateBitmapFromData(XtDisplay(w),  
			       RootWindowOfScreen(XtScreen(w)),
			       botBits, width, height);
    /* 
    * Create a pixmap of the same depth as the default screen.
    */
    pix = XCreatePixmap(XtDisplay(w), 
		      RootWindowOfScreen(XtScreen(w)),
		      width, height,
		      DefaultDepthOfScreen(XtScreen(w)));
    /*
     * Get the GC.
     */
    if (gc == NULL) {
	gc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 0, NULL);
    }
    
    values.fill_style = FillSolid;
    values.foreground = background;
    XChangeGC(XtDisplay(w), gc, GCFillStyle|GCForeground, &values);
    XFillRectangle(XtDisplay(w), pix, gc, 0, 0, width, height);

    values.stipple = topBitmap;
    values.fill_style = FillStippled;
    values.foreground = topColor;
    XChangeGC(XtDisplay(w), gc, GCFillStyle|GCForeground|GCStipple, &values);
    XFillRectangle(XtDisplay(w), pix, gc, 0, 0, width, height);

    values.stipple = bottomBitmap;
    values.fill_style = FillStippled;
    values.foreground = bottomColor;
    XChangeGC(XtDisplay(w), gc, GCFillStyle|GCForeground|GCStipple, &values);
    XFillRectangle(XtDisplay(w), pix, gc, 0, 0, width, height);

    /*
    * We don't need the bitmap anymore, so free it.
    */
    XFreePixmap(XtDisplay(w), topBitmap);
    XFreePixmap(XtDisplay(w), bottomBitmap);

    /*
     * install the pixmap
     */
    n = 0;
    if (armPixmap) {
	XtSetArg(wargs[n], XmNarmPixmap,       pix);         n++;
    } else {
	XtSetArg(wargs[n], XmNlabelPixmap,     pix);         n++;
    }
    XtSetArg(wargs[n], XmNlabelType,       XmPIXMAP);        n++;
    XtSetValues(w, wargs, n);

    /*
     * The pixmap (pix) is left floating in space, because it is
     * not clear whether it should be freed.
     */
}

static void CreateShuttle(parent)
    WidgetPtr parent;
{
    Dimension width, height, newWidth, newHeight;
    Widget buttons[6];
    Arg wargs[10];
    int n;

    /*
     * Set the fraction base of the parent to 1/8.
     */
    XtSetArg(wargs[0], XmNfractionBase,     8);
    XtSetValues(parent, wargs, 1);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      1);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     1);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    3);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   4);                 n++;
    buttons[0] =  XtCreateManagedWidget("play back", PushBClass,
				   parent, wargs, n);
    Install3dPixmap(buttons[0], topPlayBack_bits, botPlayBack_bits,
			botPlayBack_width, botPlayBack_height, True);
    Install3dPixmap(buttons[0], topPlayBack_bits, botPlayBack_bits,
			botPlayBack_width, botPlayBack_height, False);
    XtAddCallback(buttons[0], XmNarmCallback, ShuttleControl, PLAY_BACK);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      4);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     1);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    3);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   7);                 n++;
    buttons[1] =  XtCreateManagedWidget("rewind", PushBClass, parent, wargs, n);
    Install3dPixmap(buttons[1], topRewind_bits, botRewind_bits,
			topRewind_width, topRewind_height, True);
    Install3dPixmap(buttons[1], topRewind_bits, botRewind_bits,
			topRewind_width, topRewind_height, False);
    XtAddCallback(buttons[1], XmNarmCallback, ShuttleControl, REWIND);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      2);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     3);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    4);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   6);                 n++;
    buttons[2] =  XtCreateManagedWidget("jog back", PushBClass,
				   parent, wargs, n);
    Install3dPixmap(buttons[2], topJogBack_bits, botJogBack_bits,
			botJogBack_width, botJogBack_height, True);
    Install3dPixmap(buttons[2], topJogBack_bits, botJogBack_bits,
			botJogBack_width, botJogBack_height, False);
    XtAddCallback(buttons[2], XmNarmCallback, ShuttleControl, JOG_BACK);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      2);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     4);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    5);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   6);                 n++;
    buttons[3] =  XtCreateManagedWidget("jog forward",
				   PushBClass, parent, wargs, n);
    Install3dPixmap(buttons[3], topJogFwd_bits, botJogFwd_bits,
			botJogFwd_width, botJogFwd_height, True);
    Install3dPixmap(buttons[3], topJogFwd_bits, botJogFwd_bits,
			botJogFwd_width, botJogFwd_height, False);
    XtAddCallback(buttons[3], XmNarmCallback, ShuttleControl, JOG_FORWARD);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      1);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     5);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    7);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   4);                 n++;
    buttons[4] =  XtCreateManagedWidget("play forward",
				   PushBClass, parent, wargs, n);
    Install3dPixmap(buttons[4], topPlayFwd_bits, botPlayFwd_bits,
			botPlayFwd_width, botPlayFwd_height, True);
    Install3dPixmap(buttons[4], topPlayFwd_bits, botPlayFwd_bits,
			botPlayFwd_width, botPlayFwd_height, False);
    XtAddCallback(buttons[4], XmNarmCallback, ShuttleControl, PLAY_FORWARD);

    n = 0;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNtopPosition,      4);                 n++;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNleftPosition,     5);                 n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNrightPosition,    7);                 n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    XtSetArg(wargs[n], XmNbottomPosition,   7);                 n++;
    buttons[5] =  XtCreateManagedWidget("fast forward",
				   PushBClass, parent, wargs, n);
    Install3dPixmap(buttons[5], topFastFwd_bits, botFastFwd_bits,
			topFastFwd_width, topFastFwd_height, True);
    Install3dPixmap(buttons[5], topFastFwd_bits, botFastFwd_bits,
			topFastFwd_width, topFastFwd_height, False);
    XtAddCallback(buttons[5], XmNarmCallback, ShuttleControl, FAST_FORWARD);

#ifndef IntelligentFormWidget
    /*
     * Set the shuttle form size.
     */
    newWidth = newHeight = 0;
    XtSetArg(wargs[0], XmNwidth, &width);
    XtSetArg(wargs[1], XmNheight, &height);
    XtGetValues(buttons[ 0 ], wargs, 2);
    newHeight = (((height * 2)	/* they are stacked 2 high */
		  * 8) / 6);	/* we only occupy from 2/8 to 6/8 in y */
    newWidth = (((width * 2)	/* there are 4 along the horizontal */
		  * 8) / 6);	/* we only occupy from 2/8 to 6/8 in x */

    XtSetArg(wargs[0], XmNwidth, newWidth);
    XtSetArg(wargs[1], XmNheight, newHeight);
    XtSetValues(parent, wargs, 2);
#endif /* no IntelligentFormWidget */
}

/*
 * Create all the widgets, returning the graphic widget.
 */
static Widget CreateWidgets(parent, vparam)
    WidgetPtr parent;
    VideoParamPtr vparam;
{
    Arg wargs[10];
    int n;
    Dimension width, height, newWidth, newHeight;
    Widget graphic, shuttleForm;

    /*
     * Create the TV screen
     */
    n = 0;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM);     n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM);     n++;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_FORM);     n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_NONE);     n++;
    XtSetArg(wargs[n], XmNwidth,            vparam->maxWidth);  n++;
    XtSetArg(wargs[n], XmNheight,           vparam->maxHeight); n++;
    graphic = XtCreateManagedWidget("graphic", DrawClass,
				      parent, wargs, n);

    /*
     * Create another form that contains the dialog area.
     */
    n = 0;
    XtSetArg(wargs[n], XmNleftAttachment,   XmATTACH_FORM);   n++;
    XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM);   n++;
    XtSetArg(wargs[n], XmNrightAttachment,  XmATTACH_FORM);   n++;
    XtSetArg(wargs[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
    XtSetArg(wargs[n], XmNtopWidget,        graphic);         n++;
    shuttleForm = XtCreateManagedWidget("shuttleForm", FormClass,
				      parent, wargs, n);

    CreateShuttle(shuttleForm);

#ifndef IntelligentFormWidget
    /*
     * Set the parent form size.
     */
    XtSetArg(wargs[0], XmNwidth, &width);
    XtSetArg(wargs[1], XmNheight, &height);
    XtGetValues(graphic, wargs, 2);
    newWidth = width;
    newHeight = height;

    XtGetValues(shuttleForm, wargs, 2);
    if (width > newWidth)
	newWidth = width;
    newHeight += height;

    XtSetArg(wargs[0], XmNwidth, newWidth);
    XtSetArg(wargs[1], XmNheight, newHeight);
    XtSetValues(parent, wargs, 2);
#endif /* no IntelligentFormWidget */

    /*
     * Add the callbacks after the resize, else, the resize callback
     * may get invoked too early.
     */
    XtAddCallback(graphic, XmNresizeCallback, GraphicCallback, vparam);
    XtAddCallback(graphic, XmNexposeCallback, GraphicCallback, vparam);

    return (graphic);
}

StartUI(argc, argv)
    int *argc;
    char **argv;
{
    Widget toplevel, macroForm, graphic;
    VideoParamPtr vparam;

    toplevel = XtInitialize(argv[0], "Pushbutton", NULL, 0, argc, argv); 

    /*
     * Try to start up the video extension.
     */
    vparam = StartVexApp(toplevel);

    /*
     * Create an overall form that contains the application.
     */
    macroForm = XtCreateManagedWidget("macroForm", FormClass,
				      toplevel, NULL, 0);
    graphic = CreateWidgets(macroForm, vparam);

    XtRealizeWidget(toplevel);

    XVEXSelectEvents(XtDisplay(graphic), XtWindow(graphic), VEXViolationMask);

    XtMainLoop();
}
