/* $Header: VEXScrUtil.c,v 1.8 90/04/19 11:52:18 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"


/*
 *	This procedure returns a list of visual information structures
 *	that match the specified attributes given in the visual information 
 *	template.
 *
 *	If no visuals exist that match the specified attributes, a NULL is
 *	returned.
 *
 *	The choices for visual_info_mask are:
 *
 *		VisualNoMask
 *		VisualIDMask
 *		VisualDepthMask
 *		VisualClassMask
 *		VisualRedMaskMask
 *		VisualGreenMaskMask
 *		VisualBlueMaskMask
 *		VisualColormapSizeMask
 *		VisualBitsPerRGBMask
 *		VisualAllMask
 *		VisualScreenMask
 */
static XVisualInfo *GetExtVisualInfo( dpy, visual_info_mask, 
	visual_info_template, nitems)
Display *dpy;
register long visual_info_mask; 
register XVisualInfo *visual_info_template;
int *nitems;
{

  Visual *vp;
  Depth *dp;
  VideoInfo *vinfo;
  int total,count;
  XVisualInfo *vip,*vip_base;
  int min_screen, max_screen;
  int i;
  XEDataObject object;
  XExtData **pScreenXExtData;
  XExtData *videoXExtData;
  XExtCodes		 		*codes;

  if (!(codes = _VEXCheckExtension (dpy))) {
	*nitems = 0;
	return (XVisualInfo *) NULL;
  }


  /* NOTE: NO HIGH PERFORMING CODE TO BE FOUND HERE */

  LockDisplay(dpy);

  /* ALLOCATE THE ORIGINAL BUFFER; REALLOCED LATER OF OVERFLOW OCCURS;
     FREED AT END IF NO VISUALS ARE FOUND */

  count = 0;
  total = 10;
  vip_base = vip = (XVisualInfo *)Xmalloc(sizeof(XVisualInfo)*total);

  if (visual_info_mask & VisualScreenMask) {
    min_screen = visual_info_template->screen;
    max_screen = min_screen + 1;
  } else {
    min_screen = 0;
    max_screen = ScreenCount(dpy);
  }

  /* LOOP THROUGH SCREENS */

  for (i=min_screen; i<max_screen; i++) {

      object.screen = ScreenOfDisplay(dpy, i);
      pScreenXExtData = XEHeadOfExtensionList(object);
      videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
      if (!videoXExtData->private_data)
	  break;
      vinfo = (VideoInfo *)videoXExtData->private_data;

      /* LOOP THROUGH DEPTHS */

      for (dp=vinfo->depths; dp < (vinfo->depths + vinfo->ndepths); dp++)
	{
	  if ((visual_info_mask & VisualDepthMask) &&
	      (dp->depth != visual_info_template->depth)) continue;

	  /* LOOP THROUGH VISUALS */

	  if (dp->visuals) {
	    for (vp=dp->visuals; vp<(dp->visuals + dp->nvisuals); vp++) {
	      if ((visual_info_mask & VisualIDMask) &&
		(vp->visualid != visual_info_template->visualid)) continue;
	      if ((visual_info_mask & VisualClassMask) &&
		(vp->class != visual_info_template->class)) continue;
	      if ((visual_info_mask & VisualRedMaskMask) &&
		(vp->red_mask != visual_info_template->red_mask)) continue;
	      if ((visual_info_mask & VisualGreenMaskMask) &&
		(vp->green_mask != visual_info_template->green_mask)) continue;
	      if ((visual_info_mask & VisualBlueMaskMask) &&
		(vp->blue_mask != visual_info_template->blue_mask)) continue;
	      if ((visual_info_mask & VisualColormapSizeMask) &&
		(vp->map_entries != visual_info_template->colormap_size)) continue;
	      if ((visual_info_mask & VisualBitsPerRGBMask) &&
		(vp->bits_per_rgb != visual_info_template->bits_per_rgb)) continue;

	      /* YEA!!! WE FOUND A GOOD ONE */
 
	      if (count+1 > total)
		{
		  total += 10;
		  vip_base = (XVisualInfo *)Xrealloc(vip_base,sizeof(XVisualInfo)*total);
		  vip = &vip_base[count];
		}

	      count++;

	      vip->visual = vp;
	      vip->visualid = vp->visualid;
	      vip->screen = i;
	      vip->depth = dp->depth;
	      vip->class = vp->class;
	      vip->red_mask = vp->red_mask;
	      vip->green_mask = vp->green_mask;
	      vip->blue_mask = vp->blue_mask;
	      vip->colormap_size = vp->map_entries;
	      vip->bits_per_rgb = vp->bits_per_rgb;

	      vip++;

	    } /* END OF LOOP ON VISUALS */
	  } /* END OF IF THERE ARE ANY VISUALS AT THIS DEPTH */
	  
	} /* END OF LOOP ON DEPTHS */
    }

  UnlockDisplay(dpy);

  if (count)
    {
      *nitems = count;
      return vip_base;
    }


  XFree(vip_base);

  *nitems = 0;

  return NULL;

}

XVisualInfo *XVEXGetVisualInfo( dpy, visual_info_mask, 
	visual_info_template, nitems, include_core_visuals)
Display *dpy;
long visual_info_mask; 
XVisualInfo *visual_info_template;
int *nitems;	/* RETURN */
Bool include_core_visuals;
{
    XVisualInfo *vip;
    XVisualInfo *pvisCore, *pvisVEX;
    int nvisCore, nvisVEX;

    LockDisplay(dpy);

    /*
     * Check both lists if necessary.
     */
    pvisVEX = GetExtVisualInfo( dpy, visual_info_mask, 
	    visual_info_template, &nvisVEX);
    if (include_core_visuals)
	pvisCore = XGetVisualInfo( dpy, visual_info_mask, 
		visual_info_template, &nvisCore);
    if (!include_core_visuals || !pvisCore) {
	*nitems = nvisVEX;
	return pvisVEX;
    } else if (!pvisVEX){
	*nitems = nvisCore;
	return pvisCore;
    }

    /*
     * If we get here, we have visuals returned from both the Core
     * list and the VEX list.  Merge them together and return the
     * merged list
     */
    *nitems = nvisCore + nvisVEX;
    vip = (XVisualInfo *)Xmalloc(sizeof(XVisualInfo) * *nitems);
    bcopy(pvisCore, vip, sizeof(XVisualInfo) * nvisCore);
    bcopy(pvisVEX, vip + nvisCore, sizeof(XVisualInfo) * nvisVEX);

    XFree(pvisCore);
    XFree(pvisVEX);

    UnlockDisplay(dpy);

    return vip;
}

#define VINS	1
#define VOUTS	2
#define VDEVS	3


static char *GetVidInfo(dpy, screen_number, nitems_return, type)
    Display *dpy;
    int screen_number;
    int *nitems_return;        /* RETURN */
    int type;		/* VINS, VOUTS, or VDEVS */

{
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    XExtCodes *codes;
    char *pdata;
    int size;
    XVEXVdev *pVdevSrc, *pVdevDst;
    XVEXVout *pVout;
    char *pDataReturn;
    int i,j;
    XVEXControl *pControlSrc, *pControlDst;
    long nControls, nPlace, nWindowModel, nPixmapModel;
    long descLen;
    char *pDescrDst;
    XVEXPlacement *pPlaceSrc, *pPlaceDst;
    XVEXWindowModel *pWinModelSrc, *pWinModelDst;
    XVEXPixmapModel *pPixModelSrc, *pPixModelDst;
    int nitems;
    int nbytesTotal, nbytesVdev, nbytesCtl, nbytesDescr, nbytesPlaecment,
	nbytesWinModel, nbytesPixModel;

    *nitems_return = 0;

    if (!(codes = _VEXCheckExtension (dpy))) {
	return (char *) NULL;
    }

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    if (!videoXExtData->private_data) {
	return (char *) NULL;
    }
    switch (type) {
	case VINS:
	    nitems = ((VideoInfo *)videoXExtData->private_data)->nvin;
	    pdata = (char *)((VideoInfo *)videoXExtData->private_data)->vin;
	    size = sizeof(XVEXVin);
	    break;
	case VOUTS:
	    nitems = ((VideoInfo *)videoXExtData->private_data)->nvout;
	    pdata = (char *)((VideoInfo *)videoXExtData->private_data)->vout;
	    size = sizeof(XVEXVout);
	    break;
	case VDEVS:
	    nitems = ((VideoInfo *)videoXExtData->private_data)->nvdev;
	    pdata = (char *)((VideoInfo *)videoXExtData->private_data)->vdev;
	    size = sizeof(XVEXVdev);
	    break;
    }
    /*
     * These data structures are nestable.  First we pretend that we have
     * a Video Device.
     *
     * First figure the total space needed.  We will do a single malloc
     * and manage space within the large block ourselves.  The client
     * will be able to free this structure with a call to XFree.
     * We are assuming no alignment problems!
     */
    pVdevSrc = (XVEXVdev *)pdata;
    nbytesVdev = size * nitems;
    nbytesCtl = nbytesDescr = nbytesPlaecment = nbytesWinModel
	      = nbytesPixModel = 0;
    for (i=0; i < nitems; i++, pVdevSrc += size) {
	pControlSrc = pVdevSrc->device_controls;
	nControls = pVdevSrc->ndevice_controls;
	nbytesCtl += nControls * sizeof(XVEXControl);
	for (j=0; j < nControls; j++)
	    nbytesDescr += ((pControlSrc[j].description_length + 3) & ~0x3);
	if (type == VINS || type == VOUTS) {
	    pVout = (XVEXVout *)pVdevSrc;
	    nPlace = pVout->geometry.nplacement;
	    nbytesPlaecment += nPlace * sizeof(XVEXPlacement);
	    nWindowModel = pVout->model_info.nwindow_models;
	    nbytesWinModel += nWindowModel *sizeof(XVEXWindowModel);
	    nPixmapModel = pVout->model_info.npixmap_models;
	    nbytesPixModel += nPixmapModel * sizeof(XVEXPixmapModel);
	}
    }
    /* XXX
     * If you have alignment problems, you could adjust the nbytes*
     * variables here to force any alignment you desire between the
     * various sections of our pDataReturn memory
     */
    nbytesTotal = nbytesVdev + nbytesCtl + nbytesDescr + nbytesPlaecment
			     + nbytesWinModel + nbytesPixModel;
    pDataReturn = (char *)Xmalloc (nbytesTotal);
    if (!pDataReturn)
	return (char *) NULL;
    pVdevDst = (XVEXVdev *)pDataReturn;
    pControlDst = (XVEXControl *) (((char *)pVdevDst) + nbytesVdev);
    pDescrDst = ((char *)pControlDst) + nbytesCtl;
    pPlaceDst = (XVEXPlacement *) (((char *)pDescrDst) + nbytesDescr);
    pWinModelDst = (XVEXWindowModel *)(((char *)pPlaceDst) + nbytesPlaecment);
    pPixModelDst = (XVEXPixmapModel *)(((char *)pWinModelDst) + nbytesWinModel);
    /*
     * Copy XVEXV{in/out/dev} array first.
     */
    pVdevSrc = (XVEXVdev *)pdata;
    bcopy(pdata, pDataReturn, size * nitems);
    for (i=0; i < nitems; i++, pVdevSrc += size, pVdevDst += size) {
	pControlSrc = pVdevSrc->device_controls;
	nControls = pVdevSrc->ndevice_controls;
	((XVEXVdev *)pVdevDst)->device_controls = pControlDst;
	bcopy(pControlSrc, pControlDst, nControls * sizeof(XVEXControl));
	for (j=0; j < nControls; j++) {
	    descLen = pControlSrc[j].description_length;
	    if (descLen) {
		bcopy(pControlSrc[j].value.p8list, pDescrDst, descLen);
		pControlDst[j].value.p8list = pDescrDst;
		pDescrDst += ((descLen + 3) & ~0x3);
	    }
	}
	pControlDst += nControls;
	/*
	 * Now, if we are dealing with VideoIn or VideoOut, pretend we have
	 * a XVEXVout struct and copy XVEXPlacements and XVEXModelInfo lists
	 * (models and pixmaps).
	 */
	if (type == VINS || type == VOUTS) {
	    pVout = (XVEXVout *)pVdevSrc;
	    nPlace = pVout->geometry.nplacement;
	    if (nPlace) {
		pPlaceSrc = pVout->geometry.placement;
		((XVEXVout *)pVdevDst)->geometry.placement = pPlaceDst;
		bcopy(pPlaceSrc, pPlaceDst, nPlace * sizeof(XVEXPlacement));
		pPlaceDst += nPlace;
	    }
	    nWindowModel = pVout->model_info.nwindow_models;
	    if (nWindowModel) {
		pWinModelSrc = pVout->model_info.window_models;
		((XVEXVout *)pVdevDst)->model_info.window_models = 
		    pWinModelDst;
		bcopy(pWinModelSrc, pWinModelDst, 
		    nWindowModel * sizeof(XVEXWindowModel));
		pWinModelDst += nWindowModel;
	    }
	    nPixmapModel = pVout->model_info.npixmap_models;
	    if (nPixmapModel) {
		pPixModelSrc = pVout->model_info.pixmap_models;
		((XVEXVout *)pVdevDst)->model_info.pixmap_models = 
			pPixModelDst;
		bcopy(pPixModelSrc, pPixModelDst, 
			nPixmapModel * sizeof(XVEXPixmapModel));
		pPixModelDst += nPixmapModel;
	    }
	}
    }
    *nitems_return = nitems;
    return pDataReturn;
}


XVEXVin *XVEXGetVins( dpy, screen_number, nitems)
    Display *dpy;
    int screen_number;
    int *nitems;        /* RETURN */
{

    return (XVEXVin *) GetVidInfo(dpy, screen_number, nitems, VINS);
}

XVEXVout *XVEXGetVouts( dpy, screen_number, nitems)
    Display *dpy;
    int screen_number;
    int *nitems;        /* RETURN */
{
    return (XVEXVout *) GetVidInfo(dpy, screen_number, nitems, VOUTS);
}

XVEXVdev *XVEXGetVdevs( dpy, screen_number, nitems)
    Display *dpy;
    int screen_number;
    int *nitems;        /* RETURN */
{
    return (XVEXVdev *) GetVidInfo(dpy, screen_number, nitems, VDEVS);
}


#undef VINS
#undef VOUTS
#undef VDEVS

Status XVEXOverlapsOfScreen( dpy, screen_number, input_overlap, capture_overlap,
	io_overlap)
    Display *dpy;
    int screen_number;
    Bool *input_overlap, *capture_overlap, *io_overlap;
{
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    XExtCodes		 		*codes;

    if (!(codes = _VEXCheckExtension (dpy))) {
	return (False);
    }

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    if (videoXExtData->private_data) {
	*input_overlap = 
		((VideoInfo *)videoXExtData->private_data)->input_overlap;
	*capture_overlap = 
		((VideoInfo *)videoXExtData->private_data)->capture_overlap;
	*io_overlap =
		((VideoInfo *)videoXExtData->private_data)->io_overlap;
	return (True);
    }

    return (False);
}
Status XVEXVideoTimestamps( dpy, screen_number, video_change_time, 
	video_connectivity_time)
    Display *dpy;
    int screen_number;
    unsigned long *video_change_time;
    unsigned long *video_connectivity_time;
{
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    XExtCodes		 		*codes;

    if (!(codes = _VEXCheckExtension (dpy))) {
	return (False);
    }

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    if (videoXExtData->private_data) {
	*video_change_time = 
		((VideoInfo *)videoXExtData->private_data)->query_video_time;
	*video_connectivity_time = 
		((VideoInfo *)videoXExtData->private_data)->video_connect_time;
	return (True);
    }

    return (False);
}

XVEXConnectLabel *XVEXGetConnectLabel(dpy, screen_number)
    Display *dpy;
    int screen_number;
{
    int nrow, ncol, nvin, nvout, nvdev;
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    XExtCodes *codes;
    VideoInfo *pVideoInfo;
    XVEXConnectLabel *pConnLabel;
    int i;

    if (!(codes = _VEXCheckExtension (dpy))) {
	return (XVEXConnectLabel *)NULL;
    }

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    if (videoXExtData->private_data) {
	pVideoInfo = (VideoInfo *)videoXExtData->private_data;
	nvin = pVideoInfo->nvin;
	nvout = pVideoInfo->nvout;
	nvdev = pVideoInfo->nvdev;
	ncol = nvout + nvdev;
	nrow = nvin + nvdev;
	pConnLabel = (XVEXConnectLabel *) Xmalloc(
		sizeof(XVEXConnectLabel) + 
		(ncol << 2) +
		(nrow << 2) );
	if (!pConnLabel)
	    return (XVEXConnectLabel *)NULL;
	pConnLabel->nrow = nrow;
	pConnLabel->ncol = ncol;
	pConnLabel->row = (XID *)(pConnLabel + 1);
	pConnLabel->col = pConnLabel->row + nrow;
	/*
	 * Fill in vdev ids, then vouts, then vins
	 */
	for (i=0; i < nvdev; i++) {
	    pConnLabel->row[i] = pConnLabel->col[i] = pVideoInfo->vdev[i].id; 
	}
	for (i=0; i < nvout; i++) {
	    pConnLabel->col[nvdev + i] = pVideoInfo->vout[i].id; 
	}
	for (i=0; i < nvin; i++) {
	    pConnLabel->row[nvdev + i] = pVideoInfo->vin[i].id; 
	}

	return pConnLabel;

    }

    return (XVEXConnectLabel *)NULL;
}


unsigned char **XVEXGetConnectState(dpy, screen_number, index_return)
    Display *dpy;
    int screen_number;
    long *index_return;
{
    int nrow, ncol, nvin, nvout, nvdev;
    XEDataObject object;
    XExtData **pScreenXExtData;
    XExtData *videoXExtData;
    XExtCodes *codes;
    VideoInfo *pVideoInfo;
    unsigned char **pConnState;
    int i;
    int nbytesMatrix;
    unsigned char *pBytes;

    if (!(codes = _VEXCheckExtension (dpy))) {
	return (unsigned char **)NULL;
    }

    object.screen = ScreenOfDisplay(dpy, screen_number);
    pScreenXExtData = XEHeadOfExtensionList(object);
    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
    if (videoXExtData->private_data) {
	pVideoInfo = (VideoInfo *)videoXExtData->private_data;
	nvin = pVideoInfo->nvin;
	nvout = pVideoInfo->nvout;
	nvdev = pVideoInfo->nvdev;
	ncol = nvout + nvdev;
	nrow = nvin + nvdev;
	nbytesMatrix = ncol * nrow;
	if (nbytesMatrix <= 0)
	    return (unsigned char **)NULL;
	pConnState = (unsigned char **) 
		      Xmalloc(nrow * sizeof(unsigned char *) + (nbytesMatrix));
	if (!pConnState)
	    return (unsigned char **)NULL;
	/*
	 * The top part of pConnState is row pointers.
	 * The bottom part is the array of chars
	 */
	pBytes = (unsigned char *) (pConnState + nrow);
	for (i=0; i < nrow; pBytes += ncol, i++)
	    pConnState[i] = pBytes;
	bcopy(pVideoInfo->cur_state.matrix, pConnState + nrow, nbytesMatrix);
	*index_return = pVideoInfo->cur_state.index;

	return pConnState;
    }

    return (unsigned char **)NULL;
}

