/* $Header: VEXUtil.c,v 1.6 90/04/16 16:15:12 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_EVENTS
#define NEED_REPLIES
#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "stdio.h"

struct DpyHasVideo {
    struct DpyHasVideo  *next;
    Display             *dpy;
    Bool                gotit;
    XExtCodes           codes;
    XVEXRequestEvent	save;
};

static struct DpyHasVideo  *lastChecked, *dpysHaveVideo;

static XExtCodes    *queryExtension ();
static freeXExtData();

static struct DpyHasVideo *FindVideoDpy(dpy)
    Display     *dpy;
{
    struct DpyHasVideo	*dpyHas;

    for (dpyHas = dpysHaveVideo; dpyHas; dpyHas = dpyHas->next) {
	if (dpyHas->dpy == dpy)
	    return(dpyHas);
    }
    return (NULL);
}

/*ARGSUSED*/
static int videoCloseDisplay (dpy, codes)
    Display	*dpy;
    XExtCodes	*codes;
{
    struct DpyHasVideo	*dpyHas, *prev;

    prev = 0;
    for (dpyHas = dpysHaveVideo; dpyHas; dpyHas = dpyHas->next) {
	if (dpyHas->dpy == dpy)
	    break;
	prev = dpyHas;
    }
    if (!dpyHas)
	return 0;
    if (prev)
	prev->next = dpyHas->next;
    else
	dpysHaveVideo = dpyHas->next;
    if (dpyHas == lastChecked)
	lastChecked = (struct DpyHasVideo *) NULL;
    XFree (dpyHas);

    return 0;
}

XExtCodes *_VEXCheckExtension (dpy)
    Display *dpy;
{
    if (lastChecked && lastChecked->dpy == dpy) {
	if (lastChecked->gotit == 0)
	    return 0;
	return &lastChecked->codes;
    }
    return queryExtension (dpy);
}

				    
static int videoError (dpy, err, codes, ret_code)
    Display	*dpy;
    xError 	*err;
    XExtCodes	*codes;
    int 	*ret_code;
{
    if (err->majorCode == codes->major_opcode && 
	    err->minorCode == X_QueryVideo && 
	    (int)err->errorCode == BadMatch) {
	ret_code = 0;
	return 1;
    }

    return 0;
}

static char *videoErrorString (dpy, code, codes, buffer, nbytes)
    Display	*dpy;
    int 	code;		/* Error code */
    XExtCodes	*codes;
    char 	*buffer;
    int		nbytes;		/* n bytes to copy to buffer */
{
    char *defaultp = NULL;
    char buf[32];
    static char *VideoErrorStr = "BadVideo";

    if (code - codes->first_error == BadVideo) {
	sprintf(buf, "%d", code);
	defaultp = VideoErrorStr;
	XGetErrorDatabaseText(dpy, "VEXError", buf, defaultp, buffer, nbytes);
	return buffer;
    }
    
    return (char *)NULL;
}

/*
 * reformat a wire event into an XEvent structure of the right type.
 */
static int videoWireToEvent (dpy, re, event)
    Display *dpy;
    XEvent  *re;	/* pointer to where event should be reformatted */
    xEvent  *event;	/* wire protocol event */
{
    XExtCodes		*codes;

    codes = _VEXCheckExtension (dpy);
    if (!codes)
	return False;

        re->type = event->u.u.type & 0x7f;
#ifdef R3
        ((XAnyEvent *)re)->serial = event->u.u.sequenceNumber;
#else
        ((XAnyEvent *)re)->serial = _XSetLastRequestRead(dpy,
                                        (xGenericReply *)event);
#endif
        ((XAnyEvent *)re)->send_event = ((event->u.u.type & 0x80) != 0);
        ((XAnyEvent *)re)->display = dpy;

   /*
    *  Ignore the leading bit of the event type since it is set when a
    *  client sends an event rather than the server. 
    */
    switch ((event->u.u.type & 0x7f) - codes->first_event) {
	case VEXControl:
	{
	    XVEXControlEvent *hostEvent = (XVEXControlEvent *) re;
	    xVideoControlEvent *wireEvent = 
		    (xVideoControlEvent *) event;

	    hostEvent->window = 0;
	    hostEvent->vid = wireEvent->vid;
	    hostEvent->name = wireEvent->name;
	    hostEvent->time = wireEvent->time;
	    hostEvent->state = wireEvent->state;
	    return True;
	}
	case VEXViolation:
	{
	    XVEXViolationEvent *hostEvent = (XVEXViolationEvent *) re;
	    xVideoViolationEvent *wireEvent = 
		    (xVideoViolationEvent *) event;

	    hostEvent->drawable = wireEvent->id;
	    hostEvent->vid = wireEvent->vid;
	    hostEvent->time = wireEvent->time;
	    hostEvent->action_mask = wireEvent->actionMask;
	    hostEvent->state = wireEvent->state;
	    return True;
	}
	case VEXSync:
	{
	    XVEXSyncEvent *hostEvent = (XVEXSyncEvent *) re;
	    xVideoSyncEvent *wireEvent = 
		    (xVideoSyncEvent *) event;

	    hostEvent->drawable = wireEvent->id;
	    hostEvent->vid = wireEvent->vid;
	    hostEvent->time = wireEvent->time;
	    hostEvent->state = wireEvent->state;
	    return True;
	}
	case VEXOverride:
	{
	    XVEXOverrideEvent *hostEvent = (XVEXOverrideEvent *) re;
	    xVideoOverrideEvent *wireEvent = 
		    (xVideoOverrideEvent *) event;

	    hostEvent->drawable = wireEvent->id;
	    hostEvent->vid = wireEvent->vid;
	    hostEvent->time = wireEvent->time;
	    return True;
	}
	case VEXChange:
	{
	    XVEXChangeEvent *hostEvent = (XVEXChangeEvent *) re;
	    xVideoChangeEvent *wireEvent = 
		    (xVideoChangeEvent *) event;

	    hostEvent->window = 0;
	    hostEvent->screen = wireEvent->screen;
	    hostEvent->vdev = wireEvent->vdev;
	    hostEvent->time = wireEvent->time;
	    hostEvent->state = wireEvent->state;
	    return True;
	}
	case VEXConnectivity:
	{
	    XEDataObject object;
	    XExtData **pScreenXExtData;
	    XExtData *videoXExtData;
	    unsigned long queryVEXTime;
	    unsigned long videoConnectivityTime;

	    XVEXConnectivityEvent *hostEvent = 
		    (XVEXConnectivityEvent *) re;
	    xVideoConnectivityStateEvent *wireEvent = 
		    (xVideoConnectivityStateEvent *) event;

	    hostEvent->window = 0;
	    hostEvent->screen = wireEvent->screen;
	    hostEvent->new_state = wireEvent->newState;
	    hostEvent->time = wireEvent->time;


	    /*
	     * Overwrite vinfo current state and timestamp
	     * if the event timestamp is more current than video_connect_time.
	     */
	    object.screen = ScreenOfDisplay(dpy, hostEvent->screen);
	    pScreenXExtData = XEHeadOfExtensionList(object);
	    videoXExtData = XFindOnExtensionList(pScreenXExtData, codes->extension);
	    videoConnectivityTime = 
	       ((VideoInfo *)videoXExtData->private_data)->video_connect_time;
	    if (    ((hostEvent->time > videoConnectivityTime) &&
			(hostEvent->time - videoConnectivityTime) < 
			(unsigned long)(1 << 31)) ||
		    ((hostEvent->time < videoConnectivityTime) &&
			(videoConnectivityTime - hostEvent->time) < 
			(unsigned long)(1 << 31))) {
		((VideoInfo *)videoXExtData->private_data)->video_connect_time
			= hostEvent->time;
	    }
	    return True;
	}
	case VEXRequest:
	{
	    XVEXRequestEvent *hostEvent;
	    xVideoRequestEvent *wireEvent = (xVideoRequestEvent *) event;
	    struct DpyHasVideo	*dpyHas = FindVideoDpy(dpy);

	    if (dpyHas == NULL) {
		fprintf(stderr, "Request event, but no dpy\n");
		return (_XUnknownWireEvent(dpy, re, event));
	    }
	    hostEvent = &dpyHas->save;

	    hostEvent->window = 0;
	    hostEvent->src = wireEvent->src;
	    hostEvent->dst = wireEvent->dst;
	    hostEvent->cmap = wireEvent->dst;
	    hostEvent->src_x = wireEvent->srcx;
	    hostEvent->src_y = wireEvent->srcy;
	    hostEvent->dst_x = wireEvent->dstx;
	    hostEvent->dst_y = wireEvent->dsty;
	    hostEvent->src_width = wireEvent->srcWidth;
	    hostEvent->src_height = wireEvent->srcHeight;
	    hostEvent->dst_width = wireEvent->dstWidth;
	    hostEvent->dst_height = wireEvent->dstHeight;

	    return False; /* wait for the second half */
	}
	case VEXRequestAddendum:
	{
	    XVEXRequestEvent *hostEvent = (XVEXRequestEvent *) re;
	    xVideoRequestAddendumEvent *wireEvent = 
		    (xVideoRequestAddendumEvent *) event;
	    struct DpyHasVideo	*dpyHas = FindVideoDpy(dpy);

	    if (dpyHas == NULL) {
		fprintf(stderr, "Request event, but no dpy\n");
		return (_XUnknownWireEvent(dpy, re, event));
	    }
	    *hostEvent = dpyHas->save;

	    hostEvent->redirect = wireEvent->redirect;
	    hostEvent->full_motion = wireEvent->fullMotion;
	    hostEvent->request = wireEvent->request;
	    hostEvent->priority = wireEvent->priority;
	    hostEvent->subwindow_mode = wireEvent->subwindowMode;
	    hostEvent->time = wireEvent->time;
	    return True;
	}
    }
    return False;
}

/*
 * reformat an XEvent structure into a wire event.
 */
static int videoEventToWire (dpy, re, event)
    Display *dpy;
    XEvent  *re;	/* pointer to host event structure */
    xEvent  *event;	/* wire protocol event */
{
    XExtCodes		*codes;


    codes = _VEXCheckExtension (dpy);
    if (!codes)
	return False;

    event->u.u.type = ((XAnyEvent *)re)->type | 
	    (((XAnyEvent *)re)->send_event ? 0x80 : 0);
    event->u.u.sequenceNumber = ((XAnyEvent *)re)->serial & 0xffff;

   /*
    *  Ignore the leading bit of the event type since it is set when a
    *  client sends an event rather than the server. 
    */
    switch ((re->type & 0x7f) - codes->first_event) {
	case VEXControl:
	{
	    XVEXControlEvent *hostEvent = (XVEXControlEvent *) re;
	    xVideoControlEvent *wireEvent = 
		    (xVideoControlEvent *) event;

	    wireEvent->vid = hostEvent->vid;
	    wireEvent->name = hostEvent->name;
	    wireEvent->time = hostEvent->time;
	    wireEvent->state = hostEvent->state;
	    return True;
	}
	case VEXViolation:
	{
	    XVEXViolationEvent *hostEvent = (XVEXViolationEvent *) re;
	    xVideoViolationEvent *wireEvent = 
		    (xVideoViolationEvent *) event;

	    wireEvent->id = hostEvent->drawable;
	    wireEvent->vid = hostEvent->vid;
	    wireEvent->time = hostEvent->time;
	    wireEvent->actionMask = hostEvent->action_mask;
	    wireEvent->state = hostEvent->state;
	    return True;
	}
	case VEXSync:
	{
	    XVEXSyncEvent *hostEvent = (XVEXSyncEvent *) re;
	    xVideoSyncEvent *wireEvent = 
		    (xVideoSyncEvent *) event;

	    wireEvent->id = hostEvent->drawable;
	    wireEvent->vid = hostEvent->vid;
	    wireEvent->time = hostEvent->time;
	    wireEvent->state = hostEvent->state;
	    return True;
	}
	case VEXOverride:
	{
	    XVEXOverrideEvent *hostEvent = (XVEXOverrideEvent *) re;
	    xVideoOverrideEvent *wireEvent = 
		    (xVideoOverrideEvent *) event;

	    wireEvent->id = hostEvent->drawable;
	    wireEvent->vid = hostEvent->vid;
	    wireEvent->time = hostEvent->time;
	    return True;
	}
	case VEXChange:
	{
	    XVEXChangeEvent *hostEvent = (XVEXChangeEvent *) re;
	    xVideoChangeEvent *wireEvent = 
		    (xVideoChangeEvent *) event;

	    wireEvent->screen = hostEvent->screen;
	    wireEvent->vdev = hostEvent->vdev;
	    wireEvent->time = hostEvent->time;
	    wireEvent->state = hostEvent->state;
	    return True;
	}
	case VEXConnectivity:
	{
	    XVEXConnectivityEvent *hostEvent = 
		    (XVEXConnectivityEvent *) re;
	    xVideoConnectivityStateEvent *wireEvent = 
		    (xVideoConnectivityStateEvent *) event;

	    wireEvent->screen = hostEvent->screen;
	    wireEvent->newState = hostEvent->new_state;
	    wireEvent->time = hostEvent->time;
	    return True;
	}
	case VEXRequest:
	{
	    /*
	     * for this to happen, the way that XSendEvent calls
	     * (*dpy->wire_vec)() must be changed to allow multiple
	     * events to be returned.
	     */
	    (void) fprintf(stderr, "can't format VideoRequest to wire\n");
	    return False;
	}
    }
    return False;
}

static freeXExtData(extension)
    XExtData *extension;
{
    _VEXFreeVideoInfo((VideoInfo *)extension->private_data);
}

void _VEXFreeVideoInfo(pVideoInfo)
    VideoInfo *pVideoInfo;
{
    int i,j;

    if (!pVideoInfo)
	return;

    if (pVideoInfo->ndepths > 0)
	XFree ((char *) pVideoInfo->depths);
    /*
     * All matrixes were allocated in the same block, pointed to by the first
     * element in adjMatrix
     */
    if (pVideoInfo->nadjacency_matrices > 0) {
	XFree ((char *) pVideoInfo->adj_matrix[0]);
	XFree ((char *) pVideoInfo->adj_matrix);
	XFree (pVideoInfo->cur_state.matrix);
    }
    if (pVideoInfo->ntransitions > 0)
	XFree ((char *) pVideoInfo->transitions);

    if (pVideoInfo->nvin > 0) {
	for (j = 0; j < pVideoInfo->nvin; j++) {
	    for (i = 0; i < pVideoInfo->vin[j].ndevice_controls; i++)
		XFree (pVideoInfo->vin[j].device_controls[i].value.p8list);
	    XFree ((char *) pVideoInfo->vin[j].device_controls);
	    XFree ((char *) pVideoInfo->vin[j].model_info.window_models);
	    XFree ((char *) pVideoInfo->vin[j].model_info.pixmap_models);
	    XFree ((char *) pVideoInfo->vin[j].geometry.placement);
	}
	XFree ((char *) pVideoInfo->vin);
    }

    if (pVideoInfo->nvout > 0) {
	for (j = 0; j < pVideoInfo->nvout; j++) {
	    for (i = 0; i < pVideoInfo->vout[j].ndevice_controls; i++)
		XFree (pVideoInfo->vout[j].device_controls[i].value.p8list);
	    XFree ((char *) pVideoInfo->vout[j].device_controls);
	    XFree ((char *) pVideoInfo->vout[j].model_info.window_models);
	    XFree ((char *) pVideoInfo->vout[j].model_info.pixmap_models);
	    XFree ((char *) pVideoInfo->vout[j].geometry.placement);
	}
	XFree ((char *) pVideoInfo->vout);
    }

    if (pVideoInfo->nvdev > 0) {
	for (j = 0; j < pVideoInfo->nvdev; j++) {
	    for (i = 0; i < pVideoInfo->vdev[j].ndevice_controls; i++)
		XFree (pVideoInfo->vdev[j].device_controls[i].value.p8list);
	    XFree ((char *) pVideoInfo->vdev[j].device_controls);
	}
	XFree ((char *) pVideoInfo->vdev);
    }

    XFree ((char *) pVideoInfo);
}

static XExtCodes *queryExtension (dpy)
    register Display *dpy;
{
    struct DpyHasVideo	*dpyHas;
    XExtCodes		*codes;
    int			i;
    XExtData		**pScreenXExtData;
    XEDataObject	object;
    XExtData		*pXExtData;

    dpyHas = FindVideoDpy(dpy);
    if (!dpyHas) {
	dpyHas = (struct DpyHasVideo *) Xmalloc (sizeof (struct DpyHasVideo));
	if (!dpyHas)
	    return (XExtCodes *) 0;
	dpyHas->next = dpysHaveVideo;
	dpysHaveVideo = dpyHas;

	dpyHas->dpy = dpy;
	if (dpyHas->gotit = (codes = XInitExtension (dpy, VEX_NAME)) != 0) {
	    dpyHas->codes = *codes;
	    /*
	     * initialize the various Xlib function vectors
	     */
	    XESetCloseDisplay (dpy, codes->extension, videoCloseDisplay);
	    XESetError(dpy, codes->extension, videoError);
	    XESetErrorString(dpy, codes->extension, videoErrorString);
	    for (i = 0; i < VideoNumberEvents; i++) {
		XESetWireToEvent (dpy, codes->first_event + i, videoWireToEvent);
		XESetEventToWire (dpy, codes->first_event + i, videoEventToWire);
	    }
	    /*
	     * Allocate a XExtData structure for each screen of this display
	     * and attach them to screen structures
	     *
	     * Call QueryVideo on each screen and attach info structures
	     * to XExtData structures for screens which have video hdwr.
	     */
	    for (i=0; i<ScreenCount(dpy); i++) {
		object.screen = ScreenOfDisplay(dpy, i);
		pScreenXExtData = XEHeadOfExtensionList(object);
		pXExtData = (XExtData *) Xmalloc(sizeof(XExtData));
		pXExtData->number = codes->extension;
		pXExtData->free_private = freeXExtData;
		(void) _VEXQueryVideo(dpy, RootWindow(dpy, i),
			(VideoInfo **)&pXExtData->private_data, codes);
		if (pXExtData->private_data)
		  ((VideoInfo *)pXExtData->private_data)->video_connect_time=
			((VideoInfo *)pXExtData->private_data)->query_video_time;
		XAddToExtensionList(pScreenXExtData, pXExtData);

	    }
	    
	}
    }
    lastChecked = dpyHas;
    if (!dpyHas->gotit)
	return (XExtCodes *) 0;
    return &dpyHas->codes;
}
