/* $Header: XVEXChCont.c,v 1.4 90/04/19 11:53:12 scotthe Exp $ */
/************************************************************
Copyright 1989,1990 by Tektronix Inc.
Copyright 1989,1990 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include "Xlibint.h"
#include "VEXlibint.h"
#include "Xutil.h"
#include "VEXlib.h"
#include "VEXproto.h"


XVEXChangeControls(dpy, settings, nsettings)
    Display *dpy;
    XVEXSetting settings[];
    unsigned long nsettings;
{
    register xChangeVideoControlsReq	*req;
    XExtCodes		 		*codes;
    int					i;
    xSetting				xSettingTmp;
    XVEXSetting				*sp;
    int settingsize, protosize;
    int first;

    if (!(codes = _VEXCheckExtension (dpy)))
	return;
    settingsize = SIZEOF(xSetting) >> 2;
    first = 0;
    LockDisplay (dpy);
    while (nsettings - first > 0) {
	GetReq (ChangeVideoControls, req);
	req->nSettings = 0;
	req->reqType = codes->major_opcode;
	req->videoReqType = X_ChangeVideoControls;
	for (i=first; i < nsettings; i++) {
	    protosize = settingsize + ((settings[i].length + 3) >> 2);
#ifdef needed
	    if (protosize > dpy->max_request_size){
		/* XXX This should never happen, but we can't stop it.
		 * What do we do??
		 * Let's semi-panic and change the length field in the
		 * client setting structure to a size that will not exceed
		 * dpy->max_request_size;
		 */
		settings[i].length = 0; protosize = settingsize;
	    }
#endif /* needed */
	    req->length += protosize;
	    if (req->length > dpy->max_request_size) {
		req->length -= protosize;
		break;
	    }
	    req->nSettings++;
	}
	/* 
	 * XSetting != xSetting
	 */
	for (i=first; i < first + req->nSettings; i++) {
	    sp = &settings[i];
	    xSettingTmp.name = sp->name;
	    xSettingTmp.id = sp->id;
	    xSettingTmp.format = sp->format;
	    xSettingTmp.length = sp->length;
	    Data(dpy, (char *)&xSettingTmp,  SIZEOF (xSetting));
	    /*
	     * Note, the Data* macros will pad the output buffer to 
	     * 32 bit boundaries
	     */
	    switch (sp->format) {
		case 16:
		    Data16(dpy, sp->value.p16list, sp->length);
		    break;
		case 32:
		    Data32(dpy, sp->value.p32list, sp->length);
		    break;
		default:
		    Data(dpy, sp->value.p8list, sp->length);
		    break;
	    }
	}
	first += req->nSettings;
    }

    UnlockDisplay (dpy);
    SyncHandle ();
}
