/* pioneer.h */

/* 
	Jeff Glover
	Copyright 1989, Tektronix, Inc.  All Rights Reserved.
	jeffg@loki.wv.tek.com
*/

/* PIONEER LD-V6000A interface codes from the manual */

#ifndef PIONEER_H
#define PIONEER_H

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* the following are possible commands */

#define	PIONEER_RPLAY		"@0FECFA"
#define	PIONEER_RFAST		"@8FECFA"
#define	PIONEER_RSLOW		"@EDFA"
#define	PIONEER_RSTEP		"@FE"
#define	PIONEER_RSCAN		"@4FECFA"

#define	PIONEER_FPLAY		"@FD"
#define	PIONEER_FFAST		"@8FECF2"
#define	PIONEER_FSLOW		"@EDF2"
#define	PIONEER_FSTEP		"@F6"
#define	PIONEER_FSCAN		"@4FECF2"

#define	PIONEER_SEARCH		"@F7"
#define PIONEER_AUTOSTOP	"@F3"
#define PIONEER_STILL		"@FB"	/* stops disc, displays current frame */
#define PIONEER_INDEXON		"@0FF1"
#define PIONEER_INDEXOFF	"@3FF1"
#define PIONEER_TOGGLE		"@F1"
#define PIONEER_CH1ON		"@0FF4"	/* audio channel 1 on */
#define PIONEER_CH1OFF		"@3FF4"	/* ........ off */
#define PIONEER_CH2ON		"@0FFC"	/* audio channel 2 on */
#define PIONEER_CH2OFF		"@3FFC"	/* ........ off */

#define PIONEER_ADDRINQ		"@D3"	/* frame # readback, gives 4 bytes */

#define PIONEER_REJECT		"@F9"	/* unload disc, etc. */
#define PIONEER_STATUSINQ	"@D4"	/* get status */
#define PIONEER_PLAY		"@FD"	/* play until stopped */
#define PIONEER_SETFRAME1	"@0FF7"	/* set frame 1, used by LOAD */

/* the following are possible return values */

#define PIONEER_ACK	0x0
#define PIONEER_NACK (-1)

typedef struct _pionStatus {
    int scanExec;
    int searchExec;
    int autoStop;
    int inputWhilePlaying;
    int inputAtFreezeFrame;
    int playNormalForward;
    int freezeFrame;
    int playMultiFwd;
    int playMultiRev;
    int spinUp;
    int parked;
    int rejecting;
    int lidOpen;
    int motorOff;
    int retry;
    char status[2];
    char inchars[16];
} PioneerStatus, *PioneerStatusPtr;

#endif PIONEER_H
