/* $Header: pioneerini.c,v 1.12 90/04/20 16:25:11 toddb Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include "X.h"
#include "Xos.h"
#include "Xproto.h"
#include "misc.h"
#include "extnsionst.h"
#include "opaque.h"

#include "VEX.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "VEXctrl.h"
#include "ctrlproto.h"
#include "videostr.h"
#include "ctrl.h"
#include "rpd_driver.h"

typedef struct {
    int			fWaiting;
    VideoID     	vid;
    Atom        	name;
    int			cmd;
    int			frame;
    long		cmdTime;	/* Current time in milliseconds */
    unsigned long	timeout;	/* in milliseconds */
    struct timeval	waittime;	/* How long to let server sleep */
} ControlBlockdata;
static void BlockHandlerLDV6000(); 
static void WakeupHandlerLDV6000(); 
static  ControlBlockdata blockDataLDV6000;

static RPD rpdLDV6000 = {
    -1		/* fd */
};

#define ArrayLength(list)       ((sizeof list)/(sizeof list[0]))

#define NLDV6000CTRLS	ArrayLength(vexLDV6000Ctrls)

#ifdef later
static xvexCtrlPlay vexLDV6000Play = {
    (Forward|Backward|SeekFrameA|ContinuousPlayForward), /* NormalCapab. */
    {30, 1},						 /* Normal Speed */
    (Forward|Backward|SeekFrameA),			 /* SlowCapab. */
    /* Slow speed: 30/1, 30/2, 30/3,...30/127 */
    { 30,0,30,LinearRange, 1,1,127,LinearRange},	 /* SlowSpeed */
    (Forward|Backward|SeekFrameA),			 /* FastCapab. */
    /* Fast speed: 30/1, 60/1, 90/1 */
    { 30,30,90,LinearRange, 1,0,1,LinearRange},		 /* FastSpeed */
};

static xvexCtrlCapability vexLDV6000FreezeFrame = {
    (SeekFrameA|RelativeFrameA)
};

static xvexCtrlCapability vexLDV6000SingleStep = {
    (SeekFrameA|RelativeFrameA)
#endif later

static char vexLDV6000Name[] = "PioneerLDV6000";

struct controlName {
    int cmd;
    char *name;
} ;

static struct controlName vexLDV6000CtrlIDs[] = {
    {SEARCH_CMD, VEX_CTRL_SEARCH},
    {SEGPLAY_CMD, VEX_CTRL_SEGPLAY},
    {VAR_SPEED_CMD, VEX_CTRL_VAR_SPEED},
    {JOG_CMD, VEX_CTRL_JOG},
    {GET_FRAME_CMD, VEX_CTRL_GET_FRAME},
    {INDEX_ON_CMD, VEX_CTRL_INDEX_ON},
    {INDEX_OFF_CMD, VEX_CTRL_INDEX_OFF},
    {LOAD_CMD, VEX_CTRL_LOAD},
    {UNLOAD_CMD, VEX_CTRL_UNLOAD},
    {INDEX_TOGGLE_CMD, VEX_CTRL_INDEX_TOGGLE},
    {RESET_CMD, VEX_CTRL_RESET},
    {A1_ON_CMD, VEX_CTRL_A1_ON},
    {A1_OFF_CMD, VEX_CTRL_A1_OFF},
    {A2_ON_CMD, VEX_CTRL_A2_ON},
    {A2_OFF_CMD, VEX_CTRL_A2_OFF},
    {VIDEO_DISK_CMD, VEX_CTRL_VIDEO_DISK},
    {INITIALIZE_CMD, VEX_CTRL_INITIALIZE},
};

static ControlElement vexLDV6000Ctrls[] = {
#ifdef later
    {{0, 0, DEVICE, 32, 32, 20, sizeof(xvexCtrlPlay), &vexLDV6000Play,}
	VEX_CTRL_PLAY},
    {{0, 0, DEVICE, 32, 32,  8,   4, &vexLDV6000FreezeFrame},
	VEX_CTRL_FREEZE_FRAME},
    {{0, 0, DEVICE, 32, 32,  4,   0, (char *)NULL},
	VEX_CTRL_VIDEO},
    {{0, 0, DEVICE, 32, 32,  4,   0, (char *)NULL},
	VEX_CTRL_INDEX},
    {{0, 0, DEVICE, 32, 32,  4,   4, &vexLDV6000SingleStep},
	VEX_CTRL_SINGLE_STEP},
#endif later
    /* VEX_CTRL_SEARCH */
    {{0, 0, Device, 32, 32, 0,  sizeof(xvexSettingSearch),   0}, (char *)NULL},
    /* VEX_CTRL_SEGPLAY */
    {{0, 0, Device, 32, 32, 0,  sizeof(xvexSettingSegPlay),   0}, (char *)NULL},
    /* VEX_CTRL_VAR_SPEED */
    {{0, 0, Device, 32, 32, 0,  sizeof(xvexSettingVarSpeed),  0}, (char *)NULL},
    /* VEX_CTRL_JOG */
    {{0, 0, Device, 32, 32, 0,  sizeof(xvexSettingJog),   0}, (char *)NULL},
    /* VEX_CTRL_GET_FRAME */
    {{0, 0, Device, 32, 32, 0,  sizeof(xvexSettingGetFrame),  0}, (char *)NULL},
    /* VEX_CTRL_INDEX_ON */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_INDEX_OFF */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_LOAD */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_UNLOAD */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_INDEX_TOGGLE */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_RESET */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_A1_ON */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_A1_OFF */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_A2_ON */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_A2_OFF */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
    /* VEX_CTRL_VIDEO_DISK */
    {{0, 0, Device, 32, 8, 0,  0, sizeof(vexLDV6000Name)}, vexLDV6000Name},
    /* VEX_CTRL_INITIALIZE */
    {{0, 0, Device, 32, 32, 0,  0,   0}, (char *)NULL},
};

/*
 *	NAME
 *		IsFreezeFrameLDV6000 - Is LaserDisc frozen on proper frame?
 *
 *	SYNOPSIS
 */
Bool
IsFreezeFrameLDV6000(frame)
    int frame;
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		TRUE if LaserDisc is "FreezeFraming" on proper frame.
 *
 */
{
    return ((rpdLDV6000.fd != -1) && (pioneer_getframe(&rpdLDV6000) == frame));
}

/*
 *	NAME
 *		BlockHandlerLDV6000 - BlockHandler for LDV6000 LaserDIsc
 *
 *	SYNOPSIS
 */
/*ARGSUSED*/
static void BlockHandlerLDV6000(blockData, pTimeout, pReadmask)
    pointer blockData;
    pointer pTimeout;
    pointer pReadmask;
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		None
 *
 */
{
    long millis;
    struct timeval *waittime, *timeout;


    if (!((ControlBlockdata *) blockData)->fWaiting)
	return;

    switch (((ControlBlockdata *) blockData)->cmd) {
        case SEARCH_CMD:
	    if (IsFreezeFrameLDV6000(((ControlBlockdata *) blockData)->frame)) {
		((ControlBlockdata *) blockData)->fWaiting = FALSE;
		SendVideoControlEvent(((ControlBlockdata *) blockData)->vid,
			((ControlBlockdata *) blockData)->name,
			VEXControlSuccess);
	    } else {
		/*
		 * Check for timeout.  At some point, we just give up
		 * and send a failure event.  Use trick from "xterm":
		 * Do signed subtraction, but compare as unsigned.
		 */
		 millis = GetTimeInMillis();
		 if (((unsigned long)(millis - 
			((ControlBlockdata *) blockData)->cmdTime)) > 
			((ControlBlockdata *) blockData)->timeout) {
		    SendVideoControlEvent(((ControlBlockdata *) blockData)->vid,
			    ((ControlBlockdata *) blockData)->name,
			    VEXControlFail);
		    ((ControlBlockdata *) blockData)->fWaiting = FALSE;
		} else {
		    /*
		     * Adjust timeout value used in WaitForSomething to
		     * control how long the server goes to sleep waiting
		     * for input.  We want to make sure we look for our
		     * completion condition at regular intervals.
		     * XXX This requires knowing what pTimeout really is.
		     */
		     timeout = *((struct timeval **) pTimeout);
		     waittime = &((ControlBlockdata *) blockData)->waittime;
		     if (timeout == (struct timeval *) NULL ||
			    timeout->tv_sec > waittime->tv_sec ||
			    (timeout->tv_sec == waittime->tv_sec &&
			    timeout->tv_usec > waittime->tv_usec)) {
			 *((struct timeval **) pTimeout) = waittime;
		     }
		}
	    }
	    break;
	default:
	    assert(FALSE);
    };
}
/*ARGSUSED*/
static void WakeupHandlerLDV6000(blockData, result, pReadmask)
    pointer blockData;
    unsigned long result;
    pointer pReadmask;
{
}

/*
 * SEARCH timeout value, in milliseconds
 */
#define TIMEOUT_SEARCH	5000
/*
 * Allow server to sleep for 100 milliseconds
 */
#define WAITEIME_SEC	0
#define WAITEIME_USEC	100000
/*
 * Change control settings on a device.  For the sake of VideoControl
 * events, when a setting is made, this routine should either:
 *  - return immediately and arrange to asynchronously decide
 *    when the setting was done.
 *  - block, waiting for the setting to be set.
 *
 *  Returns FALSE if BadValue error.  TRUE otherwise.
 */
Bool
ChangeLDV6000Ctrls(pDeviceElement, index, pvalue, valueReturn)
    DeviceElement *pDeviceElement;
    int index;				/* index of ControlElement */
    char *pvalue;			/* Setting data */
    int *valueReturn;			/* Failing value for dix */
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		<value returned by the function -- not required for void functions>
 *
 */
{
    RPD_ptr rpd;
    int fSendEventNow = TRUE;
    int cmd = vexLDV6000CtrlIDs[index].cmd;
    int retval = 0;

    rpd = (RPD_ptr) pDeviceElement->devPrivate;
    /* XXX
     * The Pioneer LaserDisc will ignore commands while it is busy executing
     * a command.  Therefore, we assume that if we are waiting for
     * a command to complete, most commands will fail
     * See Manual for list of commands which are executed even when the player
     * is busy.
     */
    if (blockDataLDV6000.fWaiting == TRUE) {
	switch (cmd) {
	    case SEARCH_CMD:
	    case SEGPLAY_CMD:
	    case VAR_SPEED_CMD:
	    case JOG_CMD:
	    case LOAD_CMD:
	    case FORKLOAD_CMD:
		SendVideoControlEvent(pDeviceElement->id, 
			pDeviceElement->pControl[index].xc.name,
			VEXControlFail);
		return TRUE;
	    default:
		break;
	}
    }
    switch (cmd) {
        case SEARCH_CMD:
	    retval = (*rpd->search)
		    (rpd, ((xvexSettingSearch *)pvalue)->frame1, TRUE);
	    blockDataLDV6000.frame = ((xvexSettingSearch *)pvalue)->frame1;
	    blockDataLDV6000.cmdTime = GetTimeInMillis();
	    blockDataLDV6000.timeout = TIMEOUT_SEARCH;
	    blockDataLDV6000.waittime.tv_sec = WAITEIME_SEC;
	    blockDataLDV6000.waittime.tv_usec = WAITEIME_USEC;
	    /* fSendEventNow = FALSE; XXX why??? */
	    break;
	case SEGPLAY_CMD:
	    retval = (*rpd->segplay) 
			    (rpd, ((xvexSettingSegPlay *)pvalue)->frame1,
			    ((xvexSettingSegPlay *)pvalue)->frame2,
			    ((xvexSettingSegPlay *)pvalue)->speed,
			    FALSE);
	    break;
	case VAR_SPEED_CMD:
	    retval = (*rpd->varspeed) (rpd, ((xvexSettingVarSpeed *)pvalue)->num);
	    break;
	case JOG_CMD:
	    if (((xvexSettingJog *)pvalue)->num >= 1)
		retval = (*rpd->jog) (rpd, 1);
	    else if (((xvexSettingJog *)pvalue)->num <= -1)
		retval = (*rpd->jog) (rpd, -1);
	    break;
	case GET_FRAME_CMD:
	    /* Do nothing here */
	    break;
	case INDEX_ON_CMD:
	case INDEX_OFF_CMD:
	case LOAD_CMD:
	case FORKLOAD_CMD:
	case UNLOAD_CMD:
	case INDEX_TOGGLE_CMD:
	case A1_ON_CMD:
	case A1_OFF_CMD:
	case A2_ON_CMD:
	case A2_OFF_CMD:
	    retval = (*rpd->cmd) (rpd, vexLDV6000CtrlIDs[index].cmd);
	    break;
	case RESET_CMD:
	    retval = (*rpd->reset) (rpd);
	    break;
	case VIDEO_DISK_CMD:
	case INITIALIZE_CMD:
	    break;
	default:
	    break;
    }

    if (retval >= 0 && retval < LOWEST_ERROR) {
	if (fSendEventNow) {
	    SendVideoControlEvent(pDeviceElement->id, 
		    pDeviceElement->pControl[index].xc.name, VEXControlSuccess);
	} else {
	    blockDataLDV6000.fWaiting = TRUE;
	    blockDataLDV6000.cmd = cmd;
	    blockDataLDV6000.vid = pDeviceElement->id;
	    blockDataLDV6000.name = pDeviceElement->pControl[index].xc.name;
	}
    } else {
	SendVideoControlEvent(pDeviceElement->id, 
		pDeviceElement->pControl[index].xc.name, VEXControlFail);
	SetDeviceStatus(pDeviceElement->id, FALSE, TRUE);
    }

    return TRUE;
}

/*
 * Fill in the value for this control.
 * The caller has allocated the proper space which "value" points
 * to and will free it when it is no longer needed
 *
 * Returns FALSE if BadAlloc, TRUE otherwise.
 */
Bool
QueryLDV6000Ctrls(pDeviceElement, index, value)
    DeviceElement *pDeviceElement;
    int index;				/* index of ControlElement */
    char *value;			/* Value to return to dix */
/*
 *	DESCRIPTION
 *		Fill in the value for this control.
 *		The caller has allocated the proper space which "value" points
 *		to and will free it when it is no longer needed
 *
 *	RETURNS
 *		TRUE
 *
 */
{
    RPD_ptr rpd;

    rpd = (RPD_ptr) pDeviceElement->devPrivate;
    switch (vexLDV6000CtrlIDs[index].cmd) {
	case GET_FRAME_CMD:
	    ((xvexSettingGetFrame *) value)->frame1 = (*rpd->getframe) (rpd);
	    break;
	default:
	    break;
    }

    return TRUE;
}

/*
 *	NAME
 *		DeviceInitLDV6000 - Initialize LDV6000 and its controls
 *
 *	SYNOPSIS
 */
/*ARGSUSED*/
DeviceElement *
DeviceInitLDV6000(pScreen)
    ScreenPtr pScreen;
/*
 *	DESCRIPTION
 *		Initialize LDV6000 and its controls.
 *
 *	RETURNS
 *		TRUE if initialization succeeds.
 *		False otherwise.
 *
 */
{

    DeviceElement *pVideoDevice;
    RPD_ptr rpd;
    int i;



    /*
     * Allocate a DeviceElement structure to fill in and return.
     */
    pVideoDevice = (DeviceElement *) xalloc(sizeof(DeviceElement));
    if (!pVideoDevice)
	return (DeviceElement *) NULL;

    /*
     * Set BlockHandler and Wakeup handler for sending VideoControl events
     * when device settings take effect.
     * XXX If something goes wrong in initialization, this block handler
     * will still be around, getting called and doing nothing!
     */
    if (!RegisterBlockAndWakeupHandlers(BlockHandlerLDV6000, 
	    WakeupHandlerLDV6000, &blockDataLDV6000))
	return (DeviceElement *) NULL;
    blockDataLDV6000.fWaiting = FALSE;


    rpd = &rpdLDV6000;
    rpd->reset = pioneer_reset;
    rpd->cmd = pioneer_cmd;
    rpd->search = pioneer_search;
    rpd->segplay = pioneer_segplay;
    rpd->getframe = pioneer_getframe;
    rpd->varspeed = pioneer_varspeed;
    rpd->jog = pioneer_jog;
    rpd->record = NULL;
/* XXX
 * This should be controlled by reading an input file, like Galatea does.
 * For now, just hardwire it all
# Type  SysName         Model           TtyPort Baud    Parity  Output  Chan
# ===================================================================
RPD     ldv-1           PIONEER_LDV6000A tty00  9600    none    0       0-0
 */
    if (rpd->fd != -1)
	ttyutil_close(rpd->fd);
    if ( (rpd->fd = ttyutil_open("/dev/tty00", 9600, 0) ) == -1) {
	fprintf(stderr, "unable to open LDV6000 device\n");
	xfree((char *)pVideoDevice);
	return (DeviceElement *) NULL;
    }

    pVideoDevice->devPrivate = (pointer)rpd;

    pVideoDevice->type = Device;
    /* XXX
     * Should this be initialized On of Off??
     */
    pVideoDevice->onLine = TRUE;
    pVideoDevice->nControl = NLDV6000CTRLS;
    pVideoDevice->id = FakeClientID(0);
    pVideoDevice->pControl = vexLDV6000Ctrls;
    pVideoDevice->ChangeVideoControls = ChangeLDV6000Ctrls;
    pVideoDevice->QueryVideoControls = QueryLDV6000Ctrls;
    for (i=0; i<pVideoDevice->nControl; i++)
	pVideoDevice->pControl[i].xc.id = pVideoDevice->id;

    if (InternCtrlAtoms(pVideoDevice, vexLDV6000CtrlIDs))
	return pVideoDevice;
    else {
	xfree((char *)pVideoDevice);
	return (DeviceElement *) NULL;
    }

}

/*
 *	NAME
 *		InternCtrlAtoms - Intern Atoms for controls
 *
 *	SYNOPSIS
 */
InternCtrlAtoms(pDeviceElement, pControlName)
    DeviceElement *pDeviceElement;
    struct controlName *pControlName;
/*
 *	DESCRIPTION
 *		Intern Atoms for all of the controls listed in a
 *		DeviceElement structure.
 *		MakeAtom will only create a new Atom/string pair if the
 *		string has not already been interned.
 *
 *	RETURNS
 *		TRUE if all atoms are interned
 *		FALSE otherwise.
 *
 */
{
    int i;
    ControlElement *pControl;

	for (i=0, pControl = pDeviceElement->pControl;
		i < pDeviceElement->nControl;
		i++, pControl++) {
	    pControl->xc.name = MakeAtom(pControlName[i].name,
		     strlen(pControlName[i].name), TRUE);
	    if ( !ValidAtom( pControl->xc.name ))
		return FALSE;
	}

    return TRUE;
}
