/* $Header: plxinit.c,v 1.24 90/04/19 17:32:59 toddb Exp $ */
/********************************************************
Copyright 1989 by Tektronix Inc.

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include "Xplx.h"
#include "VEX.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "videostr.h"
#include "devices.h"

#define ArrayLength(list)       ((sizeof list)/(sizeof list[0]))

#define NVIN		1

#define NPLXDEPTHS	ArrayLength(vexPlxDepths)
#define NPLX1VISUALS	ArrayLength(vexPlx1Visuals)
#define NPLX8VISUALS	ArrayLength(vexPlx8Visuals)
#define NPLX12VISUALS	ArrayLength(vexPlx12Visuals)
#define NPLXFORMATS	ArrayLength(vexPlxFormats)

#ifdef needed
static PixmapFormatRec vexPlxFormats[] = {
};
#endif /* needed */

/* !!!
 * Careful, these visuals must be ordered corresponding to entries in the
 * vexPlxDepths array, and the depth information must agree.  Note that
 * when the list of unique depths are assembled by CreateVideoDepths,
 * Some of the visuals will be dropped, because the core ddx layer
 * publishes identical ones.  In particular, the depth 8 visual should
 * be identical to the core ddx parallax visual.
 */
static VisualRec vexPlx8Visuals[] = {
/* vid  class        bpRGB cmpE    nplan rMask gMask bMask oRed oGreen oBlue */
 { 0,   PseudoColor, 8,    192,    8,    0,    0,    0,    0,   0,     0, },
};

/*
 * List every depth/visual required by VEX here.
 * These will all end up as RenderModel entries.
 * Careful!!! The ordering here is used for input models
 * and output models.  The length of this list will be precisely the
 * same length of the allowed depths.
 */
static VideoVisual vexPlxDepths[] = {
/*  depth opaque visuals RGBMaskPtr          */
  { 8,    TRUE, &vexPlx8Visuals[0], (RGBMaskPtr) NULL  },
};

/*
 * each column corresponds with each row of vexPlxDepths.
 */
static unsigned char vexPlxInputModels[NVIN][NPLXDEPTHS] = {
/* vin #1 */ { WindowModel },
/* vin #2    { WindowModel|PixmapModel }, Not now */
};

static xRectangle clipSizePlx[NVIN] = {
    {0, 0, 16, 1}
};

static xPlacement PlxPlacements1[]= {
    {	/* first xPlacement */
	{30, 1},        /* 30 frames per second */
	{ 	/* src xPlacement */
	    {0, 0, 1, 1},	/* base rectangle */
	    {641, 479, 642, 480},/* limit rectangle */
	    1,1,		/* xInc, yInc */
	    1,1,		/* widthInc, heightInc */
	    VEXLinearRange
	},
	{ 	/* dst xPlacement */
	    {0, 0, 16, 1},	/* base rectangle */
	    {1279, 1023, 1280, 1024},/* limit rectangle */
	    16,1,		/* xInc, yInc */
	    16,1,		/* widthInc, heightInc */
	    VEXLinearRange
	},
	{	/* xScale xFractionRange -- only 1:1 with 1280 series */
	    1, 0, 1,		/* base, increment, limit */
	    1, 0, 1,		/* base, increment, limit */
	    VEXLinearRange, VEXLinearRange
	},
	{	/* xScale xFractionRange -- only 1:1 with 1280 series */
	    1, 0, 1,		/* base, increment, limit */
	    1, 0, 1,		/* base, increment, limit */
	    VEXLinearRange, VEXLinearRange
	},
	TRUE /* x and y scale always have to be identical */
    }
    {	/* second xPlacement */
	{5, 1},        /* 5 frames per second */
	{ 	/* src xPlacement */
	    {0, 0, 1, 1},	/* base rectangle */
	    {641, 479, 642, 480},/* limit rectangle */
	    1,1,		/* xInc, yInc */
	    1,1,		/* widthInc, heightInc */
	    VEXLinearRange
	},
	{ 	/* dst xPlacement */
	    {0, 0, 16, 1},	/* base rectangle */
	    {1279, 1023, 1280, 1024},/* limit rectangle */
	    16,1,		/* xInc, yInc */
	    16,1,		/* widthInc, heightInc */
	    VEXLinearRange
	},
	{	/* xScale xFractionRange -- we want to allow everything:
		 * {1,2,3,...1280} / {1,2,3,...640} */
	    1, 1, 1280,		/* base, increment, limit */
	    1, 1, 642,		/* base, increment, limit */
	    VEXLinearRange, VEXLinearRange
	},
	{	/* yScale xFractionRange -- we want to allow everything:
		 * {1,2,3,...1024} / {1,2,3,...480} */
	    1, 1, 1024,		/* base, increment, limit */
	    1, 1, 480,		/* base, increment, limit */
	    VEXLinearRange, VEXLinearRange
	},
	FALSE /* x and y scale don't have to be the same */
    }
};

static VideoGeometry PlxInattrs[]= {
    {	/* xVideoGeometry */
	{2997, 100},	/* 30 frames per second */
	{5994, 100},	/* (59.94) 60 fields per second */
	640, 482,	/* width, height of input (NTSC) signal */
	1,		/* Concurrent use */
	0,		/* pad */
	0,		/* Reference id (created at init time) */
	2		/* nPlacement */
    },
    PlxPlacements1	/* pointer to list of xPlacement */
};

/*
 * Initialized Device List information.  These elements will be distributed
 * to various screen structures
 */
struct DeviceLists {
    int fInitialized;
    DeviceList VideoInDevices;
    DeviceList VideoOutDevices;
    DeviceList VideoDevices;
};
static struct DeviceLists PlxDevInfo = {
    FALSE,
    {0, (DeviceElement **)NULL},
    {0, (DeviceElement **)NULL},
    {0, (DeviceElement **)NULL}
};

static Bool plxQueryVideo();
static void plxChangeConnectivity();
extern Bool plxRenderVideo();
extern void plxStopVideo();
static Bool plxUpdateTranslucent();
static Bool plxFillTranslucentRectangle();
static void plxInstallBlendmap();
static void plxUninstallBlendmap();
static int  plxListInstalledBlendmaps();
static void plxFreeDeviceInfo();
static Bool plxPreCopyWindow();
static void plxPostCopyWindow();
static void FreeVideoScreenRec();
static void FreeDeviceList();
static void FreeConnectivity();

static Bool realDdxVexInit();
/*
 * ddxVexInit -- perform ddx initialization for VEX
 *
 * If the screen has video hardware, allocate a VideoScreenRec structure
 * and initialize all the elements.
 * (ddx allocates and frees all space attached to VideoScreenRec
 * structures).  If the screen does not have video hardware, set
 * *pVideoScreenRec to NULL.
 *
 * Return FALSE if allocation failure, else TRUE.
 */

Bool
ddxVexInit(pScreen, pVideoScreenRec)
    ScreenPtr pScreen;			/* Screen to be initialized */
    VideoScreenRec **pVideoScreenRec;	/* Video data for the screen */
{
    /*
     * We have only one screen
     */
    if (pScreen->myNum != 0) {
	*pVideoScreenRec = NULL;
	return(TRUE);
    }

    if (!(*pVideoScreenRec = 
	    (VideoScreenRec *) xalloc(sizeof(VideoScreenRec)))) {
	return(FALSE);
    }

    if (! realDdxVexInit(pScreen, pVideoScreenRec)) {
	FreeVideoScreenRec(*pVideoScreenRec);
	*pVideoScreenRec = (VideoScreenRec *) NULL;
	return(FALSE);
    }

    return (TRUE);
}

static Bool
realDdxVexInit(pScreen, pVideoScreenRec)
    ScreenPtr pScreen;
    VideoScreenRec **pVideoScreenRec;
{
    plxPrivScrPtr pScreenPriv;
    VideoScreenRec *pInitVideoInfo;
    int i, j, iVinModel;
    xRenderModel *pAllowedDepth;
    extern void plxVideoReshape ();
    extern Bool dviCaptureGraphics();

/* XXX
 *  We need to wrapperize this.  rws has said that this function pointer
 *  will become part of screen struct to facilitate this.
 */
    miClipNotify (plxVideoReshape);

    pInitVideoInfo = *pVideoScreenRec;
    pInitVideoInfo->nVin = NVIN;
    pInitVideoInfo->pScreen = pScreen;
    pInitVideoInfo->inputOverlap = 0;
    pInitVideoInfo->captureOverlap = 0;
    pInitVideoInfo->ioOverlap = 0;
    pInitVideoInfo->nAllowedDepths = NPLXDEPTHS;

    /*
     * Protocol vectors
     */
    pInitVideoInfo->QueryVideo = plxQueryVideo;
    pInitVideoInfo->ChangeConnectivity = plxChangeConnectivity;
    pInitVideoInfo->RenderVideo = plxRenderVideo;
    pInitVideoInfo->StopVideo = plxStopVideo;
    pInitVideoInfo->CaptureGraphics = dviCaptureGraphics;

    /*
     * Utility vectors
     */
    pInitVideoInfo->FreeDeviceInfo = plxFreeDeviceInfo;
    pInitVideoInfo->PreCopyWindow = plxPreCopyWindow;
    pInitVideoInfo->PostCopyWindow = plxPostCopyWindow;


    /*
     * Allocate space for all the lists.
     */
    pInitVideoInfo->pAllowedDepths = (xRenderModel *) 
	    xalloc(pInitVideoInfo->nAllowedDepths * sizeof(xRenderModel));
    pInitVideoInfo->pVinModels = (unsigned char *) 
	    xalloc(pInitVideoInfo->nVin * pInitVideoInfo->nAllowedDepths);

    /*
     * Check for alloc failures and load up depths list
     */
    if (pInitVideoInfo->nVin) {
	if (!pInitVideoInfo->pVinModels)
	    return (FALSE);
    }
    if ( !CreateVideoDepths(pScreen, pInitVideoInfo, NPLXDEPTHS, vexPlxDepths))
	return (FALSE);

    /*
     * AllowedDepths:
     * fill with depths/vids for "video visuals".
     */
    pAllowedDepth = pInitVideoInfo->pAllowedDepths;
    for (i = 0; i < NPLXDEPTHS; i++) {
	pAllowedDepth->depth = vexPlxDepths[i].depth;
	pAllowedDepth->opaque = vexPlxDepths[i].opaque;
	if (vexPlxDepths[i].pVis)
	    pAllowedDepth->visualid = vexPlxDepths[i].pVis->vid;
	else
	    pAllowedDepth->visualid = None;
	if (vexPlxDepths[i].pMasks) {
	    pAllowedDepth->redMask = vexPlxDepths[i].pMasks->redMask;
	    pAllowedDepth->greenMask = vexPlxDepths[i].pMasks->greenMask;
	    pAllowedDepth->blueMask = vexPlxDepths[i].pMasks->blueMask;
	} else {
	    pAllowedDepth->redMask = 0;
	    pAllowedDepth->greenMask = 0;
	    pAllowedDepth->blueMask = 0;
	}

	pAllowedDepth++;
    }

    /*
     * Video input attributes
     */
    if (pInitVideoInfo->nVin) {
	pInitVideoInfo->pInattrs = PlxInattrs;
	pInitVideoInfo->pClipSize = clipSizePlx;
	for (i=0; i < pInitVideoInfo->nVin; i++) {
	    pInitVideoInfo->pInattrs[i].xvg.referenceId = FakeClientID(0);
	}
    }

    /*
     * Video input models
     *
     * Note that the table-driven rendermodels are exactly equal to
     * the list of allowed depths (which label the columns in this
     * matrix).
     */
    for (i = 0; i < pInitVideoInfo->nVin; i++) {
	iVinModel = i * pInitVideoInfo->nAllowedDepths; 
	for (j = 0; j < NPLXDEPTHS; j++) {
	    pInitVideoInfo->pVinModels[iVinModel++] = vexPlxInputModels[i][j];
	}
    }


    /*
     * Initialize VideoOut parameters
     */
    (void) plxInitVideoOut(pScreen, pInitVideoInfo);
    /*
     * We can get away with this because we have only one screen.  Otherwise
     * we would have to consider sharing devices across multiple screens
     * and reusing referenceId's
     */
    if (pInitVideoInfo->nVout) {
	for (i=0; i < pInitVideoInfo->nVout; i++) {
	    pInitVideoInfo->pOutattrs[i].xvg.referenceId = FakeClientID(0);
	}
    }

    /*
     * Video devices and controls
     */
    (void) plxDeviceInfoInit(pScreen, pInitVideoInfo);

    /*
     * This should really be handled as a device...
     */
    pScreenPriv = plxGetScreenPriv(pScreen);
    pScreenPriv->fullMotionVideo = (DrawablePtr)NULL;
    pScreenPriv->framemode = 0;        /* frame */
    pScreenPriv->framestart = 1;        /* even */
    pScreenPriv->dither.luma = 0;
    pScreenPriv->dither.chroma = 1;
    pScreenPriv->input = 1;
    pScreenPriv->priority = 3;

    p_dthron();
    p_flsp(pScreenPriv->priority);
#ifdef WE_HAVE_VME_BUS
    p_vid1();
    p_vpu(pInitVideoInfo->vparam);
#endif

    return(TRUE);
}

/*
 * ddx should free whatever it attached to the VideoScreenRec for
 * this screen, and also do whatever else it needs to for server
 * reset.  This routine will be called by dix for each screen.
 */
void
ddxVexReset(pScreen, pVideoScreenRec)
    ScreenPtr pScreen;			/* Screen to be reset */
    VideoScreenRec **pVideoScreenRec;	/* Video data for the screen */
{
    /*
     * We have only one screen
     */
    if (pScreen->myNum != 0) {
	*pVideoScreenRec = NULL;
	return;
    }
    FreeVideoScreenRec(*pVideoScreenRec);

    FreeDeviceList(&PlxDevInfo.VideoInDevices, TRUE);
    FreeDeviceList(&PlxDevInfo.VideoOutDevices, TRUE);
    FreeDeviceList(&PlxDevInfo.VideoDevices, TRUE);
    PlxDevInfo.fInitialized = FALSE;
    *pVideoScreenRec = NULL;
}

/*
 * ddx opportunity to delete anything it hung onto a DeviceInfo passed in
 * from dix during a QueryVideo.
 */
static void
plxFreeDeviceInfo()
{ return; }


/*
 * This routine allows ddx to update the screen's DeviceInfo before
 * QueryVideo generates its reply for the client.
 *
 * Return FALSE if allocation failure, else TRUE.
 */
/*ARGSUSED*/
static Bool
plxQueryVideo(pScreen, pdeviceInfo)
    ScreenPtr pScreen;
    DeviceInfo *pdeviceInfo;
{
    /*
     * We don't have anything to do here.
     */
    return (TRUE);
}

static void
plxChangeConnectivity()
{}

/*
 *	NAME
 *		vexProcessArgument - Process device-dependent command line args
 *
 *	SYNOPSIS
 */
/*ARGSUSED*/
int
vexProcessArgument (argc, argv, i)
    int argc;
    char *argv[];	/* in: commandline */
    int i;		/* in: current index into argv */
/*
 *	DESCRIPTION
 *		Process command line.	Part of vex/ddx interface.
 *
 *	RETURNS
 *		0 if argument is not device dependent, otherwise
 *		Count of number of elements of argv that are part of a 
 *		device dependent commandline option.
 *
 */
{
    return 0;
}

/*
 *	NAME
 *		vexUseMsg - print use of device dependent commandline options
 *
 *	SYNOPSIS
 */
void
vexUseMsg()
/*
 *	DESCRIPTION
 *		Print out correct use of device dependent commandline options.
 *		Part of vex/ddx interface.
 *
 *	RETURNS
 *		None
 *
 */
{
}

/*
 *	NAME
 *		plxDeviceInfoInit- Initialize DeviceInfo structure
 *
 *	SYNOPSIS
 */
Bool
plxDeviceInfoInit(pScreen, pInitVideoInfo)
    ScreenPtr pScreen;
    VideoScreenRec *pInitVideoInfo;
/*
 *	DESCRIPTION
 *		Initialize the DeviceInfo structure for this screen.
 *
 *	RETURNS
 *		TRUE if initialization is accomplished
 *		FALSE otherwise.
 *
 */
{
    int nDevice;
    DeviceElement **pDeviceElement;
    DeviceInfo *pDeviceInfo;
    int i, j;
    int nAdjacencyMatrices;
    unsigned char *pCell, *pAdjMat;
    int nRow, nCol;


    pDeviceInfo = &pInitVideoInfo->deviceInfo;
    pDeviceInfo->devices.nDevice = 0;
    pDeviceInfo->devices.pDeviceElement = (DeviceElement **)NULL;
    pDeviceInfo->connectivity.nAdjacencyMatrices = 0;
    pDeviceInfo->connectivity.pAdjMat = (unsigned char *)NULL;
    pDeviceInfo->connectivity.pTransitions = (xVideoTransition *)NULL;
    pDeviceInfo->connectivity.nTransitions = 0;

    /*
     * Get lists of DeviceElement's.
     */
    if (!PlxDevInfo.fInitialized) {
	if (!plxVideoInDeviceInit(pScreen, &PlxDevInfo.VideoInDevices))
	    return FALSE;
	if (!plxVideoOutDeviceInit(pScreen, &PlxDevInfo.VideoOutDevices)) {
	    FreeDeviceList(&PlxDevInfo.VideoInDevices, TRUE);
	    return FALSE;
	}
	if (!plxVideoDeviceInit(pScreen, &PlxDevInfo.VideoDevices)) {
	    FreeDeviceList(&PlxDevInfo.VideoInDevices, TRUE);
	    FreeDeviceList(&PlxDevInfo.VideoOutDevices, TRUE);
	    return FALSE;
	}
    }

    /*
     * Attach lists of DeviceElements to 
     * pInitVideoInfo->pDeviceInfo.DeviceElement.
     * Order is specified by protocol to be
     * first VideoIn, then VideoOut, then VideoDevices
     *
     * We are going to attach all devices to all screens.
     */
    nDevice = PlxDevInfo.VideoInDevices.nDevice + 
	      PlxDevInfo.VideoOutDevices.nDevice +
	      PlxDevInfo.VideoDevices.nDevice;

    pDeviceElement = (DeviceElement **)xalloc(nDevice*sizeof(DeviceElement *));
    if (pDeviceElement) {
	j = 0;
	for (i=0; i < PlxDevInfo.VideoInDevices.nDevice; i++)
	    pDeviceElement[j++] = PlxDevInfo.VideoInDevices.pDeviceElement[i];
	for (i=0; i < PlxDevInfo.VideoOutDevices.nDevice; i++)
	    pDeviceElement[j++] = PlxDevInfo.VideoOutDevices.pDeviceElement[i];
	for (i=0; i < PlxDevInfo.VideoDevices.nDevice; i++)
	    pDeviceElement[j++] = PlxDevInfo.VideoDevices.pDeviceElement[i];
	pDeviceInfo->devices.nDevice = nDevice;
	pDeviceInfo->devices.pDeviceElement = pDeviceElement;
    } else {
	return FALSE;
    }

    /*
     * For right now, we have one video device and it is always connected
     * to our single VideoIn.  Therefore, we have 1 adjacency matrix and 0
     * transitions.
     */
    nAdjacencyMatrices = 1;
    nRow = pInitVideoInfo->nVin + PlxDevInfo.VideoDevices.nDevice;
    nCol = pInitVideoInfo->nVout + PlxDevInfo.VideoDevices.nDevice;
    pDeviceInfo->connectivity.nAdjacencyMatrices = nAdjacencyMatrices;

    if (!(pDeviceInfo->connectivity.pAdjMat = (unsigned char *)
	  xalloc(nAdjacencyMatrices * 2 * nRow * nCol))) {
	FreeDeviceList(&PlxDevInfo.VideoInDevices, TRUE);
	FreeDeviceList(&PlxDevInfo.VideoOutDevices, TRUE);
	FreeDeviceList(&PlxDevInfo.VideoDevices, TRUE);
	return FALSE;
    }
    /*
     * XXX This is hardwired.
     * Set VideoDevice #1 connected to VideoIn #1
     * Set everything else to VEXNotConnected
     */
    pAdjMat = pDeviceInfo->connectivity.pAdjMat;
    for (i=0; i < 2 * nRow * nCol; i++)
	pAdjMat[i] = VEXNotConnected;
    if (pInitVideoInfo->nVin > 0 && PlxDevInfo.VideoDevices.nDevice > 0) {
	pCell = &pAdjMat[2 * nCol * PlxDevInfo.VideoDevices.nDevice];
	*pCell++ = VEXConnected;
	*pCell = VEXConnected;
    }

    PlxDevInfo.fInitialized = TRUE;
    return TRUE;
}

static void
FreeVideoScreenRec(pVideoScreenRec)
    VideoScreenRec *pVideoScreenRec;
{
    FreeDepths(pVideoScreenRec->nDepths, pVideoScreenRec->pDepths);
    xfree(pVideoScreenRec->pAllowedDepths);
    xfree(pVideoScreenRec->pVinModels);
    xfree(pVideoScreenRec->pVoutModels);
    FreeVideoOut(pVideoScreenRec);
    FreeDeviceList(&pVideoScreenRec->deviceInfo.devices, FALSE);
    FreeConnectivity(&pVideoScreenRec->deviceInfo.connectivity);

    xfree(pVideoScreenRec);
}

/*
 *	NAME
 *		FreeDeviceList - Free a list of DeviceList
 *
 *	SYNOPSIS
 */
static void
FreeDeviceList(pDeviceList, freeElements)
    DeviceList *pDeviceList;
    int freeElements;		/* if TRUE, delete each DeviceElement struct */
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		None
 *
 */
{
    int i;

    /*
     * We don't free pControl because it is static storage in this
     * implementation.
     */
    /*
     * We don't free devPrivate because it is static storage in this
     * implementation.
     *	if (pDeviceList->devPrivate)
     *	    xfree(pDeviceList->devPrivate);
     */
    if (freeElements) {
	for (i=0; i < pDeviceList->nDevice; i++) {
	    xfree(pDeviceList->pDeviceElement[i]);
	}
    }
    if (pDeviceList->nDevice > 0)
	xfree(pDeviceList->pDeviceElement);
    pDeviceList->nDevice = 0;
    pDeviceList->pDeviceElement = (DeviceElement **) NULL;
}

/*
 *	NAME
 *		FreeConnectivity - Free Connectivity structure
 *
 *	SYNOPSIS
 */
static void
FreeConnectivity(pConnectivity)
    ConnectivityInfo *pConnectivity;
/*
 *	DESCRIPTION
 *		<complete external description of the function>
 *
 *	RETURNS
 *		None
 *
 */
{
    xfree(pConnectivity->pAdjMat);
    if (pConnectivity->nTransitions)
	xfree(pConnectivity->pTransitions);
}

/*
 *	NAME
 *		plxInitVideoOut - Initialize VideoOutputs
 *
 *	SYNOPSIS
 */
static Bool
plxInitVideoOut(pScreen, pVideoInfo)
    ScreenPtr pScreen;
    VideoScreenRec *pVideoInfo;
/*
 *	DESCRIPTION
 *		This routine is really only useful if there are multiple
 *		VideoOutputs.  It Initializes each of them and receives
 *		OutputModel and OutputAttribute info from each VideoOutput
 *		and assembles the proper lists to return.  When nVout == 1,
 *		this is pretty easy.
 *
 *	RETURNS
 *		TRUE if memory allocation failure does not prevent us from
 *			doing what we want to do.
 *		FALSE otherwise.
 *
 */
{

    pVideoInfo->nVout = 0;
    pVideoInfo->pVoutModels = (unsigned char *) NULL;
    pVideoInfo->pOutattrs = (VideoGeometry *) NULL;

    /*
     * Let tekDVIInit allocate space and fill in the structures
     * We don't send down the pVideoInfo struct here because if we had
     * more than 1 VideoOut, this routine would be integrating multiple lists
     * produced by multiple device Initialization routines.
     */
#if defined( UTEK ) || defined( UTEKV )
    if(!tekDVIInit(pScreen, &pVideoInfo->nVout, &pVideoInfo->pVoutModels,
                &pVideoInfo->pOutattrs, pVideoInfo->nAllowedDepths,
                pVideoInfo->pAllowedDepths)) {
	return FALSE;
    }
#endif

    return TRUE;
}
FreeVideoOut(pVideoScreenRec)
    VideoScreenRec *pVideoScreenRec;
{
    tekDVIFree(pVideoScreenRec->pVoutModels, pVideoScreenRec->pOutattrs);
}

/*
 * Initialize  devices (controls) associated with VideoIN's
 */
/*ARGSUSED*/
Bool
plxVideoOutDeviceInit(pScreen, pDeviceList)
    ScreenPtr pScreen;
    DeviceList *pDeviceList;
{ 
    /*
     * We have no VideoIn controls
     */
    return TRUE;
}

/*
 * Initialize  devices (controls) associated with VideoOut's
 */
/*ARGSUSED*/
Bool
plxVideoInDeviceInit(pScreen, pDeviceList)
    ScreenPtr pScreen;
    DeviceList *pDeviceList;
{ 
    /*
     * We have no VideoOut controls
     */
    return TRUE;
}

#define NVIDEO_DEV	1
/*
 *	NAME
 *		plxVideoDeviceInit - Initialize devices and controls
 *
 *	SYNOPSIS
 */
Bool
plxVideoDeviceInit(pScreen, pDeviceList)
    ScreenPtr pScreen;
    DeviceList *pDeviceList;
/*
 *	DESCRIPTION
 *		Initialize Video devices and their controls.
 *
 *	RETURNS
 *		TRUE if initialization succeeds.
 *		False otherwise.
 *
 */
{
    DeviceElement *pVideoDevice;

    /*
     *  We have only one Video Device now:
     *  Pioneer LDV6000 Laser Disk player
     */

    pDeviceList->nDevice = 0;
    if (!(pDeviceList->pDeviceElement =
	    (DeviceElement **)xalloc(sizeof(DeviceElement *) * NVIDEO_DEV)))
	return FALSE;

    pVideoDevice = DeviceInitLDV6000(pScreen);
    if (pVideoDevice) {
	pDeviceList->nDevice++;
	pDeviceList->pDeviceElement[0] = pVideoDevice;
    } else {
	xfree(pDeviceList->pDeviceElement);
	return FALSE;
    }
    /*
     * Add more devices here:
     * pDeviceList->nDevice++;
     * pDeviceList->pDeviceElement[i] = pVideoDevice;
     * Call FreeDeviceList if failure.
     */

    return TRUE;
}

