/* $Header: plxrender.c,v 1.14 90/04/20 16:17:57 toddb Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "extnsionst.h"
#include "gcstruct.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "regionstr.h"

#include "VEX.h"
#include "VEXproto.h"
#include "videostr.h"

#include "Xplx.h"

/*
 * Funny place to put these.
 */
#define    VIDEO_MAX_WIDTH        640
#define    VIDEO_MAX_HEIGHT    482

/*
 * This routine take the (digested) arguments from a RenderVideo
 * request and attempts to produce a video picture in the specified
 * drawable.  If the hardware cannot do precisely what the request
 * asks for, then it should do something close, and generate a
 * VideoViolation event with state=Subset.  If it cannot do the
 * request at all, then the state=Fail.  The reason for failure
 * may be that the client is too stupid to do the right thing,
 * or that it is occluded by a window and cannot produce a clipped
 * picture.
 *
 * If the routine detects some request error not discernable by
 * dix, it should return False, else True.
 *
 * If the opaque member is set in the RENDERMODEL, then the server
 * should do its best to remember which pixels are video and which
 * are graphic.  Specifically, within the server, video pixels get
 * copied to a pixmap, and then back to a window, they should be
 * displayed as video pixels.
 */
Bool
plxRenderVideo(vp, render)
    VideoScreenPtr vp;
    VideoActionPtr render;
{
    BoxRec r;
    short xorg, yorg;
    DrawablePtr pDrawable = render->drawable;
    VideoDrawPtr	vDraw;
    plxPrivScrPtr	sp;
    int dstx, dsty, srcx, srcy, srcw, srch, dstw, dsth;
    CARD16 action;
    int state;
    RegionPtr prgnSrcClip;
    Bool freeSrcClip = FALSE;
    int ret;

    switch (pDrawable->type) {
    case DRAWABLE_WINDOW:
	xorg = pDrawable->x;
	yorg = pDrawable->y;
	break;
    case DRAWABLE_PIXMAP:
	if (!plxPixmapUse(PIXMAP_WRITE, pDrawable, &xorg, &yorg)) {
		ErrorF("plxVideo: PIXMAP NOT IN CACHE\n");
		return (Success);
	}
	yorg = PTY(yorg);
	break;
    }

    /*
     * deal with the board's video display size
     */
    srcx = render->srcX;
    srcy = render->srcY;
    dstx = render->dstX + xorg;
    dsty = render->dstY + yorg;
    srcw = render->srcWidth;
    srch = render->srcHeight;
    dstw = render->dstWidth;
    dsth = render->dstHeight;

    if (! ISROUND16(dstx)) {
        dstx = ROUNDUP16(dstx);
        srcw -= dstx - render->dstX; /* adjusted this to avoid scaling */
        dstw -= dstx - render->dstX;
    }
    if (! ISROUND16(dstw)) {
	int oldw = dstw;
	dstw = ROUNDDN16(dstw);
	srcw -= oldw - dstw; /* prevent scaling */
    }

    if ((srcx + srcw) > VIDEO_MAX_WIDTH) {
	dstw -= (srcx + srcw) - VIDEO_MAX_WIDTH; /* prevent scaling */
        srcw = ROUNDDN16(VIDEO_MAX_WIDTH - srcx);
    }
    if ((srcy + srch) > VIDEO_MAX_HEIGHT) {
	dsth -= (srcy + srch) - VIDEO_MAX_HEIGHT; /* prevent scaling */
        srch = VIDEO_MAX_HEIGHT - srcy;
    }

    /*
     * Generate a violation event.
     */
    state = -1;
    action = 0;
    if (srcx != render->srcX
     || srcy != render->srcY
     || dstx != render->dstX
     || dsty != render->dstY
     || srcw != render->srcWidth
     || srch != render->srcHeight
     || dstw != render->dstWidth
     || dsth != render->dstHeight) {
	action |= VEXClip;
	if (srcw == 0 || srch == 0 || dstw == 0 || dsth == 0)
	    state = VEXViolationFail;
	else
	    state = VEXViolationSubset;
    }
    /*
     * XXX We should try to do some scaling if the source
     * w and h don't match the destination w and h.  Punt for now.
     */
    if (srcw != dstw || srch != dsth) {
	state = VEXViolationFail;
	action |= VEXScale;
    }
    if (state >= 0) {
	SendVideoViolationEvent(pDrawable, render->videoIO, action, state);
	if (state == VEXViolationFail)
	    return (Success);
    }

    sp = plxGetScreenPriv(pDrawable->pScreen);
    if (sp->fullMotionVideo) {
	/* XXX should we die. */
	ErrorF("dix didn't stop other rendervideo in 0x%x\n", pDrawable->id);
    }
    sp->fullMotionVideo = render->drawable;
    render->vDraw->renderActive = MotionVideo;

    /* this region is used for the video clip */
    r.x1 = dstx;
    r.y1 = dsty;
    r.x2 = dstx + dstw;
    r.y2 = dsty + dsth;

    /*
     * for video operations, we adjust the clip before
     * setting it in the board.  The reason is that the clip
     * should be rounded to mod16
     */
    if (pDrawable->type == DRAWABLE_WINDOW) {
	if (render->subWindowMode == ClipByChildren)
	    prgnSrcClip = &((WindowPtr)pDrawable)->clipList;
	else {
	    prgnSrcClip = NotClippedByChildren((WindowPtr)pDrawable);
	    freeSrcClip = TRUE;
	}
	ret = plxVideoClipDownload(pDrawable->pScreen, prgnSrcClip, &r);
	if (freeSrcClip)
	    (*pDrawable->pScreen->RegionDestroy)(prgnSrcClip);
	if (!ret)
	    return (Success);
    } else {
	if (!plxVideoClipDownload(pDrawable->pScreen, NULL, &r))
	    return (Success);
    }

    plxMask(pDrawable, NULL);


    pl_cursor_active(0);
    p_flsp(sp->priority);

#ifdef wasThis
    /* clear overlay graphics plane */
    p_mask(0x01);
    CLIPREG(p_box(0, x, PTY(y), (x+w-1), PTY(y+h-1)));

    /* start live video in other planes */
    p_mask(0xfe);
#else
    p_mask(0xff);
#endif


#define Flash(op) \
	    CLIPREG(p_/**/op(srcx, 0x1e1 - srcy, dstx, \
		    PTY(dsty), (dstx+dstw-1), PTY(dsty+dsth-1)))

    px_flush();
    if (render->fullMotion) {
	switch (sp->framemode) {
	case 0:            /* frame capture */
	    switch (sp->framestart) {
	    case 0:        Flash(flc);  break; /* any field first */
	    case 1:        Flash(flec); break;/* even field first */
	    case 2:        Flash(floc); break;/* odd field first */
	    }
	    break;
	case 1:            /* field capture */
	    switch (sp->framestart) {
	    case 0:        Flash(flfc);  break; /* any field first */
	    case 1:        Flash(flfec); break;/* even field first */
	    case 2:        Flash(flfoc); break;/* odd field first */
	    }
	    break;
	}
	px_flush();
    } else {
	long junk;

	switch (sp->framemode) {
	case 0:            /* frame capture */
	    switch (sp->framestart) {
	    case 0:        Flash(fl);  break; /* any field first */
	    case 1:        Flash(fle); break;/* even field first */
	    case 2:        Flash(flo); break;/* odd field first */
	    }
	    break;
	case 1:            /* field capture */
	    switch (sp->framestart) {
	    case 0:        Flash(flf);  break; /* any field first */
	    case 1:        Flash(flfe); break;/* even field first */
	    case 2:        Flash(flfo); break;/* odd field first */
	    }
	    break;
	}
	/*
	 * Lock step... wait until the frame is rendered, because
	 * we may be about ready to shuttle to another frame and
	 * snap it too.  Parallax people say that reading a pixel
	 * from the frame buffer does the trick, because a single
	 * frame capture is just the same as a graphics operation:
	 * the graphics op just after the frame capture is not
	 * executed until after the frame capture is complete.  So...
	 */
	p_uimg(0,0,0,0, &junk);
    }

    p_mask(0xff);
    pl_cursor_active(1);

    return (Success);
}

/*
 * CopyWindow copies only the parts of the destination that are
 * visible in the source.
 */

static Bool
plxStopSubVideo(pWindow)
WindowPtr pWindow;
{
    WindowPtr		pChild;
    VideoScreenPtr	vp;
    VideoDrawPtr	vDraw;
    plxPrivScrPtr	sp;

    /*
     * This is actually easy for parallax, because we have only one
     * window ever active.
     */
    sp = plxGetScreenPriv(pWindow->drawable.pScreen);
    if (sp->fullMotionVideo == NULL)
	return (FALSE);
    if (sp->fullMotionVideo->type == DRAWABLE_PIXMAP)
	return (FALSE);

    pChild = (WindowPtr)sp->fullMotionVideo;
    while (pChild->parent != NullWindow) {
	if (pChild == pWindow) {
	    vp = ScreenVideoInfo[ pWindow->drawable.pScreen->myNum ];
	/* XXX Todd XXX,
	 * Do you want this to stop the other window permanently or temporarily?
	 * If permanent, call StopVideo (in dix) instead of *vp->StopVideo
	 */
	    (*vp->StopVideo)(vp, pChild, VEXStopRenderVideo);
	    return (TRUE);
	}
	pChild = pChild->parent;
    }
    return (FALSE);
}

static
plxClearOneVideo(pWindow, garbage)
WindowPtr pWindow;
char *garbage;
{
    register MapPrivPtr mp;

    mp = plxGetWindowPriv(pWindow);
    if (mp->videoFormat)
	(*pWindow->drawable.pScreen->ClearToBackground)(pWindow,
							0, 0, 0, 0, TRUE);
    return WT_WALKCHILDREN;
}

static
plxClearSubVideo(pWindow)
WindowPtr pWindow;
{
    TraverseTree(pWindow, plxClearOneVideo, (char *) 0);
}

/*
 * This routine do any preparation necessary for a ddx CopyWindow.
 * For example, the video digitization process may need to be shut down
 * for some child window.
 */

Bool
plxPreCopyWindow(pWindow, lastposition, pRegionSrc)
    WindowPtr pWindow;
    DDXPointRec lastposition;
    RegionPtr pRegionSrc;
{
    return (plxStopSubVideo(pWindow));
}

/*
 * This is the followup to xxxPreCopyWindow(): if it had shut down
 * the video digitization, this routine should start it up again.
 */

void
plxPostCopyWindow(pWindow, lastposition, pRegionSrc)
    WindowPtr pWindow;
    DDXPointRec lastposition;
    RegionPtr pRegionSrc;
{
    plxClearSubVideo(pWindow);
    /* plxStartSubVideo(pWindow); */
}
