/* $Header: query.c,v 1.12 90/04/10 12:21:40 scotthe Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "colormapst.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "extnsionst.h"
#include "gcstruct.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#include "regionstr.h"

#include "VEXproto.h"
#include "VEX.h"
#include "VEXcommon.h"
#include "videostr.h"

int
QueryVideo(pWin, client)
    WindowPtr pWin;
    register ClientPtr	client;
{
    xQueryVideoReply    rep;
    VideoScreenRec *pVideoInfo;	/* Video Info struct for screen*/
    int nBytesData;			/* Size of Reply data */
    int nBytesAllowedDepths;		/* Size of AllowedDepths data */
    int nBytesVinModels;		/* Size of Input Models data */
    int nBytesVoutModels;		/* Size of Output Models data */
    int nBytesClipSize;			/* Size of ClipSize data */
    int nBytesAdjMat;			/* Size of Adjacency Matrix data */
    int nBytesTransitions;		/* Size of Transitions data */
    int nBytesPlacement;		/* Size of Placements data */
    pointer preplyData;			/* Reply data */
    int i,j,k;
    int nattrList;			/* # of elements in Attributes list */
    unsigned long vid;			/* Visual ID */
    DepthPtr        pDepth;
    VisualPtr       pVisual;
    VideoGeometry   *pvg;
    DeviceElement *pDeviceElement;
    ControlElement *pControl;
    ConnectivityInfo *connectivity;
    int nDepths, nAllowedDepths, nVin, nVout, nVdev;
    union {
            xDepth *dp;
            xVisualType *vp;
            xVideoGeometry *vgp;
            xPlacement *pp;
	    xControl *cp;
            CARD8 *card8p;
            CARD32 *card32p;
    } u;


    rep.screen = pWin->drawable.pScreen->myNum;
    pVideoInfo = ScreenVideoInfo[rep.screen];
    connectivity = &pVideoInfo->deviceInfo.connectivity;
    if (!(*pVideoInfo->QueryVideo)
	    (pWin->drawable.pScreen, &pVideoInfo->deviceInfo))
	return BadAlloc;

    rep.type = X_Reply;
    rep.sequenceNumber = client->sequence;
    if (sizeof (xQueryVideoReply) > 32)
	rep.length = (sizeof (xQueryVideoReply) - 32) >> 2;
    else 
	rep.length = 0;
    rep.time = pVideoInfo->lastVideoChangeTime.milliseconds;


    rep.inputOverlap = pVideoInfo->inputOverlap;
    rep.captureOverlap = pVideoInfo->captureOverlap;
    rep.ioOverlap = pVideoInfo->ioOverlap;
    nDepths = rep.nDepths = pVideoInfo->nDepths;
    nAllowedDepths = rep.nAllowedDepths = pVideoInfo->nAllowedDepths;
    nVin = rep.nVin = pVideoInfo->nVin;
    nVout = rep.nVout = pVideoInfo->nVout;

    rep.nAdjacencyMatrices = connectivity->nAdjacencyMatrices;
    rep.nTransitions = connectivity->nTransitions;

    /*
     * Allocate temporary space to put the QueryVideo data into.
     */
    nBytesData = nDepths*sz_xDepth;
    for (i=0; i<nDepths; i++) {
	nBytesData += pVideoInfo->pDepths[i].numVids * sz_xVisualType;
    }
    nBytesAllowedDepths = nAllowedDepths*sz_xRenderModel;
    nBytesData += nBytesAllowedDepths;
    nBytesData += (nVin + nVout) * sz_xVideoGeometry;
    for (i=0; i<nVin; i++) {
	nBytesData += pVideoInfo->pInattrs[i].xvg.nPlacement *
		sz_xPlacement;
    }
    for (i=0; i<nVout; i++) {
	nBytesData += pVideoInfo->pOutattrs[i].xvg.nPlacement * 
		sz_xPlacement;
    }
    nBytesVinModels = nVin * nAllowedDepths;
    nBytesData += (nBytesVinModels +3) & ~0x3;
    nBytesVoutModels = nVout * nAllowedDepths;
    nBytesData += (nBytesVoutModels +3) & ~0x3;

    /*
     * Traverse the list of DeviceElements to determine how many online video
     * devices there are and how many controls and how much space the controls
     * take.
     */
    /* XXX
     * Note, we could gain some efficiency by figuring out at initialization
     * time how many VideoIn and VideoOut devices controls we have and how
     * much space these take.  (VideoIn and VideoOut devices do not go offline)
     */
    nVdev = 0;
    rep.nDeviceControls = 0;
    for (i=0; i < pVideoInfo->deviceInfo.devices.nDevice; i++) {
	pDeviceElement = pVideoInfo->deviceInfo.devices.pDeviceElement[i];
	if (pDeviceElement->onLine) {
	    if (pDeviceElement->type == Device)
		nVdev++;
	    rep.nDeviceControls += pDeviceElement->nControl;
	    for (i=0; i<pDeviceElement->nControl; i++)
		nBytesData += 
		  (pDeviceElement->pControl[i].xc.descriptionLength +3) & ~0x3;
	}
    }
    rep.nVdev = nVdev;
    nBytesData += nVdev << 2;
    nBytesData += rep.nDeviceControls * sz_xControl;

    nBytesClipSize = nVin * sz_xRectangle;
    nBytesData += nBytesClipSize;
    nBytesAdjMat = 2* rep.nAdjacencyMatrices * (nVdev + nVin) * (nVdev + nVout);
    nBytesData += (nBytesAdjMat +3) & ~0x3;
    nBytesTransitions = rep.nTransitions * sz_xVideoTransition;
    nBytesData += nBytesTransitions;

    if (!(preplyData = (pointer)ALLOCATE_LOCAL(nBytesData)))
	return(BadAlloc);

    u.dp = (xDepth *)preplyData;
    pDepth = pVideoInfo->pDepths;
    for (i = 0; i < nDepths; i++, pDepth++) {
	u.dp->depth = pDepth->depth;
	u.dp->nVisuals = pDepth->numVids;
	u.dp++;
	for (j = 0; j < pDepth->numVids; j++) {
	    vid = pDepth->vids[j];
	    /*
	     * We know this is a vex visual (otherwise we wouldn't be sending
	     * it!)
	     */
	    for (pVisual = pVideoInfo->visuals;
		 pVisual->vid != vid;
		 pVisual++)
		;
	    assert(pVisual->vid == vid);
	    u.vp->visualID = pVisual->vid;
	    u.vp->class = pVisual->class;
	    u.vp->bitsPerRGB = pVisual->bitsPerRGBValue;
	    u.vp->colormapEntries = pVisual->ColormapEntries;
	    u.vp->redMask = pVisual->redMask;
	    u.vp->greenMask = pVisual->greenMask;
	    u.vp->blueMask = pVisual->blueMask;
	    u.vp++;
	}
    }
    bcopy((char *)pVideoInfo->pAllowedDepths,u.card8p, nBytesAllowedDepths);
    u.card8p += nBytesAllowedDepths;

    for (i=0; i < pVideoInfo->deviceInfo.devices.nDevice; i++) {
	pDeviceElement = pVideoInfo->deviceInfo.devices.pDeviceElement[i];
	if (pDeviceElement->onLine && pDeviceElement->type == Device) {
	    *u.card32p++ = pDeviceElement->id;
	}
    }

    for (k=0; k<2; k++) {
        if (k==0) {
	    pvg = pVideoInfo->pInattrs;
            nattrList = nVin;
        } else {
	    pvg = pVideoInfo->pOutattrs;
            nattrList = nVout;
	}
	for (i=0; i<nattrList; i++, pvg++) {
	    bcopy((char *)&pvg->xvg, u.card8p, sz_xVideoGeometry);
	    u.vgp++;
	    nBytesPlacement = pvg->xvg.nPlacement * sz_xPlacement;
	    bcopy((char *)pvg->pPlacements, u.card8p, nBytesPlacement);
	    u.card8p += nBytesPlacement;
	}
    }

    bcopy((char *)pVideoInfo->pVinModels, u.card8p, nBytesVinModels);
    u.card8p += (nBytesVinModels +3) & ~0x3;
    bcopy((char *)pVideoInfo->pVoutModels, u.card8p, nBytesVoutModels);
    u.card8p += (nBytesVoutModels +3) & ~0x3;

    for (i=0; i < pVideoInfo->deviceInfo.devices.nDevice; i++) {
	pDeviceElement = pVideoInfo->deviceInfo.devices.pDeviceElement[i];
	if (pDeviceElement->onLine) {
	    for (j=0; j<pDeviceElement->nControl; j++) {
		pControl = &pDeviceElement->pControl[j];
		bcopy((char *) (&pControl->xc), u.card8p, sz_xControl);
		u.cp++;
		bcopy(pControl->pValues,u.card8p,pControl->xc.descriptionLength);
		u.card8p += (pControl->xc.descriptionLength + 3) & ~0x3;
	    }
	}
    }

    bcopy((char *)pVideoInfo->pClipSize, u.card8p, nBytesClipSize);
    u.card8p += nBytesClipSize;
    bcopy((char *)connectivity->pAdjMat,
	    u.card8p, nBytesAdjMat);
    u.card8p += (nBytesAdjMat +3) & ~0x3;
    bcopy((char *)connectivity->pTransitions,
	    u.card8p, nBytesTransitions);
    u.card8p += nBytesTransitions;

    rep.length += nBytesData >> 2;
    if (client->swapped) {
        SQueryVideoReply(client, nBytesData, &rep, preplyData);
    } else {
	(void) WriteToClient(client, sizeof (xQueryVideoReply), (char *)&rep);
	(void) WriteToClient(client, nBytesData, (char *)preplyData);
    }

    DEALLOCATE_LOCAL(preplyData);
    (*pVideoInfo->FreeDeviceInfo)(pVideoInfo->deviceInfo);

    return 0;
}


/*
 *	NAME
 *		SetDeviceStatus - Set a device's status on or offline
 *
 *	SYNOPSIS
 */
void
SetDeviceStatus(vid, onLine, generateEvent)
    VideoID vid;		/* Set status of this video device */
    Bool onLine;		/* TRUE or FALSE */
    Bool generateEvent;		/* TRUE if this routine should generate a
				 * VideoChange event */
/*
 *	DESCRIPTION
 *		This routine should be called by ddx when a device's status
 *		changes.
 *
 *		Set a device's status on or offline.  If the requested status
 *		does not differ from the current state, or if "vid" is not a
 *		valid Device VideoId for the given screen, this routine has
 *		no effect.
 *		If "generateEvent" is TRUE, this routine will send a VideoChange
 *		event to all appropriate clients.
 *		
 *
 *	RETURNS
 *		None
 *
 */
{
    VideoResourcePtr vRes;
    unsigned long time;
    int state;
    screenIndexRec *screen;
    VideoScreenPtr pVidInfo;

    if ((vRes = (VideoResourcePtr) LookupIDByType(vid,
			ScreenVideoInfo[0]->vIdType))) {
	assert(vRes->pElement);
	if (vRes->pElement->onLine != onLine) {
	    vRes->pElement->onLine = onLine;
	    time = currentTime.milliseconds;
	    state = onLine ? VEXOnline : VEXOffline;
	    /*
	     * Generate an event for each screen on which this device
	     * is listed and update VideoChange time for each screen.
	     */
	    for (screen = vRes->screens; screen; screen = screen->next) {
		pVidInfo = ScreenVideoInfo[screen->pScreen->myNum];
		pVidInfo->lastVideoChangeTime = currentTime;
		if (generateEvent) {
		    SendVideoChangeEvent(screen->pScreen, vid, state, time);
		 }
	    }
	}
    }
}

/* XXX Stash
    rep.defaultBlendmap = pVideoInfo->defBlendmap;;
    rep.minInstalledMaps = pVideoInfo->minInstalledMaps;
    rep.maxInstalledMaps = pVideoInfo->maxInstalledMaps;
*/
