/* $Header: vexevents.c,v 1.12 90/04/19 11:56:52 scotthe Exp $ */
/************************************************************
Copyright 1989 by Tektronix Inc.
Copyright 1989 by The Massachusetts Institute of Technology

                    All Rights Reserved

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the names of MIT and Tektronix not be
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
M.I.T. and Tektronix make no representation about the 
suitability of this software for any purpose. It is provided 
"as is" without any express or implied warranty.

MIT AND TEKTRONIX DISCLAIM ALL WARRANTIES WITH REGARD TO  THIS  
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIT OR
TEKTRONIX BE LIABLE FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA  OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#define NEED_REPLIES
#define NEED_EVENTS
#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "misc.h"
#include "os.h"
#include "windowstr.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "colormapst.h"
#include "extnsionst.h"
#include "dixstruct.h"
#include "resource.h"
#include "opaque.h"
#define _VEX_SERVER_	/* don't want Xlib structures */ /* XXX */
#include "regionstr.h"
#include "gcstruct.h"

#include "VEX.h"
#include "VEXproto.h"
#include "VEXcommon.h"
#include "videostr.h"

static int VideoFreeClient(), VideoFreeEvents();
static void SendVideoNotify();

static RESTYPE ClientType, EventType; /* resource types for event masks */
static int VideoEventBase = 0;

/*
 * each resource has a list of clients requesting
 * VEX events.  Each client has a resource
 * for each resource it selects VEX events for:
 * this resource is used to delete the VideoNotifyRec
 * entry from the per-resource queue.
 */

typedef struct _VideoEvent *VideoEventPtr;

typedef struct _VideoEvent {
    VideoEventPtr   next;
    ClientPtr	    client;
    XID		    resourceID;
    XID		    clientResource;
    unsigned long   events;
} VideoEventRec;


int
InitVideoEvents(extEntry)
    ExtensionEntry *extEntry;
{
    VideoEventBase = extEntry->eventBase;
    ClientType = CreateNewResourceType(VideoFreeClient);
    EventType = CreateNewResourceType(VideoFreeEvents);
    EventSwapVector[VideoEventBase + VEXControl] = SVideoControlEvent;
    EventSwapVector[VideoEventBase + VEXViolation] = SVideoViolationEvent;
    EventSwapVector[VideoEventBase + VEXSync] = SVideoSyncEvent;
    EventSwapVector[VideoEventBase + VEXOverride] = SVideoOverrideEvent;
    EventSwapVector[VideoEventBase + VEXChange] = SVideoChangeEvent;
#ifdef IMPLEMENTED
    EventSwapVector[VideoEventBase + VEXConnectivity] = 
	    SVideoConnectivityStateEvent;
#endif /* IMPLEMENTED */
    EventSwapVector[VideoEventBase + VEXRequest] = SVideoRequestEvent;
    EventSwapVector[VideoEventBase + VEXRequestAddendum]
	= SVideoRequestAddendumEvent;

    if (!ClientType || !EventType)
	return FALSE;
    else
	return TRUE;
}

/*
 * Called when a client dies.  This routine frees "data" (a VideoEvent struct
 * in the event list for the resource "id").
 */
/*ARGSUSED*/
static int
VideoFreeClient (data, id)
    pointer	    data;
    XID		    id;
{
    VideoEventPtr   pVideoEvent;
    VideoEventPtr   *pHead, pCur, pPrev;

    pVideoEvent = (VideoEventPtr) data;
    pHead = (VideoEventPtr *)LookupIDByType(pVideoEvent->resourceID, EventType);
    if (pHead) {
	pPrev = 0;
	for (pCur = *pHead; pCur && pCur != pVideoEvent; pCur=pCur->next)
	    pPrev = pCur;
	if (pPrev)
	    pPrev->next = pVideoEvent->next;
	else
	    *pHead = pVideoEvent->next;
    }
    xfree ((pointer) pVideoEvent);
}

/*
 * Called when resource, "id", goes away.  This routine frees each of the
 * VideoEvent structures which are attached to "id".
 */
/*ARGSUSED*/
static int
VideoFreeEvents (data, id)
    pointer	    data;
    XID		    id;
{
    VideoEventPtr   *pHead, pCur, pNext;

    pHead = (VideoEventPtr *) data;
    for (pCur = *pHead; pCur; pCur = pNext) {
	pNext = pCur->next;
	FreeResource (pCur->clientResource, ClientType);
	xfree ((pointer) pCur);
    }
    xfree ((pointer) pHead);
}

#define SCREEN_EVENTS	(VEXRedirectMask|VEXConnectivityMask)
#define DRAWABLE_EVENTS	(SCREEN_EVENTS|VEXOverrideMask|VEXViolationMask)
#define VID_EVENTS	(VEXSyncMask|VEXControlMask)
int
VideoSelectInput (id, client, events)
    XID		    	id;
    ClientPtr		client;
    unsigned long  	events;
{
    DrawablePtr			pDraw;
    VideoResourcePtr		vRes;
    int				ret;
    XID				screenID;

    /*
     * There are 7 Event types.  Each has its own idiosyncracies.
     * VEXRedirectMask:
     *		id is a drawable.  
     *		It selects a screen to receive VideoRequest events from.
     *		Only 1 client may select this event at a time, 
     *		else Access Error
     * VEXConnectivityMask:
     *		id is a drawable.
     *		It selects a screen to receive events from.
     * VEXSyncMask:
     *		id is a VideoIO.
     * VEXControlMask:
     *		id is a VideoID.
     * VEXOverrideMask:
     *		id is a drawable.
     * VEXViolationMask:
     *		id is a drawable.
     * ChangeNotify:
     *		id is a Screen.  (This event is not selectable through the
     *		protocol request, SelectVideoEvents.  It is selected implicitly
     *		through the protocol request, QueryVideo.
     */

    if (events & ~AllVEXEventMask ||
	((events & DRAWABLE_EVENTS) && (events & VID_EVENTS))) {
	client->errorValue = events;
	return BadValue;
    }
    /*
     * First determine the type of the id.  Unfortunately, we can only do
     * this by doing a Lookup on each of the possible types.
     */
    if ( pDraw = (DrawablePtr) LookupDrawable(id, client)) {
	if (events & VID_EVENTS) {
	    client->errorValue = id;
	    return BAD_VIDEO;
	}
	screenID = ScreenVideoInfo[pDraw->pScreen->myNum]->id;
	/*
	 * SelectEvents for VEXRedirectMask and VEXConnectivityMask using 
	 * screen ID, later SelectEvents for other events (e.g. Override).
	 */
	ret = SelectEvents (screenID, client, (events & SCREEN_EVENTS));
	if (ret != Success)
	    return ret;
    }
    else if ( vRes = (VideoResourcePtr) 
		LookupIDByType(id, ScreenVideoInfo[0]->vIdType)){
	if (events & DRAWABLE_EVENTS) {
		client->errorValue = id;
		return BadDrawable;
	}
	if (((events & VEXSyncMask) && vRes->type == Device)) {
	    client->errorValue = id;
	    return BAD_VIDEO;
	}
    } else {
	client->errorValue = id;
	if (events & DRAWABLE_EVENTS)
	    return BadDrawable;
	else
	    return BAD_VIDEO;
    }

    ret = SelectEvents (id, client, (events & ~SCREEN_EVENTS));
    return ret;
} 

int
SelectEvents (id, client, events)
    XID		    	id;
    ClientPtr		client;
    unsigned long  	events;
{
    VideoEventPtr		pVideoEvent, pNewVideoEvent, *pHead;
    XID				clientResource;
    unsigned long  	eventMask;

    assert (! (ChangeNotify & AllVEXEventMask));
    assert( !(events & AllVEXEventMask) || !(events & ChangeNotify));

    if (events & ChangeNotify)
	eventMask = ChangeNotify;
    else
	eventMask = AllVEXEventMask;
    /*
     * There is a list of VideoEvents for each id.  There is one entry for
     * each client that has selected events for this id.
     */

    pHead = (VideoEventPtr *) LookupIDByType(id, EventType);
    /*
     * If this client is trying to set VEXRedirectMask, see if another
     * client has already selected this.  If it has, report Access error.
     */
    if ((events & VEXRedirectMask) && pHead) {
	for (pVideoEvent = *pHead; pVideoEvent; pVideoEvent = pVideoEvent->next)
	{
	    if ((pVideoEvent->events & VEXRedirectMask) && 
		    (pVideoEvent->client != client)) {
		client->errorValue = id;
		return BadAccess;
	    }
	}
    }

    if (pHead) {

	/* check for existing entry. */
	pNewVideoEvent = 0;
	for (pVideoEvent = *pHead; pVideoEvent; pVideoEvent = pVideoEvent->next)
	{
	    if (pVideoEvent->client == client) {
		pVideoEvent->events = 
		      (pVideoEvent->events & ~eventMask) | (events & eventMask);
		/*
		 * If there are no longer any events selected, we can delete
		 * this entry
		 */
		if (!pVideoEvent->events) {
		    FreeResource (pVideoEvent->clientResource, EventType);
		    if (pNewVideoEvent)
			pNewVideoEvent->next = pVideoEvent->next;
		    else
			*pHead = pVideoEvent->next;
		    xfree (pVideoEvent);
		}
		return Success;
	    } else
		pNewVideoEvent = pVideoEvent;
	}
    }

    /*
     * If there was no existing event structure and events == 0, just
     * return now.
     */
    if (!events)
	return Success;

    /* build the entry */
    pNewVideoEvent = (VideoEventPtr)
			xalloc (sizeof (VideoEventRec));
    if (!pNewVideoEvent)
	return BadAlloc;
    pNewVideoEvent->next = 0;
    pNewVideoEvent->client = client;
    pNewVideoEvent->resourceID = id;
    pNewVideoEvent->events = (events & eventMask);
    /*
     * add a resource that will be deleted when
     * the client goes away
     */
    clientResource = FakeClientID (client->index);
    pNewVideoEvent->clientResource = clientResource;
    if (!AddResource (clientResource, ClientType, (pointer)pNewVideoEvent))
    {
	xfree (pNewVideoEvent);
	return BadAlloc;
    }
    /*
     * create a resource to contain a pointer to the list
     * of clients selecting input.  This must be indirect as
     * the list may be arbitrarily rearranged which cannot be
     * done through the resource database.
     */
    if (!pHead)
    {
	pHead = (VideoEventPtr *) xalloc (sizeof (VideoEventPtr));
	if (!pHead ||
	    !AddResource (id, EventType, (pointer)pHead))
	{
	    FreeResource (clientResource, ClientType);
	    xfree (pHead);
	    xfree (pNewVideoEvent);
	    return BadAlloc;
	}
	*pHead = 0;
    }
    pNewVideoEvent->next = *pHead;
    *pHead = pNewVideoEvent;

    return Success;
}

/*
 * deliver an event.  type can be any VEX event.
 * XXX sequence number accuracy???
 */

static void
SendVideoNotify (id, pevent, type)
    XID		    	id;		/* Resource ID to report event on */
    xEvent		*pevent;	/* event to send */
    int			type;		/* event type */
{
    VideoEventPtr	*pHead, pVideoEvent;
    ClientPtr		client;
    unsigned long	mask;
    int			count = 1; /* mostly, just one event */

    pHead = (VideoEventPtr *) LookupIDByType(id, EventType);
    if (!pHead)
	return;
    pevent->u.u.type = type + VideoEventBase;

    switch (type) {
	case VEXConnectivity:
	    mask = VEXConnectivityMask;
	    break;
	case VEXRequest:
	    count = 2;
	    mask = VEXRedirectMask;
	    break;
	case VEXSync:
	    mask = VEXSyncMask;
	    break;
	case VEXControl:
	    mask = VEXControlMask;
	    break;
	case VEXChange:
	    mask = ChangeNotify;
	    break;
	case VEXOverride:
	    mask = VEXOverrideMask;
	    break;
	case VEXViolation:
	    mask = VEXViolationMask;
	    break;
	default:
	    assert(FALSE);
    };
    for (pVideoEvent = *pHead; pVideoEvent; pVideoEvent = pVideoEvent->next) {
	client = pVideoEvent->client;
	if (client != serverClient && !client->clientGone && 
		(pVideoEvent->events & mask)) {
	    pevent->u.u.sequenceNumber = client->sequence;
	    WriteEventsToClient (client, count, pevent);
	}
    }
}

void
SendVideoViolationEvent(pDraw, vid, actionMask, state)
    DrawablePtr	pDraw;		/* Drawable on which to report the event */
    VideoIO	vid;		/* VideoIO whose constraints were violated */
    unsigned long actionMask;	/* VEXScale|VEXPlacement|VEXClip|VEXOverlap */
    int		state;		/* VEXViolationSuccess, VEXViolationFail,
				 * or VEXViolationSubset */
{
    xVideoViolationEvent event;

    event.id = pDraw->id;
    event.vid = vid;
    event.time = currentTime.milliseconds;
    event.actionMask = actionMask;
    event.state = state;

    SendVideoNotify(pDraw->id, (xEvent *) &event, VEXViolation);
}

void
SendVideoRequestEvent(request, pVideoAction, redirect)
    int			request;
    VideoActionPtr	pVideoAction;
    int			redirect;
{
    struct {
	xVideoRequestEvent event;
	xVideoRequestAddendumEvent eventAdd;
    } s;

    s.event.cmap = None;
    if (request == VEXRender) {
	s.event.src = pVideoAction->videoIO;
	s.event.dst = pVideoAction->drawable->id;
    } else {
	s.event.dst = pVideoAction->videoIO;
	s.event.src = pVideoAction->drawable->id;
	if (pVideoAction->pcmap)
	    s.event.cmap = pVideoAction->pcmap->mid;
    }
    s.event.srcx = pVideoAction->srcX;
    s.event.srcy = pVideoAction->srcY;
    s.event.dstx = pVideoAction->dstX;
    s.event.dsty = pVideoAction->dstY;
    s.event.srcWidth = pVideoAction->srcWidth;
    s.event.srcHeight = pVideoAction->srcHeight;
    s.event.dstWidth = pVideoAction->dstWidth;
    s.event.dstHeight = pVideoAction->dstHeight;

    s.eventAdd.type = VEXRequestAddendum;
    s.eventAdd.time = currentTime.milliseconds;
    s.eventAdd.request = request;
    s.eventAdd.redirect = redirect;
    s.eventAdd.fullMotion = pVideoAction->fullMotion;
    s.eventAdd.priority = pVideoAction->priority;
    s.eventAdd.subwindowMode = pVideoAction->subWindowMode;

    SendVideoNotify(ScreenVideoInfo[pVideoAction->drawable->pScreen->myNum]->id,
	    (xEvent *) &s, VEXRequest);
}

void
SendVideoSyncEvent(vid, state)
    VideoIO	vid;
    int		state;
{
    xVideoSyncEvent event;

    event.vid = vid;
    event.state = state;
    event.time = currentTime.milliseconds;
    SendVideoNotify (vid, (xEvent *) &event, VEXSync);
}

void
SendVideoControlEvent(vid, name, state)
    VideoID	vid;	/* ID of device which owns control */
    Atom	name;	/* Name of control */
    int		state;	/* VEXControlSuccess, VEXControlFail,
			 * or VEXControlDenied */
{
    xVideoControlEvent event;

    event.vid = vid;
    event.name = name;
    event.state = state;
    event.time = currentTime.milliseconds;
    SendVideoNotify (vid, (xEvent *) &event, VEXControl);
}


void
SendVideoOverrideEvent(pDraw, vid)
    DrawablePtr	pDraw;
    VideoIO	vid;
{
    xVideoOverrideEvent event;

    event.id = pDraw->id;
    event.vid = vid;
    event.time = currentTime.milliseconds;
    SendVideoNotify (pDraw->id, (xEvent *) &event, VEXOverride);
}

void
SendVideoChangeEvent(pScreen, vid, state, time)
    ScreenPtr	pScreen;
    VideoID	vid;
    int		state;		/* OnLine or OffLine */
    unsigned long time;
{
    xVideoChangeEvent event;

    event.screen = pScreen->myNum;
    event.vdev = vid;
    event.state = state;
    event.time = time;
    SendVideoNotify (ScreenVideoInfo[pScreen->myNum]->id, 
	    (xEvent *) &event, VEXChange);
}
