/* $Header: plxBstore.c,v 3.2 90/03/06 16:30:45 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxBstore.c	1.2 09/06/88 Parallax Graphics Inc";
#endif

#include	"Xplx.h"

static WindowPtr saveWin;
static WindowPtr restoreWin;

/*
 * simple wrapper to save the associated window
 */
void
plxPreSaveDoomedAreas(pWin, pObscured, dx, dy)
    register WindowPtr pWin;
    RegionPtr          pObscured;
    int                dx, dy;
{
    plxPrivScrPtr	pScreenPriv;
    ScreenPtr           pScreen;

    /* set aside for plxSaveDoomedAreas */
    saveWin = pWin;

    pScreen = pWin->drawable.pScreen;
    pScreenPriv = plxGetScreenPriv(((DrawablePtr)pWin)->pScreen);

    pScreen->SaveDoomedAreas = pScreenPriv->SaveDoomedAreas;
    (*pScreenPriv->SaveDoomedAreas)(pWin, pObscured, dx, dy);
    pScreen->SaveDoomedAreas = plxPreSaveDoomedAreas;
}

/*
 * simple wrapper to save the associated window
 */
RegionPtr
plxPreRestoreAreas(pWin, prgnExposed)
    register WindowPtr pWin;
    RegionPtr prgnExposed;
{
    plxPrivScrPtr	pScreenPriv;
    ScreenPtr           pScreen;
    RegionPtr		exposures;

    /* set aside for plxRestoreAreas */
    restoreWin = pWin;

    pScreen = pWin->drawable.pScreen;
    pScreenPriv = plxGetScreenPriv(pScreen);

    pScreen->RestoreAreas = pScreenPriv->RestoreAreas;
    exposures = (*pScreenPriv->RestoreAreas)(pWin, prgnExposed);
    pScreen->RestoreAreas = plxPreRestoreAreas;

    return (exposures);
}

void
plxSaveAreas(pPixmap, pRegion, xorg, yorg)
PixmapPtr pPixmap;
RegionPtr pRegion;	/* pixmap relative coordinates */
int xorg, yorg;		/* window offset */
{
    short pixx, pixy;
    int i;
    BoxPtr pBox;
    register MapPrivPtr mp;

    if (!plxPixmapUse(PIXMAP_WRITE, pPixmap, &pixx, &pixy)) {
	ErrorF("plxCopyArea: DST PIXMAP NOT IN CACHE\n");
	return;
    }
    pixy = PTY(pixy);
    p_mask(0xffff);
    p_clipd();

    mp = plxGetWindowPriv(saveWin);
#ifdef VIDEOX
    if (mp->videoFormat)
	p_damvv();
    else
#endif /* VIDEOX */
	p_damvg();

    /*
     * XXX When a window contains video bits, we really should be
     * saving the video bits with damvv and the graphic bits
     * with damvg.  But this is a hold-over from the parallax
     * extension.
     */
    pBox=REGION_RECTS(pRegion);
    for (i=0; i<REGION_NUM_RECTS(pRegion); i++) {
	p_boxc(
		pBox->x1 + xorg, PTY(pBox->y1 + yorg),
		pBox->x1 + pixx, PTY(pBox->y1 + pixy),
		pBox->x2 + pixx - 1, PTY(pBox->y2 + pixy - 1));
	pBox++;
    }

    p_clipe();
    p_damvx();
}

void
plxRestoreAreas(pPixmap, pRegion, xorg, yorg)
PixmapPtr pPixmap;
RegionPtr pRegion;	/* screen relative coordinates */
int xorg, yorg;		/* window offset */
{
    short pixx, pixy;
    int i;
    BoxPtr pBox;
    register MapPrivPtr mp;

    if (!plxPixmapUse(PIXMAP_READ, pPixmap, &pixx, &pixy)) {
	ErrorF("plxCopyArea: DST PIXMAP NOT IN CACHE\n");
	return;
    }
    pixy = PTY(pixy);
    p_mask(0xffff);
    p_clipd();
    mp = plxGetWindowPriv(restoreWin);
#ifdef VIDEOX
    if (mp->videoFormat)
	p_damvv();
    else
#endif /* VIDEOX */
	p_damvg();

    /*
     * XXX When a pixmap contains video bits, that have to be restored
     * to a window, we really should be
     * restoring the video bits with damvv and the graphic bits
     * with damvg.  But this is a hold-over from the parallax
     * extension.
     */
    pBox=REGION_RECTS(pRegion);
    for (i=0; i<REGION_NUM_RECTS(pRegion); i++) {
	p_boxc(
		pBox->x1 - xorg + pixx, PTY(pBox->y1 - yorg + pixy),
		pBox->x1, PTY(pBox->y1),
		pBox->x2 - 1, PTY(pBox->y2 - 1));
	pBox++;
    }

    p_clipe();
    p_damvx();
}
