/* $Header: plxPaint.c,v 3.2 90/03/06 16:31:11 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxPaint.c    1.21 08/05/88 Parallax Graphics Inc";
#endif

#include    "Xplx.h"

/*
 * CLIPPING:
 * we could set clip to the rectangle list, in these routines, and
 * fill the entire window.
 * But it is probably easier and quicker to just do the fills.
 */

extern VoidFunc plxPainters[];

void
plxPaintWindow(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    register MapPrivPtr mp;

    mp = plxGetWindowPriv(pWin);
    (*plxPainters[ mp->backgroundPainter ])(pWin, pRegion, what);
}

void
plxPaintBorder(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    register MapPrivPtr mp;

    mp = plxGetWindowPriv(pWin);
    (*plxPainters[ mp->borderPainter ])(pWin, pRegion, what);
}

void
plxPaintAreaSolid(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    register int nbox;        /* number of boxes to fill */
    register BoxPtr pbox;        /* pointer to list of boxes to fill */
    int pix;            /* pixel value to draw */
    register MapPrivPtr mp;

    ifdebug(16) printf("plxPaintAreaSolid(), what=%d\n", what);

    mp = plxGetWindowPriv(pWin);
    /* XXX */ plxMask(pWin, 0);

#ifdef VIDEOX
    /*
     * This is something that should be done by vex.
     */
    if (!mp->videoFormat)
        p_damvg();
    else
#endif /* VIDEOX */
        p_damvv();

    switch (what) {
    case PW_BACKGROUND:
        pix = pWin->background.pixel;
        break;
    case PW_BORDER:
        pix = pWin->border.pixel;
        break;
    }

    p_rmap(0);
    p_opaq(0);

    p_clipd();            /* REMEMBER TO TURN ON AGAIN */

    nbox = REGION_NUM_RECTS(pRegion);
    pbox = REGION_RECTS(pRegion);
    while (nbox--) {
        ifdebug(16) printf("\tpix,x1,y1,x2,y2=%d,%d,%d,%d,%d\n",
			   pix, pbox->x1, pbox->y1, pbox->x2-1, pbox->y2-1);
        p_box(pix, pbox->x1, PTY(pbox->y1), pbox->x2-1, PTY(pbox->y2-1));
        pbox++;
    }
    p_clipe();            /* WE REMEMBERED */
    p_damvx();
}

void plxSlowStipple(pWin, xt, yt, w, h, x1, y1, x2, y2)
WindowPtr pWin;
{
    int xorg, yorg;
    register int x, y;

    ifdebug(16) {
	printf("plxslowstipple(), xt,yt=%d,%d w,h=%d,%d ", xt, yt, w, h);
	printf("\tx1,y1,x2,y2=%d,%d,%d,%d\n", x1, y1, x2, y2);
    }

    p_clip(x1, PTY(y1), x2, PTY(y2));

    if (pWin->drawable.x <= x1)
        xorg = x1 - (x1 - pWin->drawable.x) % w;
    else
        xorg = x1 + (pWin->drawable.x - x1) % w + w;
    if (pWin->drawable.y <= y1)
        yorg = y1 - (y1 - pWin->drawable.y) % h;
    else
        yorg = y1 + (pWin->drawable.y - y1) % h + h;

    for (x=xorg;x<=x2;x += w) {
        for (y=yorg;y<=y2;y += h) {
            p_boxc(xt, yt,
                x, PTY(y),
                (((x+w-1)>x2)?x2:x+w-1), PTY(((y+h-1)>y2)?y2:y+h-1));
        }
    }
}

/*
 * plxPaintArea()
 * -- is a composite of PaintWindowBackground and PaintWindowBorder.
 * "what" is either the constant PW_BACKGROUND or PW_BORDER saying
 * which of the window's border or fill style to use.
 *    Each fill style is a tile pointer and a pixel value.
 * If the tile pointer is NULL, that means that the background is the
 * solid pixel value. In which case this routine shouldn't have been called.
 */

void
plxPaintArea(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    register int nbox;        /* number of boxes to fill */
    register BoxPtr pbox;        /* pointer to list of boxes to fill */
    short xt, yt;
    PixmapPtr pPixmap = (PixmapPtr)0;
    register MapPrivPtr mp;

    ifdebug(16) printf("plxPaintArea(), what=%d\n", what);

    switch (what) {
    case PW_BACKGROUND:
        pPixmap = pWin->background.pixmap;
        break;
    case PW_BORDER:
        pPixmap = pWin->border.pixmap;
        break;
    }

    if (!plxPreparePattern(pPixmap, &xt, &yt)) {
        ErrorF("plxPaintArea: TILE NOT IN CACHE\n");
        return;
    }

    /* XXX */ plxMask(pWin, 0);
    mp = plxGetWindowPriv(pWin);

#ifdef VIDEOX
    /*
     * This is something that should be done by vex.
     */
    if (!mp->videoFormat)
        p_damvg();
    else
#endif /* VIDEOX */
        p_damvv();

    p_rmap(0);
    p_opaq(0);

    /* do this because of slow stipple */
    plxClipInvalidate(((DrawablePtr)pWin)->pScreen);

    nbox = REGION_NUM_RECTS(pRegion);
    pbox = REGION_RECTS(pRegion);
    mp = (MapPrivPtr)pPixmap->devPrivate.ptr;
    if (mp->plxtile.canTile) {
       /*
	* note that we tile from lower left to upper right for
	* the sake of the stipple hardware.
	*/
	yt -= 15;
	while (nbox--) {
	    ifdebug(16) printf("\tx1,y1,x2,y2=%d,%d,%d,%d\n",
			       pbox->x1, pbox->y1, pbox->x2-1, pbox->y2-1);
	    p_boxs(xt, yt,
		   pbox->x1, PTY(pbox->y2-1),
		   pbox->x2-1, PTY(pbox->y1));
	    pbox++;
	}
    } else {
	while (nbox--) {
	    ifdebug(16) printf(" slow\tx1,y1,x2,y2=%d,%d,%d,%d\n",
			       pbox->x1, pbox->y1, pbox->x2-1, pbox->y2-1);
	    plxSlowStipple(pWin, xt, yt,
			   mp->plxtile.w, mp->plxtile.h,
			   pbox->x1, pbox->y1,
			   pbox->x2-1, pbox->y2-1);
	    pbox++;
	}
    }
    p_damvx();
}

void
plxPaintAreaNone(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    ifdebug(16) printf("plxPaintAreaNone(), what=%d\n", what);
}

/*
 * Paint Area Parent Relative -- Find first ancestor which isn't parent
 * relative and paint as it would, but with this region
 */
void
plxPaintAreaPR(pWin, pRegion, what)
WindowPtr pWin;
RegionPtr pRegion;
int what;
{
    WindowPtr pParent;
    ScreenPtr	pScr;

    ifdebug(16) printf("plxPaintAreaPR(), what=%d\n", what);

    pParent = pWin->parent;
    while(pParent->background.pixmap == (PixmapPtr)ParentRelative)
        pParent = pParent->parent;

    pScr = pParent->drawable.pScreen;
    switch (what) {
    case PW_BACKGROUND:
        (*pScr->PaintWindowBackground)(pParent, pRegion, what);
        break;
    case PW_BORDER:
        (*pScr->PaintWindowBorder)(pParent, pRegion, what);
        break;
    }
}
