/* $Header: plxScreen.c,v 3.0 89/11/27 15:36:37 toddb Exp $ */
/*
 *   Copyright (c) 1987, 88 by
 *   PARALLAX GRAPHICS, INCORPORATED, Santa Clara, California.
 *   All rights reserved
 *
 *   This software is furnished on an as-is basis, and may be used and copied
 *   only with the inclusion of the above copyright notice.
 *
 *   The information in this software is subject to change without notice.
 *   No committment is made as to the usability or reliability of this
 *   software.
 *
 *   Parallax Graphics, Inc.
 *   2500 Condensa Street
 *   Santa Clara, California  95051
 */

#ifndef lint
static char *sid_ = "@(#)plxScreen.c	1.32 08/31/88 Parallax Graphics Inc";
#endif

#define	PARALLAX_QEVENT
#include	"Xplx.h"
extern int plx_wfd;

#define  NEED_EVENTS
#include "Xproto.h"
#include "cursorstr.h"
#include "input.h"
#include "colormapst.h"

#include "mi.h"
#include "mibstore.h"

extern void miRecolorCursor();
extern RegionPtr miRegionCreate();
extern RegionPtr mfbPixmapToRegion();
extern void px_flush();
extern void plxWakeupHandler();

vsEventQueue *queue;
vsBox *mbox;
vsCursor *mouse;

int lastEventTime;
DevicePtr plxKeyboard;
DevicePtr plxPointer;

VisualRec plxvisuals[] = {
/* vid  class        bpRGB cmpE    nplan rMask gMask bMask oRed oGreen oBlue */
    0,  PseudoColor, 8,    192,    PSZ,  0,    0,    0,    0,   0,     0,
};

#define	Nplxvisuals	(sizeof(plxvisuals)/sizeof(plxvisuals[0]))
#define	Nplxdepths	(sizeof(plxdepths)/sizeof(plxdepths[0]))

static  VisualID VIDs[ Nplxvisuals ];
/*
 *	depth,	numvis,	vids
 */
DepthRec plxdepths[] = {
	1,	0, 	NULL,
	8,	1,	VIDs,			/* last one is ROOTVISUAL */
};

#define	ROOTVISUAL	(Nplxvisuals - 1)

extern ColormapPtr plxcurrentmap[];

int plxWindowPrivateIndex;
int plxGCPrivateIndex;
int plxScreenPrivateIndex;
static unsigned long plxGeneration = 0;

VoidFunc plxPainters[] = {
	plxPaintAreaNone,
	plxPaintAreaPR,
	plxPaintArea,
	plxPaintAreaSolid
};

miBSFuncRec plxBSFuncRec = {
    plxSaveAreas,
    plxRestoreAreas,
    (void (*)()) 0,
    (PixmapPtr (*)()) 0,
    (PixmapPtr (*)()) 0,
};

Bool
plxScreenInit(idx, pScreen, argc, argv)
ScreenPtr pScreen;
char *argv[];
{
    register int i;
    char *display = "", *microcodename = "";
    char *displayconfig = "";
    plxPrivScrPtr	pScreenPriv;
    int bswapflag = -1, sbit15flag = -1;

    ifdebug(5) printf("plxScreenInit(), index=%d\n", idx);

    for (i=0;i<argc;i++) {
	if (strcmp(argv[i], "-display") == 0)
	    display = argv[++i];
	else
	if (strcmp(argv[i], "-displayconfig") == 0)
	    displayconfig = argv[++i];
	else
	if (strcmp(argv[i], "-microcode") == 0)
	    microcodename = argv[++i];
	else
	if (strcmp(argv[i], "-bswap") == 0)
	    bswapflag = atoi(argv[++i]);
	else
	if (strcmp(argv[i], "-sbit0") == 0)
	    sbit15flag = 0;
	else
	if (strcmp(argv[i], "-sbit15") == 0)
	    sbit15flag = 1;
    }

    plxboardinit(display, displayconfig, microcodename, bswapflag, sbit15flag);

    pl_cache_init();
    pl_cache_add(CACHE_1_X, CACHE_1_Y,
		 CACHE_1_X + CACHE_1_WIDTH - 1, CACHE_1_Y + CACHE_1_HEIGHT - 1);
    pl_cache_add(CACHE_2_X, CACHE_2_Y,
		 CACHE_2_X + CACHE_2_WIDTH - 1, CACHE_2_Y + CACHE_2_HEIGHT - 1);

    plxfontmeminit();

    px_get_mmq(&mouse, &mbox, &queue);

    if (plxGeneration != serverGeneration)
    {
	plxGCPrivateIndex = AllocateGCPrivateIndex();
	plxWindowPrivateIndex = AllocateWindowPrivateIndex();
	if ((plxScreenPrivateIndex = AllocateScreenPrivateIndex()) == -1)
	    return FALSE;

	for (i = 0; i < Nplxvisuals; i++) {
	    plxvisuals[i].vid = FakeClientID(0);
            VIDs[i] = plxvisuals[i].vid;
        }
	pScreen->rootVisual = plxvisuals[ ROOTVISUAL ].vid;
	pScreen->defColormap = FakeClientID(0);

	plxGeneration = serverGeneration;
    }
    if (!AllocateGCPrivate(pScreen, plxGCPrivateIndex, sizeof(plxPrivGC))
     || !AllocateWindowPrivate(pScreen, plxWindowPrivateIndex,
				  sizeof(MapPriv)))
	return FALSE;
    if ((pScreenPriv = (plxPrivScrPtr)xalloc(sizeof(plxPrivScreen))) == NULL)
	return FALSE;
    pScreen->devPrivates[ plxScreenPrivateIndex ].ptr = (pointer)pScreenPriv;

    pScreen->myNum = idx;
    pScreen->width = 1280;
    pScreen->height = 1024;
    pScreen->mmWidth =  350;
    pScreen->mmHeight = 260;
    pScreen->numDepths = Nplxdepths;
    pScreen->allowedDepths = plxdepths;

    pScreen->rootDepth = 8;
    pScreen->minInstalledCmaps = 1;
    pScreen->maxInstalledCmaps = 1;
#ifdef X11R2
    pScreen->backingStoreSupport = NotUseful;
#else
    pScreen->backingStoreSupport = Always;
#endif /* X11R2 */
    pScreen->saveUnderSupport = NotUseful;

    /* let plxCreateDefColormap do whatever it wants */
    pScreen->blackPixel = pScreen->whitePixel = (Pixel) 0;

    pScreen->numVisuals = Nplxvisuals;
    pScreen->visuals = plxvisuals;

    pScreen->QueryBestSize = plxQueryBestSize;

    pScreen->CreateWindow = plxCreateWindow;
    pScreen->ChangeWindowAttributes = plxChangeWindowAttributes;
    pScreen->DestroyWindow = plxDestroyWindow;
    pScreen->PositionWindow = plxPositionWindow;
    pScreen->RealizeWindow = plxRealizeWindow;
    pScreen->UnrealizeWindow = plxUnrealizeWindow;

    pScreen->RealizeFont = plxRealizeFont;
    pScreen->UnrealizeFont = plxUnrealizeFont;

    pScreen->GetImage = plxGetImage;
    pScreen->GetSpans = plxGetSpans;

    pScreen->CreateGC = plxCreateGC;
    pScreen->CreatePixmap = plxCreatePixmap;
    pScreen->DestroyPixmap = plxDestroyPixmap;

    pScreen->ValidateTree = miValidateTree;

    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionInit = miRegionInit;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->RegionUninit = miRegionUninit;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->RegionNotEmpty = miRegionNotEmpty;
    pScreen->RegionEmpty = miRegionEmpty;
    pScreen->RegionExtents = miRegionExtents;
    pScreen->RegionAppend = miRegionAppend;
    pScreen->RegionValidate = miRegionValidate;
    pScreen->BitmapToRegion = mfbPixmapToRegion;
    pScreen->RectsToRegion = miRectsToRegion;
    pScreen->SendGraphicsExpose = miSendGraphicsExpose;

    pScreen->WindowExposures = miWindowExposures;
    pScreen->PaintWindowBackground = plxPaintWindow;
    pScreen->PaintWindowBorder = plxPaintBorder;
    pScreen->CopyWindow = plxCopyWindow;
    pScreen->ClearToBackground = miClearToBackground;

    pScreen->BlockHandler = px_flush;
    pScreen->WakeupHandler = plxWakeupHandler;
    pScreen->blockData = (pointer)0;
    pScreen->wakeupData = (pointer)0;

    pScreen->CloseScreen = plxCloseScreen;
    pScreen->SaveScreen = plxSaveScreen;

    pScreen->CreateColormap = plxCreateColormap;
    pScreen->DestroyColormap = plxDestroyColormap;
    pScreen->ListInstalledColormaps = plxListInstalledColormaps;
    pScreen->InstallColormap = plxInstallColormap;
    pScreen->UninstallColormap = plxUninstallColormap;
    pScreen->StoreColors = plxStoreColors;
    pScreen->ResolveColor = plxResolveColor;

    pScreen->DisplayCursor = plxDisplayCursor;
    pScreen->RealizeCursor = plxRealizeCursor;
    pScreen->UnrealizeCursor = plxUnrealizeCursor;
    pScreen->RecolorCursor = miRecolorCursor;
    pScreen->ConstrainCursor = plxConstrainCursor;
    pScreen->CursorLimits = plxCursorLimits;
    pScreen->SetCursorPosition = plxSetCursorPosition;
    pScreen->PointerNonInterestBox = plxPointerNonInterestBox;

    plxcurrentmap[pScreen->myNum] = (ColormapPtr)NULL;
    plxCreateDefColormap(pScreen);

#ifdef PLXVIDEO
    /*
     * any better place to do this?
     */
    plxVideoInit(pScreen);
#endif /* PLXVIDEO */

    miInitializeBackingStore (pScreen, &plxBSFuncRec);

    /*
     * Prepare a wrapper for screen vectors, and otherwise initialize
     * the priv information.
     */
    plxClipInit(pScreen);
    pScreenPriv = plxGetScreenPriv(pScreen);
    pScreenPriv->SaveDoomedAreas = pScreen->SaveDoomedAreas;
    pScreenPriv->RestoreAreas = pScreen->RestoreAreas;
    pScreen->SaveDoomedAreas = plxPreSaveDoomedAreas;
    pScreen->RestoreAreas = plxPreRestoreAreas;

    return TRUE;
}

static Bool
plxSaveScreen(pScreen, on)
ScreenPtr pScreen;
{
    if (on == SCREEN_SAVER_FORCER) {
	lastEventTime = GetTimeInMillis();
	return TRUE;
    } else {
	return FALSE;
    }
}

static Bool
plxCloseScreen(pScreen)
ScreenPtr pScreen;
{
    ifdebug(5) printf("plxCloseScreen()\n");

    pl_cursor_active(0);
    p_floff();
    px_flush();
    px_close();
    return (TRUE);
}
