/*****************************************************************************
 *
 *              Microchip DeviceNet Stack (Application Example)
 *
 *****************************************************************************
 * FileName:        app.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * This is a simple loopback demo.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			07/02/03	...	
 * 
 *****************************************************************************/

#include	"P18F458.H"			// Hardware specific header
#include	"dnet.def"			// Global definitions
#include 	"typedefs.h"		// Global type definitions

#include	"services.h"		// Current list of known service codes
#include	"errors.h"			// Current list of known error codes
#include	"class.h"			// Current list of known class codes

#include	"route.h"			// Public functions, variables, and more from the router object
#include	"conn.h"			// Functions defined by the connection object




/*********************************************************************
 * Function:        void AppClass1Process(void)
 *
 * PreCondition:    
 *
 * Input:       
 *                  
 * Output:         	
 *
 * Side Effects:    
 *
 * Overview:        I/O Processing for the object
 *
 * Note:            None
 ********************************************************************/
void AppClass1Process(void)
{
	// Process any object specific application firmware
	
	
	
	// Check for any I/O data that may need processing.
	// In this case I check for the availability of both read and write buffers
	if (mConnReadRdy(2) && mConnWriteRdy(2))
	{
		// This simple function writes the received data back to the bus,
		// essencially a loopback. Since the read and write buffers are
		// setup in UsrConnCreateEvent() to share the same data space, no 
		// data movement is necessary. 
		// This data is more likely to be associated to some attribute(s) 
		// within a 'real' application object. The path from the Connection
		// Object instance or an Assembly Object would indicate the target(s)
		// for the data. Note the Assembly Object is not developed in this 
		// demonstration.
		
		uConn2.tx.len = uConn2.rx.len;	// Copy the receive lenth to the transmit length
		mConnWrite(2);					// Release the buffer to write when the bus is available
		mConnRead(2);					// Free the buffer to read more data
	}
}





/*********************************************************************
 * Function:        unsigned char AssemblyExplMsgHandler(void)
 *
 * PreCondition:    
 *
 * Input:       
 *                  
 * Output:         	
 *
 * Side Effects:    
 *
 * Overview:        Handler for explicit messaging, static model.
 *
 * Note:            All application objects designed to be visible 
 *					on the network must have a handler for Explicit
 *					Messaging. Use the Router's internal services to 
 *					determine Instance, Service, Attribute, and Class 
 *					if necessary. Refer to ROUTE.H for a complete list
 *					of internal services exposed by the Router.
 ********************************************************************/
unsigned char AppClass1(void)
{
	
	// Decode the instance
	switch (mRouteGetInstanceID())
	{
		// Class level (instance 0) 
		case 0:
			// Decode services for this instance
			switch(mRouteGetServiceID())
			{
				case SRVS_GET_ATTRIB_SINGLE:
					// Develope your code here
					switch (mRouteGetAttributeID())
					{
						case 1:
							mRoutePutByte(1);			// Write the revision
							mRoutePutByte(0);
							break;
								
						default:
							mRoutePutError(ERR_ATTRIB_NOT_SUPPORTED);
							break;
					}
					break;
								
				default:
					mRoutePutError(ERR_SERVICE_NOT_SUPPORTED);
					break;
			}
			break;
			
		// Instance 1
		case 1:
			// Decode services for this instance
			switch(mRouteGetServiceID())
			{
				// Refer to services.h for a list of common services
				// or a custom service can be provided
			
			
				case SRVS_GET_ATTRIB_SINGLE:
					// Develope your code here
					switch (mRouteGetAttributeID())
					{
						// This is essencially a loopback. Any data passed through the get attribute
						// request is passed back as a responce.
						case 64:
							while (mRouteGetInBufferDataLength())
							{
								// Copy all the received data to the transmit buffer; however,
								// Copy the byte only if the buffer is not full
								mRoutePutByte(mRouteGetByte());
							}
							break;
						case 65:
							mRoutePutByte(LATD);			// Return the latch
							break;
						case 66:
							mRoutePutByte(TRISD);			// Return the direction
							break;
						default:
							mRoutePutError(ERR_ATTRIB_NOT_SUPPORTED);
							break;
					}
					break;

				case SRVS_SET_ATTRIB_SINGLE:
					// Develope your code here to manage Set Attribute requests
					
					// Toss the first byte (same as AttributeID)
					mRouteGetByte();
					
					
					// Here I create two attribute ID's for writing
					// TRISD and LATD.
					switch (mRouteGetAttributeID())
					{
						case 64:
							mRoutePutError(ERR_ATTRIB_NOT_SETTABLE);
							break;
						case 65:
							LATD = mRouteGetByte();			// Write the latch			
							break;
						case 66:
							TRISD = mRouteGetByte();		// Set the direction
							break;
						default:
							mRoutePutError(ERR_ATTRIB_NOT_SUPPORTED);
							break;
					}
					break;	
				
				default:
					mRoutePutError(ERR_SERVICE_NOT_SUPPORTED);
					break;
			}
			break;										
		
		
		// Add other static instances if necessary
		// case 2:
		// case 3:
		// ...
		// case x:
		
		// All other instances 
		default:	
			mRoutePutError(ERR_OBJECT_DOES_NOT_EXIST);
			break;
	}

	return (1);
}

			 

