;CAN Library Test file


#include        "p18c658.inc"
#include        "CANPrTx.inc"

#define TX_TEST
#define RX_TEST


        UDATA
CANDt1  RES     02
#ifdef  RX_TEST
RxMsgID         RES     04
RxData          RES     08
RxDtLngth       RES     01
RxFlag          RES     01
#endif




Sta     CODE    0x00
        bra     Main


IHP     CODE    0x08

#ifndef CANIntLowPrior
        call    CANPrTxISR          ;Call CAN Interrupt Service routine
#endif

        retfie  FAST


IHL     CODE    0x018

#ifdef  CANIntLowPrior
        movwf   W_IL            ;Save W
        movff   STATUS,STAT_IL  ;Save STATUS
        movff   BSR,BSR_IL      ;Save BSR
        call    CANPrTxISR          ;Call CAN Interrupt Service routine
        movff   BSR_IL,BSR      ;Restore BSR
        movff   STAT_IL,STATUS  ;Restore Status
        movf    W_IL,W          ;Restore W reg
#endif

        retfie




Test1           CODE
Main:
        clrf    TRISB
        clrf    PORTB           ;Enable CAN Transceiver

;Define TRIS bits to define CANRx pin as i/p and CANTx pin as o/p

        mCANPrTxInit   1, 5, 7, 6, 2,CAN_CONFIG_ALL_VALID_MSG

;Set Loop-back mode for testing in Stand alone mode
;       mCANPrTxSetOpMode     CAN_OP_MODE_LOOP        ;Loop back mode

#ifdef  RX_TEST

;Set configuration mode
        mCANPrTxSetOpMode     CAN_OP_MODE_CONFIG      ;

;Following settings will ensure only following messages in Buf 0
; 0x25 and 0x125 (Filter Hit 0)
; 0x36 and 0x136 (Filter Hit 1)

;Set Mask B0 to 0xfffffeff
        mCANPrTxSetReg CAN_MASK_B0, 0xfffffeff, CAN_CONFIG_XTD_MSG
;Set Filer 0 with 0x25
        mCANPrTxSetReg CAN_FILTER_B0_F1, 0x025, CAN_CONFIG_XTD_MSG
;Set Filer 1 with 0x36
        mCANPrTxSetReg CAN_FILTER_B0_F2, 0x036, CAN_CONFIG_XTD_MSG



;Following settings will ensure only following messages in Buf 1
; 0x08,0x88, 0x1000008, 0x1000088 (Filter Hit 2)
; 0x06,0x86, 0x1000006, 0x1000086 (Filter Hit 3)
; 0x02,0x82, 0x1000002, 0x1000082 (Filter Hit 4)
; 0x01,0x81, 0x1000001, 0x1000081 (Filter Hit 5)

;Set Mask B1 to 0xfeffff7f
        mCANPrTxSetReg CAN_MASK_B1,0xfeffff7f, CAN_CONFIG_XTD_MSG
;Set Filer 2 with 0x08
        mCANPrTxSetReg CAN_FILTER_B1_F1,0x08, CAN_CONFIG_XTD_MSG
;Set Filer 3 with 0x05
        mCANPrTxSetReg CAN_FILTER_B1_F2,0x06, CAN_CONFIG_XTD_MSG
;Set Filer 4 with 0x02
        mCANPrTxSetReg CAN_FILTER_B1_F3,0x02, CAN_CONFIG_XTD_MSG
;Set Filer 5 with 0x01
        mCANPrTxSetReg CAN_FILTER_B1_F4,0x01, CAN_CONFIG_XTD_MSG

; Restore to Normal mode.
        mCANPrTxSetOpMode     CAN_OP_MODE_NORMAL      ;

#endif


#ifdef  TX_TEST
;-------------------------------
;Message 1, Data 01,02, ID 20
Msg1Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x01
        movwf   POSTINC0
        movlw   0x02
        movwf   POSTINC0
        mCANPrTxSendMsg  0x20,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg1Agn         ;Buffer Full, Try again
;-------------------------------


;-------------------------------
;Message 2, Data 03,04, ID 30
Msg2Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x03
        movwf   POSTINC0
        movlw   0x04
        movwf   POSTINC0
        movlw   0xaa
        movwf   POSTINC0
        movlw   0xbb
        movwf   POSTINC0
        mCANPrTxSendMsg  0x30,CANDt1,4,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg2Agn         ;Buffer Full, Try again
;-------------------------------


;-------------------------------
;Message 3, Data 05,06, ID 15
Msg3Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x05
        movwf   POSTINC0
        movlw   0x06
        movwf   POSTINC0
        mCANPrTxSendMsg  0x15,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg3Agn         ;Buffer Full, Try again
;-------------------------------


;-------------------------------
;Message 4, Data 07,08, ID 05
Msg4Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x07
        movwf   POSTINC0
        movlw   0x08
        movwf   POSTINC0
        mCANPrTxSendMsg  0x05,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg4Agn         ;Buffer Full, Try again
;-------------------------------


;-------------------------------
;Message 5, Data 09,0A, ID 10
Msg5Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x09
        movwf   POSTINC0
        movlw   0x0A
        movwf   POSTINC0
        mCANPrTxSendMsg  0x10,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg5Agn         ;Buffer Full, Try again
;------------------------------



;-------------------------------
;Message 6, Data 0B,0C, ID 35
Msg6Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x0B
        movwf   POSTINC0
        movlw   0x0C
        movwf   POSTINC0
        mCANPrTxSendMsg  0x35,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg6Agn         ;Buffer Full, Try again
;-------------------------------
;Loop1   
;        bra     Loop1

;-------------------------------
;Message 7, Data 0D,0E, ID 20
Msg7Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x0D
        movwf   POSTINC0
        movlw   0x0E
        movwf   POSTINC0
        mCANPrTxSendMsg  0x20,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg7Agn         ;Buffer Full, Try again
;-------------------------------

;-------------------------------
;Message 8, Data 0F,10, ID 05
Msg8Agn:
        movlw   low(CANDt1)
        movwf   FSR0L
        movlw   high(CANDt1)
        movwf   FSR0H
        movlw   0x0F
        movwf   POSTINC0
        movlw   0x10
        movwf   POSTINC0
        mCANPrTxSendMsg  0x05,CANDt1,2,CAN_TX_XTD_FRAME
        addlw   0x00            ;Check for return value of 0 in W
        bz      Msg8Agn         ;Buffer Full, Try again
;-------------------------------
#endif

;       mCANPrTxAbortAll             ;Use to abort transmission of all messages.
;       mCANPrTxGetTxErrCnt      ;Get Tx Error count
;       mCANPrTxGetRxErrCnt      ;Get Rx Error count

RcvMsg:
Loop:                                   

        nop

#ifdef  RX_TEST
        mCANPrTxReadMsg  RxMsgID, RxData, RxDtLngth, RxFlag
        xorlw   0x01
        bnz     Loop

;Message Recd. Successfully 
;       RxMsgID = 32 bit ID
;       RxData = Received Data Buffer
;       RxDtLngth = Length f Received data
;       RxFlag = Flag of CAN_RX_MSG_FLAGS type, Use it for Message
;       information
        
        nop
#endif

        bra     Loop
        
        
        END

