/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Common Service Definitions)
 *
 *****************************************************************************
 * FileName:        services.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains DeviceNet Common Service Definitions.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/


#ifndef	__SERVICES__
#define __SERVICES__




#define	SRVS_GET_ATTRIBS_ALL	0x01
#define	SRVS_SET_ATTRIBS_ALL	0x02

#define	SRVS_RESET				0x05
#define	SRVS_START				0x06
#define	SRVS_STOP				0x07
#define	SRVS_CREATE				0x08
#define	SRVS_DELETE				0x09

#define	SRVS_APPLY_ATTRIBS		0x0D
#define	SRVS_GET_ATTRIB_SINGLE	0x0E

#define	SRVS_SET_ATTRIB_SINGLE	0x10
#define SRVS_FIND_NEXT_OBJ_INST	0x11

#define	SRVS_ERROR_RESPONSE		0x14
#define	SRVS_RESTORE			0x15
#define	SRVS_SAVE				0x16
#define	SRVS_NO_OPERATION		0x17
#define	SRVS_GET_MEMBER			0x18
#define	SRVS_SET_MEMBER			0x19
#define	SRVS_INSERT_MEMBER		0x1A
#define	SRVS_REMOVE_MEMBER		0x1B

#define	SRVS_ALLOCATE_CONN		0x4B
#define	SRVS_RELEASE_CONN		0x4C




#endif //__SERVICES__
