/*****************************************************************************
 *
 * Microchip DeviceNet Stack (User level Connection Object events)
 *
 *****************************************************************************
 * FileName:        UsrConn.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains events generated from the Connection Object that cannot
 * be handled internally.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/17/03	...	
 * 
 *****************************************************************************/



#include	"dnet.def"			// Global definitions file
#include 	"typedefs.h"

#include	"conn.h"			// All globals in the Connection object

#include	"services.h"		// Service codes
#include	"errors.h"			// Error codes
#include	"class.h"			// Class codes

#include	"route.h"			// Global symbols defined by the Router Obj


unsigned char pollMsgBuffer[40];
unsigned char pollMsgConsPath[6];
unsigned char pollMsgProdPath[6];


/*********************************************************************
 * Function:        unsigned char UsrConnCreateEvent(unsigned char hInstance)
 *
 * PreCondition:    N/A
 *
 * Input:       	instance no#
 *                  
 * Output:         	status of the request
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a Connection Creation has been 
 *					requested. 
 *
 * Note:            The application programmer should utilize this event
 *					to allocate resources for the request, i.e. hardware
 *					peripherals and RAM. If there is a resource problem
 *					then the function should return 0 to prevent the
 *					connection from opening consiquently notfying the 
 *					master on the network.
 *
 *					Valid instances are INST_POLL, INST_STROBE, 
 *					INST_CYC_COS, and INST_MULTICAST.
 ********************************************************************/
unsigned char UsrConnCreateEvent(unsigned char hInstance)
{
	switch (hInstance)
	{
		case INST_POLL:
			// Set the Class trigger
			
			// Set the path and path length			
						
			
			// Set the connection size
			uConn2.attrib.consumed_con_size.word = 33;
			uConn2.attrib.produced_con_size.word = 40;
			
			// Set the pointers to the buffer
			uConn2.rx.pMsg = pollMsgBuffer;
			uConn2.tx.pMsg = pollMsgBuffer;		
			return(INST_POLL);
			
		// Add handling for other static instances if necessary
		case INST_STROBE:
		case INST_CYC_COS:
		case INST_MULTICAST:					
		default:
			return(NULL);	// Do not allow creation
	}
}



/*********************************************************************
 * Function:        void UsrConnCloseEvent(unsigned char hInstance)
 *
 * PreCondition:    N/A
 *
 * Input:       	instance no#
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a Connection Close has been 
 *					requested. 
 *
 * Note:            Release any resource that were allocated from creation.
 *
 *					Valid instances are INST_POLL, INST_STROBE, 
 *					INST_CYC_COS, and INST_MULTICAST.
 ********************************************************************/
void UsrConnCloseEvent(unsigned char hInstance)
{
	switch (hInstance)
	{
		case INST_POLL:
						
			return;
			
		// Add other static instances if necessary
		// case INST_STROBE:
		// case INST_CYC_COS:
		// case INST_MULTICAST:					
	}
	
	return;
}



/*********************************************************************
 * Function:        void UsrConnRxDataEvent(unsigned char hInstance)
 *
 * PreCondition:    N/A
 *
 * Input:       	instance no#
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when data has been received for
 *					a particular Connection instance. 
 *
 * Note:            This event does not need to be handled. Internal 
 *					Connection Object Services can be used to determine 
 *					the presence of new data.
 *
 *					Valid instances are INST_POLL, INST_STROBE, 
 *					INST_CYC_COS, and INST_MULTICAST.
 ********************************************************************/
void UsrConnRxDataEvent(unsigned char hInstance)
{
	// Use the public connection services or poll for the event

/*	
	sswitch (hInstance)
	{
		case INST_POLL:
						
			break;
						
		// Add other static instances if necessary
		// case INST_STROBE:
		// case INST_CYC_COS:
		// case INST_MULTICAST:					
		
	}
	
	return;
	}
*/
}



/*********************************************************************
 * Function:        void UsrConnTxDataEvent(unsigned char hInstance)
 *
 * PreCondition:    N/A
 *
 * Input:       	instance no#
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when data has been transmitted for
 *					a particular Connection instance. 
 *
 * Note:            This event does not need to be handled. Internal 
 *					Connection Object Services can be used to determine 
 *					the completion of transmission.
 *
 *					Valid instances are INST_POLL, INST_STROBE, 
 *					INST_CYC_COS, and INST_MULTICAST.
 ********************************************************************/
void UsrConnTxDataEvent(unsigned char hInstance)
{
	// Use the public connection services or poll for the event
/*	
	switch (hInstance)
	{
		case INST_POLL:
						
			break;
			
		// Add other static instances if necessary
		// case INST_STROBE:
		// case INST_CYC_COS:
		// case INST_MULTICAST:					
		
	}
	
	return;
*/
}



/*********************************************************************
 * Function:        void UsrConnSetAttribEvent(unsigned char hInstance)
 *
 * PreCondition:    N/A
 *
 * Input:       	instance no#
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a Set Attribute has been 
 *					requested for a particular instance that cannot
 *					be handled internally because of some application
 *					dependency. 
 *
 * Note:            Valid instances are INST_EXPL, INST_POLL, 
 *					INST_STROBE, INST_CYC_COS, and INST_MULTICAST.
 ********************************************************************/
void UsrConnSetAttribEvent(unsigned char hInstance)
{
	// Use the public router services to determine the specifics
	
	switch (hInstance)
	{
		case INST_POLL:
			switch(mRouteGetAttributeID())
			{
				case CONN_ATTRIB_CLASS_TRIGGER:
					break;
				case CONN_ATTRIB_PRODUCED_CONN_PATH:	
					break;
				case CONN_ATTRIB_CONSUMED_CONN_PATH:
					break;
				case CONN_ATTRIB_CONSUMED_CONN_SIZE:
					break;
			}
			
			break;
			
		// Add other static instances if necessary
		// case INST_EXPL:
		// case INST_POLL:
		// case INST_STROBE:
		// case INST_CYC_COS:
		// case INST_MULTICAST:					
		default:
			return;	
	}
}
							










