/*****************************************************************************
 *
 * Microchip DeviceNet Stack (User level Identity Object events)
 *
 *****************************************************************************
 * FileName:        UsrConn.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains events generated from the Identity Object that cannot
 * be handled internally.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/17/03	...	
 * 
 *****************************************************************************/

#include	"dnet.def"			// Global definitions file
#include 	"typedefs.h"

#include	"ident.h"
#include	"route.h"


ROM unsigned char cProductName[] = {"Microchip Device"};



/*********************************************************************
 * Function:        void UsrIdentityCommunicationFaultEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a communications fault has occured. 
 *
 * Note:            This is a re-occuring event until the fault is removed
 *					and the state of the device is reset.
 ********************************************************************/
void UsrIdentityCommunicationFaultEvent(void)
{
	// Refer to Volume II 6-2 for specific communication fault details.
	// The specification identifies requirements for indication (Green LED,
	// Red LED, ...)
}


/*********************************************************************
 * Function:        void UsrIdentityFaultEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a fault has occured. 
 *
 * Note:            This event occures only when there is an internal 
 *					corruption,	i.e. somehow the network access state 
 *					machine was corrupted, i.e. an abnormal power event.
 ********************************************************************/
void UsrIdentityFaultEvent(void)
{

}



/*********************************************************************
 * Function:        void UsrIdentityReset(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a reset has been requested. 
 *
 * Note:            It is up to the application to determine how to 
 *					poroceed with the reset.
 ********************************************************************/
void UsrIdentityReset(void)
{
	USINT resetData;
	
	// Toss the first byte (this is actually the attribute ID)
	mRouteGetByte();
	
	// Verify that one byte has been received; an error
	// response is already place in the buffer if there is
	// a length problem.
	if (mRouteTestValidInputDataLen(1))
	{
		// Get the data from the buffer 
		// See 6-2.3.1 volume II for more information.
		resetData = mRouteGetByte();
		
		if (resetData == 0)
		{
			// Perform a soft reset
		}	
		else if (resetData == 1)
		{
			// Perform an 'out of the box' reset	
		}
		else
		{
			// Unknown... return an error or something	
		}
	}
}


/*********************************************************************
 * Function:        void UsrIdentityInitEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when the Identity Object is
 *					initialized. 
 *
 * Note:            There are several parameters that must be setup
 *					to identify the device. It is left up to the 
 *					application to decide how to provide these.
 ********************************************************************/
void UsrIdentityInitEvent(void)
{
	// Refer to section 6-2.2 of Volume II for attribute details
	mIdentitySetVendorID(12345L);		// 16-bit
	
	mIdentitySetDeviceType(2123L);		// 16-bit
	
	mIdentitySetProductCode(3234L);		// 16-bit
	
	mIdentitySetMajorRevision(1);		// 8-bit
	mIdentitySetMinorRevision(0);		// 8-bit
	
	mIdentitySetStatus(0L);				// 16-bit, This attribute should be used in the
										// application to set various status conditions
										
	mIdentitySetSerial(23428904L);		// 32-bit
	
	mIdentitySetNameP(cProductName);	// ROM Pointer to string less than 32 bytes long
	mIdentitySetNameLen(sizeof(cProductName));
}



/*********************************************************************
 * Function:        void UsrIdentitySetAttribEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a Set Attribute has been 
 *					requested that cannot be handled internally because 
 *					of some application	dependency. 
 *
 * Note:            
 ********************************************************************/
//void UsrIdentitySetAttribEvent(void)
//{
//

//}









