;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support I2C Master       ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            I2CMInt.asm                                     ;    
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      I2CMInt.Inc                                     ;
;*                      I2CMInt.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Mar 28, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************;***********************;
                                                ;
#define MSSP_MODULE                             ;Module definitions to generate error message for
#define _GEN_MODULE_ERROR                       ;Processor which do not have these module.
                                                ;
#define _ADD_PROC_INC_FILE                      ;
                                                ;
    #include "P18xxx.inc"                       ;
    #include "P16xxx.inc"                       ;
                                                ;
#define I2CMInt_Source                          ;
                                                ;
    #include "I2CMInt.Inc"                      ;
                                                ;
                                                ;
;***********************************************;
; Baud Rate Genarator Reload value              ;
;***********************************************;    
                                                ;
_QUOTIENT    EQU    CLOCK_FREQ / (4 * I2CM_BUS_FREQUENCY)-1;to convert the freq in 400KHz            
_REMAINDER   EQU    CLOCK_FREQ % (4 * I2CM_BUS_FREQUENCY)  ;
                                                ;
        #if     _REMAINDER != 0                 ;
                                                ;
_I2CM_BAUD_COUNT    EQU     _QUOTIENT + 1       ;_I2CMBAUDCOUNT is nearest to ((fosc/4)/I2CMSPEED)-1,
                                                ; which has to be written in SSPADD.
        #else   ;_REMAINDER = 0                 ;
                                                ;
_I2CM_BAUD_COUNT    EQU    _QUOTIENT            ;_I2CMBAUDCOUNT = ((fosc/4)/I2CMSPEED)-1, which has to be written in SSPADD.
                                                ;which has to be written in SSPADD.
        #endif                                  ;
                                                ;
;-----------------------------------------------;
        #if     _I2CM_BAUD_COUNT > 127          ;
                                                ;
        ERROR "At this System frequency, the given I2C frequency is not attainable."
                                                ;
        #endif                                  ;
                                                ;
        #if     _I2CM_BAUD_COUNT < 2            ;
                                                ;
        ERROR "At this System frequency, the given I2C frequency is not attainable."
                                                ;
        #endif                                  ;
                                                ;
;***********************************************;

;***********************************************;
                                                ;
    #ifdef    _PIC18xxx                         ;
I2CMSV    UDATA_ACS                             ;
    #else                                       ;
I2CMSV    UDATA_SHR                             ;
    #endif                                      ;
                                                ;
vI2CMIntStatus          RES     1               ;I2C Mas Communication Status/Error Register
_vI2CMIntState          RES     1               ;I2C Mas Communication Status Register
                                                ;
I2CMSV1     UDATA                               ;
                                                ;
_vI2CMIntTxDataCount    RES     1               ;Space to store number of bytes to be received
_vI2CMIntRxDataCount    RES     1               ;Space to store number of bytes to be transmitted
_vI2CMIntRSPnt          RES     1               ;Space to store number of bytes to be transmitted before sending Repeated start
_vI2CMIntBufRdPtr       RES     1               ;I2CM Buffer Read Pointer
_vI2CMIntBufWrPtr       RES     1               ;I2CM Buffer Write Pointer
                                                ;
I2CMOV      UDATA_OVR                           ;
                                                ;
_vI2CMIntTempReg        RES     1               ;For temporary use
_vI2CMIntDupFSR         RES     1               ;Storage for FSR/FSR0L
    #ifdef  _PIC18xxx                           ;
_vI2CMIntDupFSRH        RES     1               ;Storage for FSR0H
    #endif                                      ;
                                                ;
I2CMV       UDATA                               ;
                                                ;
vI2CMIntBuffer      RES     I2CM_BUFFER_LENGTH  ;I2CM Buffer
                                                ;
;***********************************************;

;***********************************************;
                                                ;
    #ifdef  _PIC18xxx                           ;
      #ifdef _MSSP_MODULE                       ;
        include "18I2CMI.asm"                   ;
      #endif                                    ;
    #endif                                      ;
                                                ;
    #ifdef  _PIC16xxx                           ;
      #ifdef _MSSP_MODULE                       ;
        include "16I2CMI.asm"                   ;
      #endif                                    ;
    #endif                                      ;
                                                ;
                                                ;
;***********************************************;

    END

;***********************************************;
