;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support I2C Master       ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            I2CMInt.inc                                     ;    
;* Dependencies:        I2CMInt.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Feb 07, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************************************;
                                                ;
    #ifndef __I2CMInt_INC                       ;Check if inc file already included
                                                ;
        #define __I2CMInt_INC                   ;
                                                ;
;***********************************************;
    #include "I2CMInt.Def"                      ;
                                                ;
    #ifndef  I2CMInt_Source                     ;
                                                ;
    #include  "P18xxx.inc"                      ;
    #include  "P16xxx.inc"                      ;
;***********************************************;
    EXTERN  vI2CMIntStatus                      ;
                                                ;
    EXTERN  I2CMIntISR                          ;
    EXTERN  I2CMIntInit                         ;
    EXTERN  I2CMIntStart                        ;
    EXTERN  I2CMIntReStart                      ;
    EXTERN  I2CMIntStop                         ;
    EXTERN  I2CMIntPut                          ;
    EXTERN  I2CMIntGet                          ;
    EXTERN  I2CMIntSetGetCount                  ;
    EXTERN  I2CMIntDiscardBuf                   ;
                                                ;
;***********************************************;
    #else                                       ;
                                                ;
    GLOBAL  vI2CMIntStatus                      ;
                                                ;
;***********************************************;
;***********************************************;
;I2CMIntState register bits                     ;
;***********************************************;
                                                ;
I2CMStp     EQU    7                            ;Stop bit has to be sent
I2CMRStrt   EQU    6                            ;Repeated Start bit has to be sent
I2CMTx      EQU    5                            ;1-Transmission is going on, 0-Reception is going on
                                                ;
#define     I2CMTransmitState   0               ;Indicates Transmission has to be done
#define     I2CMCheckAckState   1               ;Indicates Acknowledge has to be checked
#define     I2CMReceiveState    2               ;Indicates Reception has to be done
#define     I2CMReceiveEnState  3               ;Indicates Reception has to be enabled
#define     I2CMStopState       4               ;Indicates Stop has to be sent
                                                ;
;***********************************************;
    #endif                                      ;
;***********************************************;
;I2CMIntStatus register bits                    ;
;***********************************************;
                                                ;
I2CMErrBusCollision EQU    7                    ;I2C Bus collision occured
I2CMErrBusBusy      EQU    6                    ;I2C Bus is Busy
I2CMErrNoAck        EQU    5                    ;Slave did'nt acknowledge
                                                ;
I2CMDataReady       EQU    4                    ;I2C Rx Data is ready
I2CMBusy            EQU    3                    ;I2CM Communication going on
I2CMBufOverFlow     EQU    2                    ;I2CM Buffer Over flow
I2CMBufFull         EQU    1                    ;I2CM Buffer Full
I2CMBufEmpty        EQU    0                    ;I2CM Buffer Empty
                                                ;
;***********************************************;


;***********************************************************************;
; Macro: mI2CMIntDisable                                                ;
;                                                                       ;
; PreCondition: I2CMIntInit should have called.                         ;
;                                                                       ;
; Overview:                                                             ;
;       This disables I2C Master.                                       ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mI2CMIntDisable MACRO                           ;
                                                ;
        #ifdef  _PIC16xxx                       ;
                                                ;
        BANKSEL SSPCON                          ;
        bcf     SSPCON,SSPEN                    ;3
                                                ;
        #else                                   ;
                                                ;
        bcf     SSPCON1,SSPEN                   ;1
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;

    #ifdef  _PIC18xxx                           ;

;***********************************************************************;
; Macro:        mSetI2CMIntHighPriority                                 ;
;                                                                       ;
; Overview:     Sets high priority for MSSP interrupt.                  ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetI2CMIntHighPriority MACRO                   ;
                                                ;
    bsf    IPR1,SSPIP                           ;High Priority for MSSP Int.
    bsf    IPR2,BCLIP                           ;High Priority for BusCollision Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3

;***********************************************************************;
; Macro:        mSetI2CMIntLowPriority                                  ;
;                                                                       ;
; Overview:     Sets low priority for MSSP interrupt.                   ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetI2CMIntLowPriority  MACRO                   ;
                                                ;
    bcf    IPR1,SSPIP                           ;Low Priority for MSSP Int.
    bcf    IPR2,BCLIP                           ;Low Priority for BusCollision Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3

    #endif                                      ;



;***********************************************;
;    END                                        ;
;***********************************************;    

