;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI              ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            SPIMInt.asm                                     ;
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      SPIMInt.Def                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       Apr 14, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************************************;
                                                ;
    #ifndef __SPIMInt_INC                       ;Check if inc file already included
                                                ;
        #define __SPIMInt_INC                   ;
                                                ;
;***********************************************;
    #include    "SPIMInt.Def"                   ;
                                                ;
;***********************************************;
                                                ;
    #ifndef SPIMInt_Source                      ;
                                                ;
        #define     BSSP_MODULE                 ;Module definition
                                                ;
        #include    "P18xxx.inc"                ;
        #include    "P16xxx.inc"                ;
;***********************************************;
    EXTERN    vSPIMIntStatus                    ;
                                                ;
    EXTERN    SPIMIntISR                        ;
    EXTERN    SPIMIntInit                       ;
    EXTERN    SPIMIntPut                        ;
    EXTERN    SPIMIntGet                        ;
    EXTERN    SPIMIntSetGetCount                ;
    EXTERN    SPIMIntDiscardRxBuf               ;
                                                ;
;***********************************************;
                                                ;
    #else                                       ;
                                                ;
    GLOBAL    vSPIMIntStatus                    ;
                                                ;
    #endif                                      ;
                                                ;
;***********************************************;
;SPIMIntStatus register bits                    ;
;***********************************************;
                                                ;
SPIMSave            EQU     6                   ;SPIM Communication going on
SPIMBusy            EQU     5                   ;SPIM Communication going on
SPIMRxBufOverFlow   EQU     4                   ;SPIM Buffer Over flow
SPIMRxBufFull       EQU     3                   ;SPIM Buffer Full
SPIMRxBufEmpty      EQU     2                   ;SPIM Buffer Empty
SPIMTxBufFull       EQU     1                   ;SPIM Buffer Full
SPIMTxBufEmpty      EQU     0                   ;SPIM Buffer Empty
                                                ;
;***********************************************;
;***********************************************;
                                                ;
Hi              EQU     1                       ;
Lo              EQU     0                       ;
ActiveToIdle    EQU     1                       ;
IdleToActive    EQU     0                       ;
Mids            EQU     0                       ;
Ends            EQU     1                       ;
                                                ;
;***********************************************;
;***********************************************;


        #ifdef    _PIC16xxx

;***********************************************************************;
; Macro: mSPIMIntSetClockIdleState                                      ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This sets Idle State of the Clock pin High(Hi) or Low(Lo)       ;
;                                                                       ;
; Input: State - 'Hi' or 'Lo'                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetClockIdleState MACRO State           ;
                                                ;
        #if     State == Lo                     ;
                                                ;
        BANKSEL SSPCON                          ;
        bcf     SSPCON,CKP                      ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL SSPCON                          ;
        bsf     SSPCON,CKP                      ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3        


;***********************************************************************;
; MACRO: mSPIMIntSetTransmitOnClockEdge                                 ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Transmition on  Clock Edge IdleToActive or      ;
;       ActiveToIdle of the Clock                                       ;
;                                                                       ;
; Input: Edge - 'IdleToActive' or 'ActiveToIdle'                        ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetTransmitOnClockEdge MACRO Edge       ;
                                                ;
    #ifndef _MSSP_MODULE                        ;
                                                ;
     #ifndef _SSP_MODULE                        ;
                                                ;
        #ifdef  _BSSP_MODULE                    ;
                                                ;
        messg "Its not allowed to select Tranmission Edge in this processor."
        messg "Its always at IdleToActive edge of clock."
                                                ;
        #endif                                  ;
                                                ;
     #else                                      ;
                                                ;
        #if     Edge == IdleToActive            ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
        #endif                                  ;
                                                ;
     #endif                                     ;
                                                ;
    #else                                       ;
                                                ;
        #if     Edge == IdleToActive            ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
        #endif                                  ;
                                                ;
    #endif                                      ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3        


;***********************************************************************;
; MACRO: mSPIMIntSetSampleAtDataOut Phase                               ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Sampling Phase at the Point Middle(Mids) or     ;
;       End(Ends) of Data                                               ;
;                                                                       ;
; Input: Point - 'Mids' or 'Ends'                                       ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetSampleAtDataOut MACRO Phase          ;
                                                ;
    #ifndef _MSSP_MODULE                        ;
                                                ;
     #ifndef _SSP_MODULE                        ;
                                                ;
        #ifdef  _BSSP_MODULE                    ;
                                                ;
        messg "Its not allowed to select Sampling Phase in this processor."
        messg "Its always at Middle of DataOut."
                                                ;
        #endif                                  ;
                                                ;
     #else                                      ;
                                                ;
        #if     Phase == Mids                   ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bcf     SSPSTAT,SMP                     ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL SSPSTAT                         ;
        bsf     SSPSTAT,SMP                     ;
                                                ;
        #endif                                  ;
                                                ;
     #endif                                     ;
                                                ;
    #else                                       ;
                                                ;
        #if     Phase == Mids                   ;
                                                ;
        bsf     STATUS,RP0                      ;
        bcf     SSPSTAT,SMP                     ;
                                                ;
        #else                                   ;
                                                ;
        bsf     STATUS,RP0                      ;
        bsf     SSPSTAT,SMP                     ;
                                                ;
        #endif                                  ;
                                                ;
    #endif                                      ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3


;***********************************************************************;
; Macro: mSPIMIntDisable                                                ;
;                                                                       ;
; PreCondition: Communication should be over                            ;
;                                                                       ;
; Overview:                                                             ;
;       This disables MSSP Module.                                      ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntDisable MACRO                           ;
                                                ;
        BANKSEL SSPCON                          ;
        bcf     SSPCON,SSPEN                    ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;3


        #endif



        #ifdef  _PIC18xxx

;***********************************************************************;
; Macro: mSPIMIntSetClockIdleState                                      ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This sets Idle State of the Clock pin High(Hi) or Low(Lo)       ;
;                                                                       ;
; Input: State - 'Hi' or 'Lo'                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetClockIdleState MACRO State           ;
                                                ;
        #if     State == 0                      ;
                                                ;
        bcf     SSPCON1,CKP                     ;
                                                ;
        #else                                   ;
                                                ;
        bsf     SSPCON1,CKP                     ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1        


;***********************************************************************;
; MACRO: mSPIMIntSetTransmitOnClockEdge                                 ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Transmition on  Clock Edge IdleToActive or      ;
;       ActiveToIdle of the Clock                                       ;
;                                                                       ;
; Input: Edge - 'IdleToActive' or 'ActiveToIdle'                        ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetTransmitOnClockEdge MACRO Edge       ;
                                                ;
        #if     Edge == 0                       ;
                                                ;
        bcf     SSPSTAT,CKE                     ;
                                                ;
        #else                                   ;
                                                ;
        bsf     SSPSTAT,CKE                     ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1        


;***********************************************************************;
; MACRO: mSPIMIntSetSampleAtDataOut Phase                               ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This selects to Sampling Phase at the Point Middle(Mids) or     ;
;       End(Ends) of Data                                               ;
;                                                                       ;
; Input: Point - 'Mids' or 'Ends'                                       ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntSetSampleAtDataOut MACRO Phase          ;
                                                ;
        #if     Phase == 0                      ;
                                                ;
        bcf     SSPSTAT,SMP                     ;
                                                ;
        #else                                   ;
                                                ;
        bsf     SSPSTAT,SMP                     ;
                                                ;
        #endif                                  ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1



;***********************************************************************;
; Macro: mSPIMIntDisable                                                ;
;                                                                       ;
; PreCondition: Communication should be over                            ;
;                                                                       ;
; Overview:                                                             ;
;       This disables SSP Module.                                       ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: None                                               ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
mSPIMIntDisable MACRO                           ;
                                                ;
        bcf     SSPCON1,SSPEN                   ;
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1


;***********************************************************************;
; Macro:        mSetSPIMIntHighPriority                                 ;
;                                                                       ;
; Overview:     Sets high priority for SSP interrupt.                   ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetSPIMIntHighPriority MACRO                   ;
                                                ;
    bsf    IPR1,SSPIP                           ;High Priority for MSSP Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1

;***********************************************************************;
; Macro:        mSetSPIMIntLowPriority                                  ;
;                                                                       ;
; Overview:     Sets low priority for SSP interrupt.                    ;
;                                                                       ;
; Input:        None                                                    ;
;                                                                       ;
; Output:       None                                                    ;
;                                                                       ;
; Side Effects: None                                                    ;
;***********************************************************************;
                                                ;
mSetSPIMIntLowPriority  MACRO                   ;
                                                ;
    bcf    IPR1,SSPIP                           ;Low Priority for MSSP Int.
                                                ;
        ENDM                                    ;
                                                ;
;***********************************************;1

        #endif

    #endif



;***********************************************;
;        END                                    ;
;***********************************************;        

