#ifndef __3D_H__
#define __3D_H__

struct Ray
{
	Vector3D<> Start;
	Vector3D<> Dir;
};

struct Surface
{
	bool Textured;
	Color4 Color;
	Texture *Tex;
	TextureMapping *TexMap;
	double Diffuse;
	double Reflect;
	double Specular, Gloss;

	Surface() : Textured(false), Tex(NULL), TexMap(NULL), Diffuse(1),
					Reflect(0),Specular(0),Gloss(100) {}

	void Load(const XMLNode * n);
	Color4 ColorAt(Vector3D<> ISect, Vector3D<> Normal);
};

class Obj3D
{
	public:
		virtual double ISection(Ray & r)=0;
		virtual Vector3D<> NormalAt(const Vector3D<> & Point)=0;
		virtual void Load(const XMLNode * n)=0;
		virtual void Flip()=0;
		virtual Obj3D * NewCopy()=0;
		Surface Surf;
};

class Sphere : public Obj3D
{
	private:
		Vector3D <> Center;
		double Radius;
		bool Outward;
	public:
		Sphere() : Radius(1), Outward(true) {}

		virtual double ISection(Ray & r);
		virtual Vector3D<> NormalAt(const Vector3D<> & Point);
		virtual void Load(const XMLNode * n);
		virtual void Flip();
		virtual Obj3D * NewCopy();
		virtual ~Sphere(){}
};

class Plane : public Obj3D
{
	private:
		Vector3D <> Point;
		Vector3D <> Normal;
	public:
		virtual double ISection(Ray & r);
		virtual Vector3D<> NormalAt(const Vector3D<> & Point);
		virtual void Load(const XMLNode * n);
		virtual void Flip();
		virtual Obj3D * NewCopy();
		virtual ~Plane(){}
};

struct Intersection
{
	Vector3D<> Point;
	Obj3D * Obj;
	double Dist;
	Color4 Color;
};

#endif
