#ifndef __COLOR_H__
#define __COLOR_H__

#include <iostream>

struct Color4
{
	double C[4];

	Color4(){ C[0] = C[1] = C[2] = C[3] = 0.0;}

	Color4(double R, double G, double B,double A=1.0){C[0] = R; C[1] = G; C[2] = B; C[3] = A;}

	Color4(double * c){C[0]=c[0];C[1]=c[1];C[2]=c[2];C[4]=c[3];}

	Color4 operator+(const Color4 & rhs){return Color4(C[0]+rhs.C[0],C[1]+rhs.C[1],C[2]+rhs.C[2],C[3]+rhs.C[3]);}
	Color4 operator-(const Color4 & rhs){return Color4(C[0]-rhs.C[0],C[1]-rhs.C[1],C[2]-rhs.C[2],C[3]-rhs.C[3]);}
	Color4 operator*(const Color4 & rhs){return Color4(C[0]*rhs.C[0],C[1]*rhs.C[1],C[2]*rhs.C[2],C[3]*rhs.C[3]);}

	Color4 operator*(const double & rhs){return Color4(C[0]*rhs,C[1]*rhs,C[2]*rhs,C[3]*rhs);}

	Color4 operator/(const double & rhs){return Color4(C[0]/rhs,C[1]/rhs,C[2]/rhs,C[3]/rhs);}

	Color4 operator*=(const double & rhs){return *this = *this * rhs;}
	Color4 operator/=(const double & rhs){return *this = *this / rhs;}

	const Color4& operator+=(const Color4 & rhs)
	{
		C[0] += rhs.C[0];
		C[1] += rhs.C[1];
		C[2] += rhs.C[2];
		C[3] += rhs.C[3];
		return *this;
	}

	const Color4& operator-=(const Color4 & rhs)
	{
		C[0] -= rhs.C[0];
		C[1] -= rhs.C[1];
		C[2] -= rhs.C[2];
		C[3] -= rhs.C[3];
		return *this;
	}

	const Color4& operator*=(const Color4 & rhs)
	{
		C[0] *= rhs.C[0];
		C[1] *= rhs.C[1];
		C[2] *= rhs.C[2];
		C[3] *= rhs.C[3];
		return *this;
	}

	const Color4& operator/=(const Color4 & rhs)
	{
		C[0] /= rhs.C[0];
		C[1] /= rhs.C[1];
		C[2] /= rhs.C[2];
		C[3] /= rhs.C[3];
		return *this;
	}

	const Color4& operator=(const Color4 & rhs)
	{
		C[0] = rhs.C[0];
		C[1] = rhs.C[1];
		C[2] = rhs.C[2];
		C[3] = rhs.C[3];
		return *this;
	}
};

inline std::ostream& operator<<(std::ostream & out, const Color4 & c)
{
	out << "Color4[" << c.C[0] << "," << c.C[1] << ","
		<< c.C[2] << "," << c.C[3] << "]";
	return out;
}

#endif
