#include "rt.h"

void PlanarMapping::Load(const XMLNode * mn)
{
	for(NodeIterator itr=mn->Children.begin();
	 itr != mn->Children.end();itr++)
	{
		if((*itr)->Name == "Center")
		{
			ParseVector((*itr)->Content,Center);
		}
		else if((*itr)->Name == "Axis")
		{
			switch((*itr)->Content[0])
			{
				case 'X':
					MappedAxis = AxisX;
					break;
				case 'Y':
					MappedAxis = AxisY;
					break;
				case 'Z':
					MappedAxis = AxisZ;
					break;
			}
		}
	}
}

TexCoord PlanarMapping::GetCoords(const Vector3D<> & Point, const Vector3D<> & Normal)
{
	switch(MappedAxis)
	{
		case AxisX:
			return TexCoord(Point.V[2]-Center.V[2],Point.V[1]-Center.V[1]);
		case AxisY:
			return TexCoord(Point.V[0]-Center.V[0],Point.V[2]-Center.V[2]);
		case AxisZ:
			return TexCoord(Point.V[0]-Center.V[0],Point.V[1]-Center.V[1]);
	}
	return TexCoord(0,0);
}

CheckerboardTexture::CheckerboardTexture() : uWidth(1), vWidth(1) {}

Color4 CheckerboardTexture::ColorAt(const TexCoord Coord)
{
	double v = (Coord.v - Center.v); if(v<0) v -= vWidth;
	double u = (Coord.u - Center.u); if(u<0) u -= uWidth;
	bool b1 = (int(u / uWidth) % 2) == 0,
		 b2 = (int(v / vWidth) % 2) == 0;
	if((b1 && b2) || (!b1 && !b2))
		return Color1;
	else
		return Color2;
}

void CheckerboardTexture::Load(const XMLNode * tn)
{
	DEBUG("Loading Checkerboard texture.")
	for(NodeIterator itr=tn->Children.begin();
	 itr != tn->Children.end();itr++)
	{
		if((*itr)->Name == "Center")
		{
			Center.u = ParseDouble((*itr)->Content);
			Center.v = ParseDouble((*itr)->Content.
							 substr((*itr)->Content.find_first_of(",")+1));
		}
		else if((*itr)->Name == "Color1")
		{
			ParseColor((*itr)->Content,Color1);
			PRINT(Color1)
		}
		else if((*itr)->Name == "Color2")
		{
			ParseColor((*itr)->Content,Color2);
			PRINT(Color2)
		}
		else if((*itr)->Name == "uWidth")
		{
			uWidth = ParseDouble((*itr)->Content);
			PRINT(uWidth)
		}
		else if((*itr)->Name == "vWidth")
		{
			vWidth = ParseDouble((*itr)->Content);
			PRINT(vWidth)
		}
	}	
}
