#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/times.h>
#include <signal.h>

struct timeval tp1, tp2;
struct tms tms1, tms2;
struct timezone tzp;
#define ITIME	10		/* Number of seconds to run test. */

main()
{
	extern	stop();
	struct	itimerval	itv;

	printf("Testing HZ for %d seconds of virtual time ...\n", ITIME);
	
	(void) signal(SIGVTALRM, stop);
	itv.it_interval.tv_sec = 0;
	itv.it_interval.tv_usec = 0;
	itv.it_value.tv_sec = ITIME;
	itv.it_value.tv_usec = 0;
	if (setitimer(ITIMER_VIRTUAL, &itv, (struct itimerval *)NULL))
		{ perror("setitimer"); exit(1); }
	if (gettimeofday(&tp1, &tzp))
		perror("gettimeofday"), exit(1);
	(void) times(&tms1);
	for (;;) {}
}

stop()
{
	long sec, usec;
	time_t ut, st;

	if (gettimeofday(&tp2, &tzp))
		perror("gettimeofday"), exit(1);
	(void) times(&tms2);
	ut = tms2.tms_utime - tms1.tms_utime;
	st = tms2.tms_stime - tms1.tms_stime;
	sec = tp2.tv_sec - tp1.tv_sec;
	usec = tp2.tv_usec - tp1.tv_usec;
	if (usec < 0) {
		usec += 1000000;
		sec -= 1;
	}
	printf("elapsed time: %d.%06d (%d virtual secs)\n", sec, usec, ITIME);
	printf("virtual time in HZ: %d+%d\n", ut, st);
	printf("HZ is about %g\n", (double)ut/ITIME);
	exit(0);
}
