/*
 *  zw_server.c
 */

#include "proto.h"

char *get_sig_f_name ();

int
main (int argc, char *argv[])
{
  char *fsig_name = NULL, **sig = NULL, ch;
  u_char control;
  u_short port = PORT;
  int srv_sockfd, cli_sockfd, cli_len, arg;
  int num_sigs, cur_sig = -1, reuse_flag = 1;
  struct sockaddr_in srv_addr, cli_addr;

  while ((arg = getopt (argc, argv, "p:f:")) != EOF)
  {
    switch (arg)
    {
    case 'p':
      sscanf (optarg, "%hu", &port);
      break;
    case 'f':
      fsig_name = optarg;
      break;
    }
  }
  srandom (time (0));
  if (fsig_name == NULL)
    fsig_name = get_sig_f_name ();
  read_sigs (&sig, fsig_name, &num_sigs);
  if ((srv_sockfd = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    fatal ("socket");
  if (setsockopt (srv_sockfd, SOL_SOCKET, SO_REUSEADDR, (char *) &reuse_flag, sizeof (reuse_flag)) == -1)
    fatal ("setsockopt");
  srv_addr.sin_family = AF_INET;
  srv_addr.sin_port = port;
  srv_addr.sin_addr.s_addr = htonl (INADDR_ANY);
  if (bind (srv_sockfd, (struct sockaddr *) &srv_addr, sizeof (srv_addr)) < 0)
    fatal ("bind");
  if ((listen (srv_sockfd, 5)) < 0)
    fatal ("listen");
  signal (SIGCLD, handle_sigcld);
  do
  {
    cli_len = sizeof (struct sockaddr_in);
    cli_sockfd = accept (srv_sockfd, (struct sockaddr *) &cli_addr, &cli_len);
    if (cli_sockfd > 0)
    {
      read (cli_sockfd, &control, 1);
      if (control & EXIT_MASK)
      {
	close (srv_sockfd);
	return EXIT_SUCCESS;
      }
      else if (control & RELOAD_MASK)
      {
	fsig_name = get_sig_f_name ();
	read_sigs (&sig, fsig_name, &num_sigs);
	cur_sig = -1;
      }
      else if (control & SET_FILE)
      {
	read_line (cli_sockfd, fsig_name);
	read_sigs (&sig, fsig_name, &num_sigs);
	cur_sig = -1;
      }
      else
      {
	if (control & SEQ_MASK)
	{
	  if (++ cur_sig > num_sigs)
	    cur_sig = 0;
	}
	else
	  cur_sig = random () % (num_sigs + 1);
/*	printf ("%d %d\n", num_sigs, cur_sig); */
	switch (fork ())
	{
	case 0:
	  close (srv_sockfd);
	  if (write (cli_sockfd, &cur_sig, 
		     sizeof (cur_sig)) == -1)
	    fatal ("write");
	  if (write (cli_sockfd, sig[cur_sig], 
		     strlen (sig[cur_sig]) + 1) == -1)
	    fatal ("write");
	  while (control & INTERACTIVE_MASK)
	  {
	    if (read (cli_sockfd, &ch, 1) == -1)
	      fatal ("read");
	    switch (ch)
	    {
	    case '\012':
	      control &= ~INTERACTIVE_MASK;
	      break;
	    case '\020':
	      if (-- cur_sig < 0)
		cur_sig = num_sigs;
	      if (write (cli_sockfd, &cur_sig, 
			 sizeof (cur_sig)) == -1)
		fatal ("write");
	      if (write (cli_sockfd, sig[cur_sig], 
			 strlen (sig[cur_sig]) + 1) == -1)
		fatal ("write");
	      break;
	    case '\016':
	      if (++ cur_sig > num_sigs)
		cur_sig = 0;
	      if (write (cli_sockfd, &cur_sig, 
			 sizeof (cur_sig)) == -1)
		fatal ("write");
	      if (write (cli_sockfd, sig[cur_sig], 
			 strlen (sig[cur_sig]) + 1) == -1)
		fatal ("write");
	      break;
	    }
	  }
	  exit (0);
	case -1:
	  fatal ("fork");
	}
      }
      close (cli_sockfd);
    }
  } while (1);
}

void read_sigs (char ***sig, char *f_name, int *num_sigs)
{
  FILE *fd;
  int i;

  if (*sig != NULL)
    for (i = 0; i < (*num_sigs); i ++)
      free ((*sig)[i]);
  free (*sig);
  if ((fd = fopen (f_name, "r")) == NULL)
    fatal ("fopen");
  if (((*sig) = malloc (sizeof (char *) * SIG_INC_SIZE)) == NULL)
    fatal ("malloc");

  for ((*num_sigs) = 0; ; (*num_sigs)++)
  {
    if (((*num_sigs) % 16) == 0)
      if (((*sig) = realloc (*sig, sizeof (char *) * ((*num_sigs) + SIG_INC_SIZE))) == NULL)
	fatal ("realloc");
    if ((((*sig)[*num_sigs]) = malloc (sizeof (char) * SIG_SIZE_EST)) == NULL)
      fatal ("malloc");
    if ((fgets ((*sig)[(*num_sigs)], SIG_SIZE_EST - 1, fd)) == NULL)
      break;
  }
  (*num_sigs) --;
}

char *get_sig_f_name ()
{
  FILE *fd;
  char conf_file[MAXPATHLEN], fsig_name[MAXPATHLEN], *cr_ptr;
  int ch;

  strcat (strcpy (conf_file, getenv ("HOME")), "/.zsig");
  if ((fd = fopen (conf_file, "r")) == NULL)
    fatal ("fopen");
  
  if ((ch = fgetc (fd)) == EOF)
    fatal ("fgetc");
  switch (ch)
  {
  case '~':
    strcpy (fsig_name, getenv ("HOME"));
    if ((fgets (fsig_name + strlen (fsig_name), MAXPATHLEN, fd)) == NULL)
      fatal ("fgets");      
    break;
  case '/':
    strcpy (fsig_name, "/");
    if ((fgets (fsig_name + strlen (fsig_name), MAXPATHLEN, fd)) == NULL)
      fatal ("fgets");
    break;
  default:
    fprintf (stderr, "zw: %s: Relative zsig file name not allowed\n", fsig_name), exit (-1);
  }
  if ((cr_ptr = strchr (fsig_name, (int) '\n')) != NULL)
    *cr_ptr = 0;
  return (fsig_name);
}












